/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal.impl;

import com.vmware.cis.license.common.misc.DateUtil;
import com.vmware.cis.license.common.misc.Util;
import com.vmware.license.myvmware.client.sync.internal.AccountDetails;
import com.vmware.license.myvmware.client.sync.internal.ActivityDetails;
import com.vmware.license.myvmware.client.sync.internal.ContractDetails;
import com.vmware.license.myvmware.client.sync.internal.LicenseKeyDetails;
import com.vmware.license.myvmware.client.sync.internal.LicenseKeyDetailsBuilder;
import com.vmware.license.myvmware.client.sync.internal.OrderDetails;
import com.vmware.license.myvmware.client.sync.internal.inventoryreport.impl.LicenseInventoryReportSchema;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LicenseKeyDetailsBuilderImpl
implements LicenseKeyDetailsBuilder {
    private static final char CUSTOM_LABEL_KEY_VALUE_SEPARATOR = ':';
    private static final String SOURCE_KEYS_SEPARATOR = ";";
    private static final int INVALID_VALUE = -1;
    private static final String[] FALLBACK_DATE_PATTERNS = new String[]{"M/d/yyyy"};
    private final String _reportVersion;
    private final Map<String, AccountDetails> _accountNumberToAccountDetails;
    private final Map<String, LicenseKeyDetails> _licenseKeyToLicenseKeyDetails;
    private int _resultCode = 0;

    public LicenseKeyDetailsBuilderImpl(String reportVersion) {
        this._reportVersion = reportVersion;
        this._accountNumberToAccountDetails = new HashMap<String, AccountDetails>();
        this._licenseKeyToLicenseKeyDetails = new LinkedHashMap<String, LicenseKeyDetails>();
    }

    @Override
    public void build(String[] items) {
        String licenseKey = items[LicenseInventoryReportSchema.Columns.LICENSE_KEY.getColumnIndex()];
        if (Util.isNullOrEmpty((String)licenseKey)) {
            return;
        }
        LicenseKeyDetails licenseKeyDetails = this._licenseKeyToLicenseKeyDetails.get(licenseKey);
        if (licenseKeyDetails == null) {
            licenseKeyDetails = this.buildBaseLicenseKeyDetails(items);
        }
        this.buildAdditionalLicenseKeyDetails(licenseKeyDetails, items);
        this._licenseKeyToLicenseKeyDetails.put(licenseKey, licenseKeyDetails);
    }

    @Override
    public Collection<LicenseKeyDetails> getResult() {
        return this._licenseKeyToLicenseKeyDetails.values();
    }

    @Override
    public int getResultCode() {
        return this._resultCode;
    }

    private LicenseKeyDetails buildBaseLicenseKeyDetails(String[] items) {
        LicenseKeyDetails licenseKeyDetails = new LicenseKeyDetails();
        licenseKeyDetails.accountDetails = this.buildAccountDetails(items);
        licenseKeyDetails.productName = items[LicenseInventoryReportSchema.Columns.PRODUCT_NAME.getColumnIndex()];
        licenseKeyDetails.licenseKey = items[LicenseInventoryReportSchema.Columns.LICENSE_KEY.getColumnIndex()];
        licenseKeyDetails.licenseQuantity = this.parseLongOrReturnInvalid(items[LicenseInventoryReportSchema.Columns.LICENSE_QUANTITY.getColumnIndex()]);
        licenseKeyDetails.unitOfMeasure = items[LicenseInventoryReportSchema.Columns.UNIT_OF_MEASURE.getColumnIndex()];
        licenseKeyDetails.folderLocation = items[LicenseInventoryReportSchema.Columns.FOLDER_LOCATION.getColumnIndex()];
        licenseKeyDetails.licenseKeyNotes = items[LicenseInventoryReportSchema.Columns.LICENSE_KEY_NOTES.getColumnIndex()];
        licenseKeyDetails.customLabels = this.buildCustomLabels(items);
        licenseKeyDetails.orderDetails = new OrderDetails[0];
        licenseKeyDetails.contractDetails = new ContractDetails[0];
        if (this.isReportVersionV2()) {
            licenseKeyDetails.activityDetails = new ActivityDetails[0];
        }
        return licenseKeyDetails;
    }

    private void buildAdditionalLicenseKeyDetails(LicenseKeyDetails licenseKeyDetails, String[] items) {
        String type = items[LicenseInventoryReportSchema.Columns.TYPE.getColumnIndex()];
        if ("ORDER".equalsIgnoreCase(type)) {
            OrderDetails orderDetails = this.buildOrderDetails(items);
            List<OrderDetails> mergedOrderDetails = LicenseKeyDetailsBuilderImpl.mergeItems(licenseKeyDetails.orderDetails, orderDetails);
            licenseKeyDetails.orderDetails = mergedOrderDetails.toArray(new OrderDetails[mergedOrderDetails.size()]);
        } else if ("CONTRACT".equalsIgnoreCase(type)) {
            ContractDetails contractDetails = this.buildContractDetails(items);
            List<ContractDetails> mergedContractDetails = LicenseKeyDetailsBuilderImpl.mergeItems(licenseKeyDetails.contractDetails, contractDetails);
            licenseKeyDetails.contractDetails = mergedContractDetails.toArray(new ContractDetails[mergedContractDetails.size()]);
        } else if (this.isReportVersionV2() && "HISTORY".equalsIgnoreCase(type)) {
            ActivityDetails activityDetails = this.buildActivityDetails(items);
            List<ActivityDetails> mergedActivityDetails = LicenseKeyDetailsBuilderImpl.mergeItems(licenseKeyDetails.activityDetails, activityDetails);
            licenseKeyDetails.activityDetails = mergedActivityDetails.toArray(new ActivityDetails[mergedActivityDetails.size()]);
        }
    }

    private AccountDetails buildAccountDetails(String[] items) {
        String accountNumber = items[LicenseInventoryReportSchema.Columns.ACCOUNT_NUMBER.getColumnIndex()];
        AccountDetails accountDetails = this._accountNumberToAccountDetails.get(accountNumber);
        if (accountDetails == null) {
            accountDetails = new AccountDetails();
            accountDetails.accountNumber = accountNumber;
            accountDetails.accountName = items[LicenseInventoryReportSchema.Columns.ACCOUNT_NAME.getColumnIndex()];
            this._accountNumberToAccountDetails.put(accountNumber, accountDetails);
        }
        return accountDetails;
    }

    private KeyAnyValue[] buildCustomLabels(String[] items) {
        ArrayList<KeyAnyValue> customLabels = new ArrayList<KeyAnyValue>();
        for (int index = LicenseInventoryReportSchema.CUSTOM_LABEL_IDX_FIRST; index <= LicenseInventoryReportSchema.CUSTOM_LABEL_IDX_LAST; ++index) {
            KeyAnyValue customLabel;
            String customLabelAsString = items[index];
            if (Util.isNullOrEmpty((String)customLabelAsString) || (customLabel = this.buildCustomLabel(customLabelAsString)) == null) continue;
            customLabels.add(customLabel);
        }
        return customLabels.toArray(new KeyAnyValue[customLabels.size()]);
    }

    private KeyAnyValue buildCustomLabel(String customLabelAsString) {
        int separatorIdx = customLabelAsString.indexOf(58);
        if (separatorIdx == -1) {
            return null;
        }
        String key = customLabelAsString.substring(0, separatorIdx).trim();
        String value = customLabelAsString.substring(separatorIdx + 1).trim();
        KeyAnyValueImpl customLabel = new KeyAnyValueImpl();
        customLabel.setKey(key);
        customLabel.setValue((Object)value);
        return customLabel;
    }

    private OrderDetails buildOrderDetails(String[] items) {
        OrderDetails orderDetails = new OrderDetails();
        orderDetails.type = items[LicenseInventoryReportSchema.Columns.TYPE.getColumnIndex()];
        orderDetails.number = items[LicenseInventoryReportSchema.Columns.NUMBER.getColumnIndex()];
        orderDetails.orderQuantity = this.parseLongOrReturnInvalid(items[LicenseInventoryReportSchema.Columns.ORDER_QUANTITY.getColumnIndex()]);
        orderDetails.orderDate = this.parseDateOrReturnNull(items[LicenseInventoryReportSchema.Columns.ORDER_DATE.getColumnIndex()]);
        if (this.isReportVersionV2()) {
            orderDetails.poNumber = items[LicenseInventoryReportSchema.Columns.PO_NUMBER.getColumnIndex()];
        }
        return orderDetails;
    }

    private ContractDetails buildContractDetails(String[] items) {
        ContractDetails contractDetails = new ContractDetails();
        contractDetails.type = items[LicenseInventoryReportSchema.Columns.TYPE.getColumnIndex()];
        contractDetails.number = items[LicenseInventoryReportSchema.Columns.NUMBER.getColumnIndex()];
        contractDetails.licenseCoverageStartDate = this.parseDateOrReturnNull(items[LicenseInventoryReportSchema.Columns.LICENSE_COVERAGE_START_DATE.getColumnIndex()]);
        contractDetails.licenseCoverageEndDate = this.parseDateOrReturnNull(items[LicenseInventoryReportSchema.Columns.LICENSE_COVERAGE_END_DATE.getColumnIndex()]);
        contractDetails.supportLevel = items[LicenseInventoryReportSchema.Columns.SUPPORT_LEVEL.getColumnIndex()];
        contractDetails.ELAFlag = items[LicenseInventoryReportSchema.Columns.ELA_FLAG.getColumnIndex()];
        return contractDetails;
    }

    private ActivityDetails buildActivityDetails(String[] items) {
        ActivityDetails activityDetails = new ActivityDetails();
        activityDetails.level = this.parseIntOrReturnInvalid(items[LicenseInventoryReportSchema.Columns.LEVEL.getColumnIndex()]);
        activityDetails.activity = items[LicenseInventoryReportSchema.Columns.ACTIVITY.getColumnIndex()];
        activityDetails.activityDate = this.parseDateOrReturnNull(items[LicenseInventoryReportSchema.Columns.ACTIVITY_DATE.getColumnIndex()]);
        activityDetails.performedBy = items[LicenseInventoryReportSchema.Columns.PERFORMED_BY.getColumnIndex()];
        String sourceKeysAsString = items[LicenseInventoryReportSchema.Columns.SOURCE_KEYS.getColumnIndex()];
        if (!Util.isNullOrEmpty((String)sourceKeysAsString)) {
            activityDetails.sourceKeysMasked = sourceKeysAsString.split(SOURCE_KEYS_SEPARATOR);
        }
        return activityDetails;
    }

    private boolean isReportVersionV2() {
        return "V2".equals(this._reportVersion);
    }

    private Date parseDateOrReturnNull(String dateAsString) {
        if (Util.isNullOrEmpty((String)dateAsString)) {
            this.setResultCodeInvalidDate();
            return null;
        }
        try {
            return DateUtil.parseISODate((String)dateAsString);
        }
        catch (ParseException e) {
            Date date = this.parseDateWithPatterns(dateAsString, FALLBACK_DATE_PATTERNS);
            if (date == null) {
                this.setResultCodeInvalidDate();
            }
            return date;
        }
    }

    private Date parseDateWithPatterns(String dateAsString, String[] datePatterns) {
        Date date = null;
        for (String datePattern : datePatterns) {
            try {
                date = DateUtil.parseDateWithPattern((String)dateAsString, (String)datePattern);
                break;
            }
            catch (ParseException e) {
            }
        }
        return date;
    }

    private long parseLongOrReturnInvalid(String longAsString) {
        try {
            return Long.parseLong(longAsString);
        }
        catch (NumberFormatException e) {
            this.setResultCodeInvalidNumber();
            return -1L;
        }
    }

    private int parseIntOrReturnInvalid(String intAsString) {
        try {
            return Integer.parseInt(intAsString);
        }
        catch (NumberFormatException e) {
            this.setResultCodeInvalidNumber();
            return -1;
        }
    }

    private void setResultCodeInvalidDate() {
        this._resultCode |= 1;
    }

    private void setResultCodeInvalidNumber() {
        this._resultCode |= 2;
    }

    private static <T> List<T> mergeItems(T[] items1, T ... items2) {
        if (Util.isNullOrEmpty((Object[])items1) && Util.isNullOrEmpty((Object[])items2)) {
            return Collections.emptyList();
        }
        ArrayList<T> mergedItems = new ArrayList<T>();
        if (!Util.isNullOrEmpty((Object[])items1)) {
            mergedItems.addAll(Arrays.asList(items1));
        }
        if (!Util.isNullOrEmpty((Object[])items2)) {
            mergedItems.addAll(Arrays.asList(items2));
        }
        return mergedItems;
    }
}

