/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal.impl;

import com.vmware.cis.license.common.misc.Util;
import com.vmware.cis.license.common.serialization.SerializeException;
import com.vmware.cis.license.common.vmodl.VmodlUtil;
import com.vmware.license.myvmware.client.sync.internal.EncodeUtil;
import com.vmware.license.myvmware.client.sync.internal.LicenseKeyDetails;
import com.vmware.license.myvmware.client.sync.internal.MyVMwareSyncManager;
import com.vmware.license.myvmware.client.sync.internal.MyVMwareSyncPreviewResult;
import com.vmware.license.myvmware.client.sync.internal.RecordWriterFactory;
import com.vmware.license.myvmware.client.sync.internal.ReportReaderFactory;
import com.vmware.license.myvmware.client.sync.internal.impl.CsvLicenseInventoryReportReaderFactoryImpl;
import com.vmware.license.myvmware.client.sync.internal.impl.CsvRecordWriterFactoryImpl;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportData;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportGenerator;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportUtil;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportWriteException;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.impl.InactiveLicensesReportGeneratorImpl;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.impl.UpgradedLicensesReportGeneratorImpl;
import com.vmware.license.myvmware.client.sync.internal.inventoryreport.LicenseInventoryReportParseException;
import com.vmware.license.myvmware.client.sync.internal.inventoryreport.LicenseInventoryReportParseResult;
import com.vmware.license.myvmware.client.sync.internal.inventoryreport.impl.LicenseInventoryReportParserImpl;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.LicenseProductCapability;
import com.vmware.vim.binding.cis.license.MyVMwareLicenseDetails;
import com.vmware.vim.binding.cis.license.SerialKeyLicenseInfo;
import com.vmware.vim.binding.cis.license.management.InactiveLicensesReport;
import com.vmware.vim.binding.impl.cis.license.MyVMwareLicenseDetailsImpl;
import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareSyncManagerImpl
implements MyVMwareSyncManager {
    private static final Log _log = LogFactory.getLog(MyVMwareSyncManagerImpl.class);
    private final ReportReaderFactory _reportReaderFactory = new CsvLicenseInventoryReportReaderFactoryImpl();
    private final RecordWriterFactory _recordWriterFactory = new CsvRecordWriterFactoryImpl();
    private final boolean _shouldDecompressReport;
    private final boolean _shouldCompressInactiveReport;

    public MyVMwareSyncManagerImpl(boolean shouldDecompressReport, boolean shouldCompressInactiveReport) {
        this._shouldDecompressReport = shouldDecompressReport;
        this._shouldCompressInactiveReport = shouldCompressInactiveReport;
    }

    @Override
    public MyVMwareSyncPreviewResult previewMyVMwareSync(byte[] myVMwareLicenseReportData, License[] inventoryLicenses, MyVMwareSyncManager.PreviewLicensesCallback previewLicensesCallback) throws LicenseInventoryReportParseException {
        this.validateMyVmwareReportData(myVMwareLicenseReportData);
        LicenseInventoryReportParseResult licenseInventoryReportParseResult = this.parseMyVmwareReport(myVMwareLicenseReportData);
        LicenseKeyDetails[] myVMwareLicenses = licenseInventoryReportParseResult.getLicenseKeysDetails();
        int inventoryLicensesTotal = MyVMwareSyncManagerImpl.calculateInventoryLicensesTotal(inventoryLicenses);
        License[] matchedLicenses = this.getMatchingLicenses(myVMwareLicenses, inventoryLicenses);
        LicenseInfo[] newLicenses = this.getNewLicenses(myVMwareLicenses, inventoryLicenses, previewLicensesCallback);
        Map<String, License> inactiveSerialKeyToInventoryLicense = this.getInactiveInventorySerialKeysAndLicenses(inventoryLicenses, myVMwareLicenses);
        Map<LicenseKeyDetails, LicenseInfo> myVMwareLicenseToDecodedLicenseInfo = this.getMyVMwareLicenseToDecodedLicenseInfo(myVMwareLicenses, newLicenses, matchedLicenses);
        InactiveLicensesReport inactiveLicensesReport = this.generateInactiveLicensesReport(inactiveSerialKeyToInventoryLicense, myVMwareLicenseToDecodedLicenseInfo);
        InactiveLicensesReport upgradedLicensesReport = this.generateUpgradedLicensesReport(inactiveSerialKeyToInventoryLicense, myVMwareLicenseToDecodedLicenseInfo);
        return MyVMwareSyncManagerImpl.buildMyVMwareSyncPreviewResult(inventoryLicensesTotal, matchedLicenses, newLicenses, inactiveLicensesReport, upgradedLicensesReport, licenseInventoryReportParseResult.getResultCode());
    }

    @Override
    public Map<String, License> findInactiveInventoryLicenses(byte[] myVMwareLicenseReportData, License[] inventoryLicenses) throws LicenseInventoryReportParseException {
        if (Util.isNullOrEmpty((Object[])inventoryLicenses)) {
            return Collections.emptyMap();
        }
        this.validateMyVmwareReportData(myVMwareLicenseReportData);
        LicenseInventoryReportParseResult licenseInventoryReportParseResult = this.parseMyVmwareReport(myVMwareLicenseReportData);
        LicenseKeyDetails[] myVMwareLicenses = licenseInventoryReportParseResult.getLicenseKeysDetails();
        Map<String, License> inactiveSerialKeyToInventoryLicense = this.getInactiveInventorySerialKeysAndLicenses(inventoryLicenses, myVMwareLicenses);
        return inactiveSerialKeyToInventoryLicense;
    }

    private void validateMyVmwareReportData(byte[] myVMwareLicenseReportData) {
        if (myVMwareLicenseReportData == null || myVMwareLicenseReportData.length == 0) {
            throw new IllegalArgumentException("MyVMware license report data be empty byte array");
        }
    }

    private LicenseInventoryReportParseResult parseMyVmwareReport(byte[] myVMwareLicenseReportData) throws LicenseInventoryReportParseException {
        LicenseInventoryReportParserImpl parser = new LicenseInventoryReportParserImpl(this._reportReaderFactory);
        LicenseInventoryReportParseResult result = parser.parseCsvReport(myVMwareLicenseReportData, this._shouldDecompressReport);
        return result;
    }

    private License[] getMatchingLicenses(LicenseKeyDetails[] myVMwareLicenses, License[] inventoryLicenses) {
        Map<License, List<LicenseKeyDetails>> inventoryLicenseToMyVMwareLicenses = this.findMatchingLicenses(myVMwareLicenses, inventoryLicenses);
        return this.previewUpdatedLicenses(inventoryLicenseToMyVMwareLicenses);
    }

    private LicenseInfo[] getNewLicenses(LicenseKeyDetails[] myVMwareLicenses, License[] inventoryLicenses, MyVMwareSyncManager.PreviewLicensesCallback previewLicensesCallback) {
        List<LicenseKeyDetails> newMyVmwareLicenseKeyDetails = this.findNewMyVMwareLicenses(myVMwareLicenses, inventoryLicenses);
        LicenseInfo[] newLicenseInfos = this.previewNewLicenseInfos(newMyVmwareLicenseKeyDetails, previewLicensesCallback);
        return newLicenseInfos;
    }

    private Map<String, License> getInactiveInventorySerialKeysAndLicenses(License[] inventoryLicenses, LicenseKeyDetails[] myVMwareLicenses) {
        if (Util.isNullOrEmpty((Object[])inventoryLicenses)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, License> inactiveSerialKeyToInventoryLicense = new LinkedHashMap<String, License>();
        Map<String, License> serialKeyToInventoryLicense = MyVMwareSyncManagerImpl.buildSerialKeyToInventoryLicenseMap(inventoryLicenses);
        for (Map.Entry<String, License> entry : serialKeyToInventoryLicense.entrySet()) {
            String serialKey = entry.getKey();
            License inventoryLicense = entry.getValue();
            if (!MyVMwareSyncManagerImpl.isSerialKeyPresentInHistory(serialKey, myVMwareLicenses)) continue;
            inactiveSerialKeyToInventoryLicense.put(serialKey, inventoryLicense);
        }
        return inactiveSerialKeyToInventoryLicense;
    }

    private Map<LicenseKeyDetails, LicenseInfo> getMyVMwareLicenseToDecodedLicenseInfo(LicenseKeyDetails[] myVMwareLicenses, LicenseInfo[] newLicenses, License[] matchedLicenses) {
        LinkedHashMap<LicenseKeyDetails, LicenseInfo> myVMwareLicenseToDecodedLicenseInfo = new LinkedHashMap<LicenseKeyDetails, LicenseInfo>();
        for (LicenseKeyDetails myVMwareLicense : myVMwareLicenses) {
            String serialKey = myVMwareLicense.licenseKey;
            LicenseInfo decodedLicenseInfo = null;
            for (LicenseInfo licenseInfo : newLicenses) {
                if (!MyVMwareSyncManagerImpl.containsSerialKey(licenseInfo, serialKey)) continue;
                decodedLicenseInfo = licenseInfo;
                break;
            }
            if (decodedLicenseInfo == null) {
                for (LicenseInfo licenseInfo : matchedLicenses) {
                    if (!MyVMwareSyncManagerImpl.containsSerialKey(licenseInfo.getInfo(), serialKey)) continue;
                    decodedLicenseInfo = licenseInfo.getInfo();
                    break;
                }
            }
            myVMwareLicenseToDecodedLicenseInfo.put(myVMwareLicense, decodedLicenseInfo);
        }
        return myVMwareLicenseToDecodedLicenseInfo;
    }

    private InactiveLicensesReport generateInactiveLicensesReport(Map<String, License> inactiveSerialKeyToInventoryLicense, Map<LicenseKeyDetails, LicenseInfo> myVMwareLicenseToDecodedLicenseInfo) {
        return this.generateInactiveLicensesReport(new InactiveLicensesReportGeneratorImpl(this._recordWriterFactory), inactiveSerialKeyToInventoryLicense, myVMwareLicenseToDecodedLicenseInfo);
    }

    private InactiveLicensesReport generateUpgradedLicensesReport(Map<String, License> inactiveSerialKeyToInventoryLicense, Map<LicenseKeyDetails, LicenseInfo> myVMwareLicenseToDecodedLicenseInfo) {
        return this.generateInactiveLicensesReport(new UpgradedLicensesReportGeneratorImpl(this._recordWriterFactory), inactiveSerialKeyToInventoryLicense, myVMwareLicenseToDecodedLicenseInfo);
    }

    private InactiveLicensesReport generateInactiveLicensesReport(InactiveLicensesReportGenerator inactiveLicensesReportGenerator, Map<String, License> inactiveSerialKeyToInventoryLicense, Map<LicenseKeyDetails, LicenseInfo> myVMwareLicenseToDecodedLicenseInfo) {
        InactiveLicensesReport inactiveLicensesReport;
        block4: {
            if (Util.isNullOrEmpty(inactiveSerialKeyToInventoryLicense)) {
                return null;
            }
            Map<String, List<LicenseKeyDetails>> inactiveSerialKeyToReplacementMyVMwareLicenses = MyVMwareSyncManagerImpl.getInactiveSerialKeyToReplacementMyVMwareLicenses(inactiveSerialKeyToInventoryLicense.keySet(), myVMwareLicenseToDecodedLicenseInfo.keySet());
            inactiveLicensesReport = null;
            if (!Util.isNullOrEmpty(inactiveSerialKeyToReplacementMyVMwareLicenses)) {
                InactiveLicensesReportData[] inactiveLicensesReportData = MyVMwareSyncManagerImpl.buildInactiveLicensesReportData(inactiveSerialKeyToInventoryLicense, inactiveSerialKeyToReplacementMyVMwareLicenses, myVMwareLicenseToDecodedLicenseInfo);
                try {
                    inactiveLicensesReport = inactiveLicensesReportGenerator.generateReport(inactiveLicensesReportData, this._shouldCompressInactiveReport);
                }
                catch (InactiveLicensesReportWriteException e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)"Failed to generate inactive licenses report", (Throwable)e);
                }
            }
        }
        return inactiveLicensesReport;
    }

    private Map<License, List<LicenseKeyDetails>> findMatchingLicenses(LicenseKeyDetails[] myVMwareLicenses, License[] inventoryLicenses) {
        LinkedHashMap<License, List<LicenseKeyDetails>> inventoryLicenseToMyVMwareLicenses = new LinkedHashMap<License, List<LicenseKeyDetails>>();
        if (Util.isNullOrEmpty((Object[])inventoryLicenses)) {
            return inventoryLicenseToMyVMwareLicenses;
        }
        Map<String, License> serialKeyToInventoryLicense = MyVMwareSyncManagerImpl.buildSerialKeyToInventoryLicenseMap(inventoryLicenses);
        for (LicenseKeyDetails myVMwareLicense : myVMwareLicenses) {
            License matchingLicense = serialKeyToInventoryLicense.get(myVMwareLicense.licenseKey);
            if (matchingLicense == null) continue;
            ArrayList<LicenseKeyDetails> mappedMyVmwareLicenses = (ArrayList<LicenseKeyDetails>)inventoryLicenseToMyVMwareLicenses.get(matchingLicense);
            if (mappedMyVmwareLicenses == null) {
                mappedMyVmwareLicenses = new ArrayList<LicenseKeyDetails>();
                inventoryLicenseToMyVMwareLicenses.put(matchingLicense, mappedMyVmwareLicenses);
            }
            mappedMyVmwareLicenses.add(myVMwareLicense);
        }
        return inventoryLicenseToMyVMwareLicenses;
    }

    private List<LicenseKeyDetails> findNewMyVMwareLicenses(LicenseKeyDetails[] myVMwareLicenses, License[] inventoryLicenses) {
        if (Util.isNullOrEmpty((Object[])inventoryLicenses)) {
            return Arrays.asList(myVMwareLicenses);
        }
        ArrayList<LicenseKeyDetails> newMyVMwareLicense = new ArrayList<LicenseKeyDetails>();
        Map<String, License> serialKeyToInventoryLicense = MyVMwareSyncManagerImpl.buildSerialKeyToInventoryLicenseMap(inventoryLicenses);
        for (LicenseKeyDetails myVMwareLicense : myVMwareLicenses) {
            License matchingLicense = serialKeyToInventoryLicense.get(myVMwareLicense.licenseKey);
            if (matchingLicense != null) continue;
            newMyVMwareLicense.add(myVMwareLicense);
        }
        return newMyVMwareLicense;
    }

    private License[] previewUpdatedLicenses(Map<License, List<LicenseKeyDetails>> inventoryLicenseToMyVMwareLicenses) {
        MyVMwareSyncManagerImpl.decorateLicensesWithMetadata(inventoryLicenseToMyVMwareLicenses);
        Set<License> resultLicenses = inventoryLicenseToMyVMwareLicenses.keySet();
        return resultLicenses.toArray(new License[resultLicenses.size()]);
    }

    private LicenseInfo[] previewNewLicenseInfos(List<LicenseKeyDetails> newMyVmwareLicenseKeyDetails, MyVMwareSyncManager.PreviewLicensesCallback previewLicensesCallback) {
        ArrayList<String> serialKeys = new ArrayList<String>();
        for (LicenseKeyDetails licenseKeyDetails : newMyVmwareLicenseKeyDetails) {
            serialKeys.add(licenseKeyDetails.licenseKey);
        }
        LicenseInfo[] newLicenseInfos = previewLicensesCallback.previewLicenses(serialKeys.toArray(new String[serialKeys.size()]));
        Map<LicenseInfo, LicenseKeyDetails> newLicenseInfoToMyVmwareLicense = MyVMwareSyncManagerImpl.buildNewLicenseInfoToMyVmwareLicense(newLicenseInfos, newMyVmwareLicenseKeyDetails);
        MyVMwareSyncManagerImpl.decorateLicenseInfosWithMetadata(newLicenseInfoToMyVmwareLicense);
        int size = newLicenseInfoToMyVmwareLicense.keySet().size();
        return newLicenseInfoToMyVmwareLicense.keySet().toArray(new LicenseInfo[size]);
    }

    private static int calculateInventoryLicensesTotal(License[] inventoryLicenses) {
        int inventoryLicensesTotal = !Util.isNullOrEmpty((Object[])inventoryLicenses) ? inventoryLicenses.length : 0;
        return inventoryLicensesTotal;
    }

    private static void decorateLicensesWithMetadata(Map<License, List<LicenseKeyDetails>> inventoryLicenseToMyVMwareLicenses) {
        for (Map.Entry<License, List<LicenseKeyDetails>> entry : inventoryLicenseToMyVMwareLicenses.entrySet()) {
            License license = entry.getKey();
            List<LicenseKeyDetails> myVMwareLicenses = entry.getValue();
            MyVMwareSyncManagerImpl.decorateLicenseInfoWithMetadata(license.getInfo(), myVMwareLicenses);
        }
    }

    private static void decorateLicenseInfosWithMetadata(Map<LicenseInfo, LicenseKeyDetails> inventoryLicenseInfoToMyVMwareLicense) {
        for (Map.Entry<LicenseInfo, LicenseKeyDetails> entry : inventoryLicenseInfoToMyVMwareLicense.entrySet()) {
            LicenseInfo licenseInfo = entry.getKey();
            LicenseKeyDetails myVMwareLicense = entry.getValue();
            MyVMwareSyncManagerImpl.decorateLicenseInfoWithMetadata(licenseInfo, Arrays.asList(myVMwareLicense));
        }
    }

    private static void decorateLicenseInfoWithMetadata(LicenseInfo licenseInfo, List<LicenseKeyDetails> myVMwareLicenses) {
        KeyAnyValue[] mergedProperties = MyVMwareSyncManagerImpl.addMetadataToProperties(licenseInfo.getProperties(), myVMwareLicenses);
        licenseInfo.setProperties(mergedProperties);
        LicenseProductCapability capability = licenseInfo.getRestrictions()[0].getCapability()[0];
        mergedProperties = MyVMwareSyncManagerImpl.addMetadataToProperties(capability.getProperties(), myVMwareLicenses);
        capability.setProperties(mergedProperties);
    }

    private static KeyAnyValue[] addMetadataToProperties(KeyAnyValue[] properties, List<LicenseKeyDetails> myVMwareLicenses) {
        ArrayList<Object> mergedProperties = new ArrayList<Object>();
        Object[] newProperties = VmodlUtil.removeKeyValue((String)"myVMwareLicenseDetails", (KeyAnyValue[])properties);
        if (!Util.isNullOrEmpty((Object[])newProperties)) {
            mergedProperties.addAll(Arrays.asList(newProperties));
        }
        for (LicenseKeyDetails myVMwareLicense : myVMwareLicenses) {
            MyVMwareLicenseDetails myVMwareLicenseDetails = MyVMwareSyncManagerImpl.buildMyVMwareLicenseDetails(myVMwareLicense);
            VmodlUtil.addKeyValue((String)"myVMwareLicenseDetails", (Object)myVMwareLicenseDetails, mergedProperties);
        }
        return mergedProperties.toArray(new KeyAnyValue[mergedProperties.size()]);
    }

    private static Map<String, License> buildSerialKeyToInventoryLicenseMap(License[] licenses) {
        HashMap<String, License> serialKeyToLicense = new HashMap<String, License>();
        for (License license : licenses) {
            String[] serialKeys;
            for (String serialKey : serialKeys = ((SerialKeyLicenseInfo)license.getInfo()).getSerialKeys()) {
                serialKeyToLicense.put(serialKey, license);
            }
        }
        return serialKeyToLicense;
    }

    private static MyVMwareLicenseDetails buildMyVMwareLicenseDetails(LicenseKeyDetails myVMwareLicense) {
        byte[] data;
        String version = "dev";
        try {
            data = EncodeUtil.encodeLicenseKeyDetails(myVMwareLicense, version);
        }
        catch (SerializeException e) {
            throw new AssertionError((Object)("Failed to encode license data for version: " + version));
        }
        BinaryImpl binaryData = new BinaryImpl(data);
        Calendar lastUpdateTimestamp = null;
        MyVMwareLicenseDetailsImpl myVMwareLicenseDetails = new MyVMwareLicenseDetailsImpl((Binary)binaryData, version, lastUpdateTimestamp);
        return myVMwareLicenseDetails;
    }

    private static Map<LicenseInfo, LicenseKeyDetails> buildNewLicenseInfoToMyVmwareLicense(LicenseInfo[] newLicenseInfos, List<LicenseKeyDetails> newMyVmwareLicenseKeyDetails) {
        LinkedHashMap<LicenseInfo, LicenseKeyDetails> newLicenseInfoToMyVmwareLicense = new LinkedHashMap<LicenseInfo, LicenseKeyDetails>();
        for (LicenseKeyDetails licenseKeyDetails : newMyVmwareLicenseKeyDetails) {
            LicenseInfo licenseInfo = MyVMwareSyncManagerImpl.getLicenseInfoBySerialKey(newLicenseInfos, licenseKeyDetails.licenseKey);
            if (licenseInfo == null) continue;
            newLicenseInfoToMyVmwareLicense.put(licenseInfo, licenseKeyDetails);
        }
        return newLicenseInfoToMyVmwareLicense;
    }

    private static MyVMwareSyncPreviewResult buildMyVMwareSyncPreviewResult(int inventoryLicensesTotal, License[] matchedLicenses, LicenseInfo[] newLicenses, InactiveLicensesReport inactiveLicensesReport, InactiveLicensesReport upgradedLicensesReport, int myVMwareReportParseResultCode) {
        MyVMwareSyncPreviewResult myVMwareSyncPreviewResult = new MyVMwareSyncPreviewResult();
        myVMwareSyncPreviewResult.inventoryLicensesTotal = inventoryLicensesTotal;
        myVMwareSyncPreviewResult.matchedLicenses = matchedLicenses;
        myVMwareSyncPreviewResult.newLicenses = newLicenses;
        myVMwareSyncPreviewResult.inactiveLicensesReport = inactiveLicensesReport;
        myVMwareSyncPreviewResult.upgradedLicensesReport = upgradedLicensesReport;
        myVMwareSyncPreviewResult.myVMwareReportParseResultCode = myVMwareReportParseResultCode;
        return myVMwareSyncPreviewResult;
    }

    private static Map<String, List<LicenseKeyDetails>> getInactiveSerialKeyToReplacementMyVMwareLicenses(Set<String> inactiveSerialKeys, Collection<LicenseKeyDetails> myVMwareLicenses) {
        LinkedHashMap<String, List<LicenseKeyDetails>> inactiveSerialKeyToReplacementMyVMwareLicenses = new LinkedHashMap<String, List<LicenseKeyDetails>>();
        for (String inactiveSerialKey : inactiveSerialKeys) {
            for (LicenseKeyDetails myVMwareLicense : myVMwareLicenses) {
                if (Util.isNullOrEmpty((Object[])myVMwareLicense.activityDetails) || InactiveLicensesReportUtil.findActivityForSerialKey(inactiveSerialKey, myVMwareLicense.activityDetails) == null) continue;
                ArrayList<LicenseKeyDetails> replacementMyVMwareLicenses = (ArrayList<LicenseKeyDetails>)inactiveSerialKeyToReplacementMyVMwareLicenses.get(inactiveSerialKey);
                if (replacementMyVMwareLicenses == null) {
                    replacementMyVMwareLicenses = new ArrayList<LicenseKeyDetails>();
                    inactiveSerialKeyToReplacementMyVMwareLicenses.put(inactiveSerialKey, replacementMyVMwareLicenses);
                }
                replacementMyVMwareLicenses.add(myVMwareLicense);
            }
        }
        return inactiveSerialKeyToReplacementMyVMwareLicenses;
    }

    private static InactiveLicensesReportData[] buildInactiveLicensesReportData(Map<String, License> inactiveSerialKeyToInventoryLicense, Map<String, List<LicenseKeyDetails>> inactiveSerialKeyToReplacementMyVMwareLicenses, Map<LicenseKeyDetails, LicenseInfo> myVMwareLicenseToDecodedLicenseInfo) {
        ArrayList<InactiveLicensesReportData> inactiveLicensesReportData = new ArrayList<InactiveLicensesReportData>();
        for (Map.Entry<String, List<LicenseKeyDetails>> entry : inactiveSerialKeyToReplacementMyVMwareLicenses.entrySet()) {
            InactiveLicensesReportData inactiveLicenseData = new InactiveLicensesReportData();
            String inactiveSerialKey = entry.getKey();
            List<LicenseKeyDetails> replacementMyVMwareLicenses = entry.getValue();
            inactiveLicenseData.inactiveSerialKey = inactiveSerialKey;
            inactiveLicenseData.inventoryLicense = inactiveSerialKeyToInventoryLicense.get(inactiveSerialKey);
            inactiveLicenseData.replacementMyVMwareLicenseToDecodedLicenseInfo = MyVMwareSyncManagerImpl.getReplacementMyVMwareLicenseToDecodedLicenseInfo(replacementMyVMwareLicenses, myVMwareLicenseToDecodedLicenseInfo);
            inactiveLicensesReportData.add(inactiveLicenseData);
        }
        Collections.sort(inactiveLicensesReportData, new InactiveLicensesReportDataComparator());
        return inactiveLicensesReportData.toArray(new InactiveLicensesReportData[inactiveLicensesReportData.size()]);
    }

    private static Map<LicenseKeyDetails, LicenseInfo> getReplacementMyVMwareLicenseToDecodedLicenseInfo(List<LicenseKeyDetails> replacementMyVMwareLicenses, Map<LicenseKeyDetails, LicenseInfo> myVMwareLicenseToDecodedLicenseInfo) {
        LinkedHashMap<LicenseKeyDetails, LicenseInfo> replacementMyVMwareLicenseToDecodedLicenseInfo = new LinkedHashMap<LicenseKeyDetails, LicenseInfo>();
        for (LicenseKeyDetails myVMwareLicense : replacementMyVMwareLicenses) {
            LicenseInfo decodedLicenseInfo = myVMwareLicenseToDecodedLicenseInfo.get(myVMwareLicense);
            replacementMyVMwareLicenseToDecodedLicenseInfo.put(myVMwareLicense, decodedLicenseInfo);
        }
        return replacementMyVMwareLicenseToDecodedLicenseInfo;
    }

    private static LicenseInfo getLicenseInfoBySerialKey(LicenseInfo[] licenseInfos, String serialKey) {
        LicenseInfo result = null;
        for (LicenseInfo licenseInfo : licenseInfos) {
            if (licenseInfo == null || !MyVMwareSyncManagerImpl.containsSerialKey(licenseInfo, serialKey)) continue;
            result = licenseInfo;
            break;
        }
        return result;
    }

    private static boolean containsSerialKey(LicenseInfo licenseInfo, String serialKey) {
        List<String> licenseSerialKeys = Arrays.asList(((SerialKeyLicenseInfo)licenseInfo).getSerialKeys());
        return licenseSerialKeys.contains(serialKey);
    }

    private static boolean isSerialKeyPresentInHistory(String serialKey, LicenseKeyDetails[] myVMwareLicenses) {
        boolean isSerialKeyPresentInHistory = false;
        for (LicenseKeyDetails myVMwareLicense : myVMwareLicenses) {
            if (InactiveLicensesReportUtil.findActivityForSerialKey(serialKey, myVMwareLicense.activityDetails) == null) continue;
            isSerialKeyPresentInHistory = true;
            break;
        }
        return isSerialKeyPresentInHistory;
    }

    private static class InactiveLicensesReportDataComparator
    implements Comparator<InactiveLicensesReportData> {
        private InactiveLicensesReportDataComparator() {
        }

        @Override
        public int compare(InactiveLicensesReportData reportData1, InactiveLicensesReportData reportData2) {
            return reportData1.inactiveSerialKey.compareTo(reportData2.inactiveSerialKey);
        }
    }
}

