/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal.inactivekeys.impl;

import com.vmware.cis.license.common.misc.DateUtil;
import com.vmware.license.myvmware.client.sync.internal.AccountDetails;
import com.vmware.license.myvmware.client.sync.internal.ActivityDetails;
import com.vmware.license.myvmware.client.sync.internal.LicenseKeyDetails;
import com.vmware.license.myvmware.client.sync.internal.RecordWriter;
import com.vmware.license.myvmware.client.sync.internal.RecordWriterFactory;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportData;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportGenerator;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportUtil;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportWriteException;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.impl.InactiveLicensesReportSchema;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.management.InactiveLicensesReport;
import com.vmware.vim.binding.impl.cis.license.management.InactiveLicensesReportImpl;
import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.binding.vmodl.Binary;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class InactiveLicensesReportGeneratorImpl
implements InactiveLicensesReportGenerator {
    private static final String INACTIVE_LICENSES_REPORT_VERSION = "csv";
    private final RecordWriterFactory _recordWriterFactory;

    public InactiveLicensesReportGeneratorImpl(RecordWriterFactory recordWriterFactory) {
        this._recordWriterFactory = recordWriterFactory;
    }

    @Override
    public final InactiveLicensesReport generateReport(InactiveLicensesReportData[] reportData, boolean shouldCompressReport) throws InactiveLicensesReportWriteException {
        RecordWriter reportWriter = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStream outputStream = baos;
            if (shouldCompressReport) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            reportWriter = this._recordWriterFactory.getRecordWriter(outputStream, InactiveLicensesReportSchema.Columns.getColumnNames());
            int inactiveLicensesCount = this.writeReportData(reportWriter, reportData);
            reportWriter.flush();
            outputStream.flush();
            if (shouldCompressReport) {
                ((GZIPOutputStream)outputStream).finish();
            }
            byte[] content = baos.toByteArray();
            InactiveLicensesReportImpl inactiveLicensesReport = null;
            if (inactiveLicensesCount > 0) {
                inactiveLicensesReport = new InactiveLicensesReportImpl((Binary)new BinaryImpl(content), INACTIVE_LICENSES_REPORT_VERSION, inactiveLicensesCount);
            }
            InactiveLicensesReportImpl inactiveLicensesReportImpl = inactiveLicensesReport;
            return inactiveLicensesReportImpl;
        }
        catch (IOException e) {
            throw new InactiveLicensesReportWriteException("Failed to generate inactive licenses report", e);
        }
        finally {
            if (reportWriter != null) {
                try {
                    reportWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected final int writeReportData(RecordWriter reportWriter, InactiveLicensesReportData[] reportData) throws IOException {
        int inactiveLicensesCount = 0;
        for (InactiveLicensesReportData inactiveLicenseData : reportData) {
            if (!this.writeInactiveLicenseData(reportWriter, inactiveLicenseData)) continue;
            ++inactiveLicensesCount;
        }
        return inactiveLicensesCount;
    }

    protected boolean writeInactiveLicenseData(RecordWriter reportWriter, InactiveLicensesReportData inactiveLicenseData) throws IOException {
        ArrayList<LicenseKeyDetails> replacementMyVMwareLicenses = new ArrayList<LicenseKeyDetails>(inactiveLicenseData.replacementMyVMwareLicenseToDecodedLicenseInfo.keySet());
        ActivityDetails activityDetails = InactiveLicensesReportUtil.findActivityForSerialKey(inactiveLicenseData.inactiveSerialKey, ((LicenseKeyDetails)replacementMyVMwareLicenses.get((int)0)).activityDetails);
        return this.writeInactiveLicenseRecords(reportWriter, inactiveLicenseData.inactiveSerialKey, inactiveLicenseData.inventoryLicense, ((LicenseKeyDetails)replacementMyVMwareLicenses.get((int)0)).accountDetails, activityDetails, replacementMyVMwareLicenses);
    }

    protected final boolean writeInactiveLicenseRecords(RecordWriter reportWriter, String inactiveSerialKey, License inventoryLicense, AccountDetails accountDetails, ActivityDetails activityDetails, List<LicenseKeyDetails> replacementMyVMwareLicenses) throws IOException {
        for (int index = 0; index < replacementMyVMwareLicenses.size(); ++index) {
            LicenseKeyDetails replacementMyVMwareLicense = replacementMyVMwareLicenses.get(index);
            String[] recordItems = InactiveLicensesReportGeneratorImpl.buildRecordItems(inactiveSerialKey, inventoryLicense, accountDetails, activityDetails, replacementMyVMwareLicense, index);
            reportWriter.writeRecord(recordItems);
        }
        return replacementMyVMwareLicenses.size() != 0;
    }

    private static String[] buildRecordItems(String inactiveKey, License inventoryLicense, AccountDetails accountDetails, ActivityDetails activityDetails, LicenseKeyDetails replacementLicense, int replacementLicenseIndex) {
        String[] items = new String[InactiveLicensesReportSchema.Columns.values().length];
        if (replacementLicenseIndex == 0) {
            items[InactiveLicensesReportSchema.Columns.ACCOUNT_NAME.getColumnIndex()] = accountDetails.accountName;
            items[InactiveLicensesReportSchema.Columns.ACCOUNT_NUMBER.getColumnIndex()] = accountDetails.accountNumber;
            items[InactiveLicensesReportSchema.Columns.PRODUCT_NAME.getColumnIndex()] = inventoryLicense.getInfo().getRestrictions()[0].getProduct().getName();
            items[InactiveLicensesReportSchema.Columns.INACTIVE_KEY.getColumnIndex()] = inactiveKey;
            CostUnitLimit costUnitLimit = inventoryLicense.getInfo().getRestrictions()[0].getCostUnitsLimit()[0];
            items[InactiveLicensesReportSchema.Columns.LICENSE_QUANTITY.getColumnIndex()] = Long.toString(costUnitLimit.getValue());
            items[InactiveLicensesReportSchema.Columns.UNIT_OF_MEASURE.getColumnIndex()] = replacementLicense.unitOfMeasure;
            items[InactiveLicensesReportSchema.Columns.ACTIVITY_TYPE.getColumnIndex()] = activityDetails.activity;
            items[InactiveLicensesReportSchema.Columns.ACTIVITY_DATE.getColumnIndex()] = InactiveLicensesReportGeneratorImpl.formatISODateShortOrReturnNull(activityDetails.activityDate);
            items[InactiveLicensesReportSchema.Columns.PERFORMED_BY.getColumnIndex()] = activityDetails.performedBy;
        }
        items[InactiveLicensesReportSchema.Columns.REPLACEMENT_KEY.getColumnIndex()] = replacementLicense.licenseKey;
        items[InactiveLicensesReportSchema.Columns.PRODUCT_NAME_REPLACEMENT_KEY.getColumnIndex()] = replacementLicense.productName;
        items[InactiveLicensesReportSchema.Columns.LICENSE_QUANTITY_REPLACEMENT_KEY.getColumnIndex()] = String.valueOf(replacementLicense.licenseQuantity);
        items[InactiveLicensesReportSchema.Columns.UNIT_OF_MEASURE_REPLACEMENT_KEY.getColumnIndex()] = replacementLicense.unitOfMeasure;
        return items;
    }

    private static String formatISODateShortOrReturnNull(Date date) {
        try {
            return DateUtil.formatISODateShort((Date)date);
        }
        catch (Exception e) {
            return null;
        }
    }
}

