/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.upgrade.impl;

import com.vmware.cis.license.common.misc.Util;
import com.vmware.license.myvmware.client.MyVMwareClientException;
import com.vmware.license.myvmware.client.authn.AuthenticationToken;
import com.vmware.license.myvmware.client.rest.MyVMwareRestServiceHelper;
import com.vmware.license.myvmware.client.rest.MyVMwareRestServiceUtil;
import com.vmware.license.myvmware.client.upgrade.LicenseUpgradeEligibilityCheckResult;
import com.vmware.license.myvmware.client.upgrade.LicenseUpgradeResult;
import com.vmware.license.myvmware.client.upgrade.MyVMwareLicenseUpgradeClient;
import com.vmware.license.myvmware.client.upgrade.MyVMwareLicenseUpgradeClientHttpConfig;
import com.vmware.license.myvmware.client.upgrade.impl.rest.CheckLicenseUpgradeEligibilityRequest;
import com.vmware.license.myvmware.client.upgrade.impl.rest.CheckLicenseUpgradeEligibilityResponse;
import com.vmware.license.myvmware.client.upgrade.impl.rest.CheckLicenseUpgradeEligibilityStatusResponse;
import com.vmware.license.myvmware.client.upgrade.impl.rest.UpgradeLicenseRequest;
import com.vmware.license.myvmware.client.upgrade.impl.rest.UpgradeLicenseResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;

public class MyVMwareLicenseUpgradeClientImpl
implements MyVMwareLicenseUpgradeClient {
    private static final String LICENSE_UPGRADE_ELIGIBILITY_CHECK_STATUS_IN_PROGRESS = "IN-PROGRESS";
    private static final String LICENSE_UPGRADE_ELIGIBILITY_CHECK_STATUS_COMPLETED = "COMPLETED";
    private static final String LICENSE_UPGRADE_STATUS_SUCCESS = "Success";
    private final MyVMwareLicenseUpgradeClientHttpConfig _httpConfig;
    private final URI _baseUri;
    private final MyVMwareRestServiceHelper _myVMwareRestServiceHelper;

    public MyVMwareLicenseUpgradeClientImpl(MyVMwareLicenseUpgradeClientHttpConfig httpConfig, URI baseUri, AuthenticationToken authenticationToken) {
        this._httpConfig = httpConfig;
        this._baseUri = baseUri;
        HashMap<String, String> httpRequestHeadersMap = new HashMap<String, String>();
        MyVMwareRestServiceUtil.populateHttpHeadersWithBearerToken(httpRequestHeadersMap, authenticationToken.getTokenValue());
        this._myVMwareRestServiceHelper = new MyVMwareRestServiceHelper(httpRequestHeadersMap, httpConfig.getConnectTimeoutInMs());
    }

    @Override
    public String initiateLicenseUpgradeEligibilityCheck(String[] licenseKeys) throws MyVMwareClientException, TimeoutException {
        MyVMwareLicenseUpgradeClientImpl.validateLicenseKeysForUpgradeEligibilityCheck(licenseKeys);
        CheckLicenseUpgradeEligibilityRequest checkLicenseUpgradeEligibilityRequest = MyVMwareLicenseUpgradeClientImpl.buildCheckLicenseUpgradeEligibilityRequest(licenseKeys);
        CheckLicenseUpgradeEligibilityResponse checkLicenseUpgradeEligibilityResponse = this._myVMwareRestServiceHelper.executePostRequest(this.getLicenseUpgradeEligibilityCheckUrl(), this._httpConfig.getTimeoutCheckLicenseUpgradeEligibilityInMs(), checkLicenseUpgradeEligibilityRequest, CheckLicenseUpgradeEligibilityResponse.class, new Object[0]);
        return checkLicenseUpgradeEligibilityResponse.getJobId();
    }

    @Override
    public LicenseUpgradeEligibilityCheckResult getLicenseUpgradeEligibilityCheckResult(String jobId) throws MyVMwareClientException, TimeoutException {
        if (Util.isNullOrEmpty((String)jobId)) {
            throw new IllegalArgumentException("Invalid parameter: jobId cannot be null or empty");
        }
        CheckLicenseUpgradeEligibilityStatusResponse checkLicenseUpgradeEligibilityStatusResponse = this._myVMwareRestServiceHelper.executeGetRequest(this.getLicenseUpgradeEligibilityCheckStatusUrl(), this._httpConfig.getTimeoutCheckLicenseUpgradeEligibilityStatusInMs(), CheckLicenseUpgradeEligibilityStatusResponse.class, jobId);
        String status = checkLicenseUpgradeEligibilityStatusResponse.getStatus();
        boolean isLicenseUpgradeEligibilityCheckComplete = false;
        String[] eligibleKeys = null;
        if (LICENSE_UPGRADE_ELIGIBILITY_CHECK_STATUS_COMPLETED.equalsIgnoreCase(status)) {
            isLicenseUpgradeEligibilityCheckComplete = true;
            eligibleKeys = checkLicenseUpgradeEligibilityStatusResponse.getEligibleKeys();
        } else if (!LICENSE_UPGRADE_ELIGIBILITY_CHECK_STATUS_IN_PROGRESS.equalsIgnoreCase(status)) {
            throw new MyVMwareClientException(String.format("Error checking for license upgrade eligibility. Job id: %s, job status: %s.", jobId, status));
        }
        return new LicenseUpgradeEligibilityCheckResult(isLicenseUpgradeEligibilityCheckComplete, eligibleKeys);
    }

    @Override
    public LicenseUpgradeResult upgradeLicense(String licenseKey) throws MyVMwareClientException, TimeoutException {
        if (Util.isNullOrEmpty((String)licenseKey)) {
            throw new IllegalArgumentException("Invalid parameter: licenseKey cannot be null or empty");
        }
        UpgradeLicenseRequest upgradeLicenseRequest = MyVMwareLicenseUpgradeClientImpl.buildUpgradeLicenseRequest(licenseKey);
        UpgradeLicenseResponse upgradeLicenseResponse = this._myVMwareRestServiceHelper.executePostRequest(this.getLicenseUpgradeUrl(), this._httpConfig.getTimeoutUpgradeLicenseInMs(), upgradeLicenseRequest, UpgradeLicenseResponse.class, new Object[0]);
        if (!LICENSE_UPGRADE_STATUS_SUCCESS.equalsIgnoreCase(upgradeLicenseResponse.getStatus())) {
            throw new MyVMwareClientException(String.format("Upgrade of license key %s failed. Status: %s. Message: %s", licenseKey, upgradeLicenseResponse.getStatus(), upgradeLicenseResponse.getMessage()));
        }
        return new LicenseUpgradeResult(upgradeLicenseResponse.getUpgradedKeys(), upgradeLicenseResponse.getDeactivatedKey(), upgradeLicenseResponse.getMessage());
    }

    @Override
    public void close() {
    }

    private String getLicenseUpgradeUrl() {
        return this._baseUri.toString() + "/upgrade";
    }

    private String getLicenseUpgradeEligibilityCheckUrl() {
        return this._baseUri.toString() + "/eligibility-check";
    }

    private String getLicenseUpgradeEligibilityCheckStatusUrl() {
        return this._baseUri.toString() + "/eligibility-check/{job_id}";
    }

    private static void validateLicenseKeysForUpgradeEligibilityCheck(String[] licenseKeys) {
        if (Util.isNullOrEmpty((Object[])licenseKeys)) {
            throw new IllegalArgumentException("Invalid parameter: licenseKeys array cannot be null or empty");
        }
        for (String licenseKey : licenseKeys) {
            if (!Util.isNullOrEmpty((String)licenseKey)) continue;
            throw new IllegalArgumentException("Invalid parameter: licenseKey cannot be null or empty");
        }
    }

    private static CheckLicenseUpgradeEligibilityRequest buildCheckLicenseUpgradeEligibilityRequest(String[] licenseKeysForEligibilityCheck) {
        CheckLicenseUpgradeEligibilityRequest checkLicenseUpgradeEligibilityRequest = new CheckLicenseUpgradeEligibilityRequest();
        checkLicenseUpgradeEligibilityRequest.setLicenseKeys(licenseKeysForEligibilityCheck);
        return checkLicenseUpgradeEligibilityRequest;
    }

    private static UpgradeLicenseRequest buildUpgradeLicenseRequest(String licenseKey) {
        UpgradeLicenseRequest upgradeLicenseRequest = new UpgradeLicenseRequest();
        upgradeLicenseRequest.setLicenseKey(licenseKey);
        return upgradeLicenseRequest;
    }
}

