/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security;

import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.security.AuthenticationHandler;
import com.vmware.vise.security.ClientSessionEndListener;
import com.vmware.vise.security.DefaultAuthenticationException;
import com.vmware.vise.security.DefaultAuthenticationProviderInternal;
import com.vmware.vise.security.SecurityUtil;
import com.vmware.vise.security.SessionListener;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.security.Utils;
import com.vmware.vise.security.WebAuthenticationDetails;
import com.vmware.vise.security.websso.WebssoAuthenticationToken;
import com.vmware.vise.util.ConversionUtil;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.debug.TimeMonitor;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vise.util.session.SessionDataContainerMissingException;
import com.vmware.vise.util.session.SessionUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsService;

public class DefaultAuthenticationProvider
implements DefaultAuthenticationProviderInternal {
    private static final Log _logger = LogFactory.getLog(DefaultAuthenticationProvider.class);
    private static final String GENERAL_FAULT = "generalFault=";
    private static final long LOGIN_TIME_THRESHOLD_FOR_USER_SESSION_LISTENERS = TimeUnit.SECONDS.toNanos(3L);
    private static final long LOGOUT_TIME_THRESHOLD_FOR_USER_SESSION_LISTENERS = TimeUnit.SECONDS.toNanos(3L);
    private static final String ATTR_NAME_LOGGED_IN = "LOGGED_IN";
    private final UserDetailsService _userDetailsService;
    private final ServiceRegistry _serviceRegistry;
    private volatile AuthenticationHandler[] _authenticationHandlers;
    private final Object _authenticationHandlersLockObj = new Object();
    private final long _userSessionListenerTimeout;
    public static final String SESSION_ERROR_KEY = "sessionError";
    public static final String PROP_NAME__USER_SESSION_LISTENER_TIMEOUT = "UserSessionListener.timeout";
    public static final long DEFAULT_USER_SESSION_LISTENER_TIMEOUT_IN_MILLIS = 120000L;
    private static final ExecutorService _threadPool = ThreadPoolFactory.newQueingCachedThreadPool((int)300, (ThreadFactory)new WorkerThreadFactory("session-init-pool"), (long)2L, (TimeUnit)TimeUnit.MINUTES, (long)10L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);

    public DefaultAuthenticationProvider(UserDetailsService userDetailsService, ServiceRegistry serviceRegistry) {
        this(userDetailsService, serviceRegistry, null);
    }

    public DefaultAuthenticationProvider(UserDetailsService userDetailsService, ServiceRegistry serviceRegistry, ConfigurationService configurationService) {
        this._userDetailsService = userDetailsService;
        this._serviceRegistry = serviceRegistry;
        if (configurationService == null && this._serviceRegistry != null) {
            configurationService = (ConfigurationService)this._serviceRegistry.getService(ConfigurationService.class.getName());
        }
        this._userSessionListenerTimeout = configurationService != null ? PropertyUtil.getLongProperty((ConfigurationService)configurationService, (String)PROP_NAME__USER_SESSION_LISTENER_TIMEOUT, (long)120000L) : 120000L;
    }

    public void initialize() {
        this.registerServiceListeners();
    }

    public UserDetailsService getUserDetailsService() {
        return this._userDetailsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationHandler[] getAuthenticationHandlers() {
        if (this._authenticationHandlers == null) {
            Object object = this._authenticationHandlersLockObj;
            synchronized (object) {
                if (this._authenticationHandlers == null) {
                    this._authenticationHandlers = this._serviceRegistry.getServices(AuthenticationHandler.class.getName()).toArray(new AuthenticationHandler[0]);
                }
            }
        }
        return this._authenticationHandlers;
    }

    private void registerServiceListeners() {
        this._serviceRegistry.registerServiceListener(AuthenticationHandler.class.getName(), new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceRemoved(Object object) {
                Object object2 = DefaultAuthenticationProvider.this._authenticationHandlersLockObj;
                synchronized (object2) {
                    DefaultAuthenticationProvider.access$102(DefaultAuthenticationProvider.this, null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceAdded(Object object) {
                Object object2 = DefaultAuthenticationProvider.this._authenticationHandlersLockObj;
                synchronized (object2) {
                    DefaultAuthenticationProvider.access$102(DefaultAuthenticationProvider.this, null);
                }
            }
        });
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            Object object;
            String string;
            if (_logger.isTraceEnabled()) {
                string = ExceptionUtil.getCurrentStackTrace();
                _logger.trace((Object)("authentication starting\n" + string));
            } else {
                _logger.info((Object)"authentication starting");
            }
            authentication = this.decodeAuthToken(authentication);
            string = (String)authentication.getPrincipal();
            if (authentication instanceof UsernamePasswordAuthenticationToken && StringUtil.isNullOrEmpty((String)string)) {
                String string2 = SecurityUtil.getLocalizedString("error.invalidCredentials");
                throw new BadCredentialsException(string2);
            }
            HttpSession httpSession = this.getSession(authentication);
            boolean bl = SessionUtil.isLogoutInitiated((HttpSession)httpSession);
            if (bl) {
                String string3 = GENERAL_FAULT + SecurityUtil.getLocalizedString("error.cantLoginBecauseStillLoggingOut");
                throw new DefaultAuthenticationException(string3, null);
            }
            boolean bl2 = false;
            if (httpSession != null && (object = SessionUtil.getData((String)ATTR_NAME_LOGGED_IN, (HttpSession)httpSession)) != null) {
                _logger.warn((Object)"Already logged in session");
                bl2 = true;
            }
            if (!bl2) {
                for (AuthenticationHandler authenticationHandler : this.getAuthenticationHandlers()) {
                    _logger.info((Object)("Authenticating user: " + string + " using authentication handler: " + authenticationHandler.toString()));
                    ClassLoader classLoader = authenticationHandler.getClass().getClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                    authenticationHandler.authenticate(authentication);
                }
            }
            if (authentication instanceof UsernamePasswordAuthenticationToken) {
                return new UsernamePasswordAuthenticationToken((Object)string, null, (Collection)null);
            }
            object = (WebssoAuthenticationToken)authentication;
            WebssoAuthenticationToken webssoAuthenticationToken = new WebssoAuthenticationToken(((WebssoAuthenticationToken)((Object)object)).getRequest(), ((WebssoAuthenticationToken)((Object)object)).getResponse());
            webssoAuthenticationToken.setAuthenticated(true);
            return webssoAuthenticationToken;
        }
        catch (Exception exception) {
            if (exception instanceof AuthenticationException) {
                AuthenticationException authenticationException = (AuthenticationException)exception;
                throw authenticationException;
            }
            String string = SecurityUtil.getLocalizedString("error.authenticateError");
            _logger.error((Object)"Unknown error during authentication", (Throwable)exception);
            throw new DefaultAuthenticationException(string, exception);
        }
    }

    private HttpServletRequest getRequest(Authentication authentication) {
        WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)((Object)authentication.getDetails());
        return webAuthenticationDetails.getRequest();
    }

    private HttpSession getSession(Authentication authentication) {
        HttpServletRequest httpServletRequest = this.getRequest(authentication);
        return httpServletRequest.getSession();
    }

    public void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) {
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession == null) {
            return;
        }
        this.logout(httpSession);
    }

    @Override
    public void logout(HttpSession httpSession) {
        String string = null;
        if (httpSession == null) {
            throw new IllegalArgumentException("The session is null. Can't log out.");
        }
        try {
            String string2 = SessionUtil.getClientId((HttpSession)httpSession);
            if (string2 == null) {
                _logger.warn((Object)"The session is not associated with a clientId. Will skip most of the logout procedure.");
                return;
            }
            String string3 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            string = SessionUtil.getSessionInfo((HttpSession)httpSession);
            if (!SessionUtil.isValidClientId((String)string2)) {
                String string4 = SessionUtil.getClientIdHistory((String)string2, (boolean)false);
                _logger.info((Object)("The clientId is not valid. Probably already logged out and destroyed. Skipping logout. (" + string + ", " + (string4 != null ? "history: " + string4 : "no history data available") + ")"));
                return;
            }
            _logger.info((Object)("Beginning logout for " + string));
            boolean bl = SessionUtil.markAsLoggingOut((String)string2);
            if (!bl) {
                boolean bl2 = SessionUtil.isLoggingOut((String)string2);
                boolean bl3 = SessionUtil.isLoggedOut((String)string2);
                _logger.warn((Object)("Already logged out session: " + string + "\nFlags: loggingOut=" + bl2 + ", loggedOut=" + bl3));
                return;
            }
            CountDownLatch countDownLatch = SessionUtil.getSessionMonitor((HttpSession)httpSession);
            boolean bl4 = BlockingUtil.await((CountDownLatch)countDownLatch, (long)10L, (TimeUnit)TimeUnit.SECONDS);
            if (!bl4) {
                _logger.warn((Object)"The session initialization did not complete within the allotted timeout. Proceding with the logout anyway. This may cause some initialization-related errors to be printed in the log because the initialization may not be able to complete properly once we start logging out of the various services.");
            }
            if (_logger.isTraceEnabled()) {
                SessionUtil.dumpSessionAttributeNames((HttpSession)httpSession);
            }
            _logger.info((Object)("Will notify " + UserSessionListener.class.getSimpleName() + "s"));
            List list = (List)SessionUtil.getData((String)"USER_SESSION_LISTENERS", (HttpSession)httpSession);
            this.invokeSessionListeners(httpSession, null, list, Phase.LOGOUT);
            _logger.info((Object)("Will notify " + ClientSessionEndListener.class.getSimpleName() + "s"));
            this.invokeClientSessionEndListeners(httpSession);
            _logger.info((Object)("Will invoke the " + AuthenticationHandler.class.getSimpleName() + "s"));
            for (AuthenticationHandler authenticationHandler : this.getAuthenticationHandlers()) {
                try {
                    _logger.info((Object)("Logging out using authentication handler: " + authenticationHandler.toString()));
                    authenticationHandler.logout(httpSession);
                }
                catch (Exception exception) {
                    _logger.warn((Object)("Failed to logout using authentication handler: " + authenticationHandler.getClass().getCanonicalName()), (Throwable)exception);
                }
            }
            SessionUtil.removeData((String)"USER_SESSION_LISTENERS", (HttpSession)httpSession);
            bl = SessionUtil.markAsLoggedOut((String)string2);
            if (!bl) {
                _logger.warn((Object)"Failed to mark the session as 'logged out'");
            }
            SessionListener.invalidate(string2, httpSession, string3);
            Utils.removeAuthenticationProvider(httpSession);
            _logger.info((Object)("Completed logout for " + string));
        }
        catch (SessionDataContainerMissingException sessionDataContainerMissingException) {
            _logger.warn((Object)"clientId already missing. Skipping logout.", (Throwable)sessionDataContainerMissingException);
        }
        catch (RuntimeException runtimeException) {
            _logger.error((Object)("logout failed for " + string), (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    public boolean supports(Class<?> clazz) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void successfulAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) {
        Object object;
        HttpSession httpSession = httpServletRequest.getSession();
        String string = SessionUtil.getSessionInfo((HttpSession)httpSession);
        if (_logger.isTraceEnabled()) {
            object = ExceptionUtil.getCurrentStackTrace();
            _logger.info((Object)("Successful authentication handler running for " + string + "\n" + (String)object));
        } else {
            _logger.info((Object)("Successful authentication handler running for " + string));
        }
        object = SessionUtil.setDataIfAbsent((String)ATTR_NAME_LOGGED_IN, (Object)Boolean.TRUE, (HttpSession)httpSession);
        if (object != null) {
            _logger.warn((Object)("Already logged in session: " + string));
            return;
        }
        CountDownLatch countDownLatch = SessionUtil.getSessionMonitor((HttpSession)httpServletRequest.getSession());
        _logger.info((Object)("Starting authhandlers for " + string));
        try {
            for (AuthenticationHandler authenticationHandler : this.getAuthenticationHandlers()) {
                try {
                    authenticationHandler.successfulAuthentication(httpServletRequest, httpServletResponse, authentication);
                }
                catch (Exception exception) {
                    _logger.error((Object)("Error while running auth handler: " + string), (Throwable)exception);
                }
            }
            _logger.info((Object)("Running initSession for " + string));
            this.initSession(httpServletRequest);
        }
        finally {
            countDownLatch.countDown();
        }
    }

    private Authentication decodeAuthToken(Authentication authentication) {
        if (!(authentication instanceof UsernamePasswordAuthenticationToken)) {
            return authentication;
        }
        WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)((Object)authentication.getDetails());
        String string = webAuthenticationDetails.getParameter("_remember_me");
        boolean bl = Boolean.parseBoolean(string);
        if (bl) {
            return authentication;
        }
        String string2 = webAuthenticationDetails.getParameter("_ignoreEncoding");
        boolean bl2 = Boolean.parseBoolean(string2);
        if (bl2) {
            return authentication;
        }
        String string3 = (String)authentication.getPrincipal();
        byte[] byArray = null;
        if (!StringUtil.isNullOrEmpty((String)string3)) {
            byArray = Base64.decodeBase64((byte[])string3.getBytes());
            try {
                string3 = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                _logger.error((Object)"Error decoding bytes to unicode ", (Throwable)unsupportedEncodingException);
            }
        }
        Object object = authentication.getCredentials();
        char[] cArray = this.decodePassword(object);
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)string3, (Object)cArray);
        usernamePasswordAuthenticationToken.setDetails(authentication.getDetails());
        return usernamePasswordAuthenticationToken;
    }

    private char[] decodePassword(Object object) {
        byte[] byArray;
        Object object2;
        if (object == null) {
            return null;
        }
        Charset charset = Charset.defaultCharset();
        if (object instanceof String) {
            object2 = (String)object;
            if ("".equals(object2)) {
                return StringUtil.EMPTY_CHAR_ARR;
            }
            byArray = ((String)object2).getBytes(charset);
        } else if (object instanceof byte[]) {
            byArray = (byte[])object;
        } else if (object instanceof char[]) {
            byArray = ConversionUtil.chars2bytes((char[])((char[])object), (Charset)charset);
        } else {
            throw new BadCredentialsException("Unsupported password type: " + object.getClass().getCanonicalName());
        }
        charset = StringUtil.CHARSET_UTF8;
        object2 = Base64.decodeBase64((byte[])byArray);
        char[] cArray = ConversionUtil.bytes2chars((byte[])object2, (Charset)charset);
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeClientSessionEndListeners(HttpSession httpSession) {
        List list = null;
        try {
            list = this._serviceRegistry.getServices(ClientSessionEndListener.class.getName());
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when getting implementers of ClientSessionEndListener interface", (Throwable)exception);
            return;
        }
        if (list == null) {
            _logger.info((Object)"No ClientSessionEndListener found.");
            return;
        }
        TimeMonitor timeMonitor = new TimeMonitor();
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        for (ClientSessionEndListener clientSessionEndListener : list) {
            if (clientSessionEndListener == null) continue;
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Invoking sessionEnded on " + clientSessionEndListener));
                }
                timeMonitor.init();
                clientSessionEndListener.sessionEnded(string);
            }
            catch (Exception exception) {
                _logger.error((Object)"Error ending session: ", (Throwable)exception);
            }
            finally {
                timeMonitor.logTimeIfExceeding(LOGOUT_TIME_THRESHOLD_FOR_USER_SESSION_LISTENERS, "DefaultAuthenticationProvider.logout", ClientSessionEndListener.class, (Object)clientSessionEndListener);
            }
        }
    }

    private void initSession(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        String string = SessionUtil.getSessionInfo((HttpSession)httpSession);
        _logger.info((Object)("Initializing Session: " + string));
        _logger.debug((Object)("Setting authentication provider for " + string));
        Utils.setAuthenticationProvider(this, httpSession);
        _logger.debug((Object)("Authentication provder set for session " + string));
        List<UserSessionListener> list = this.getSessionListeners(httpServletRequest);
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        _logger.debug((Object)("Found " + n + " sessionlisteners for " + string));
        _logger.debug((Object)("Setting session listeners for " + string));
        SessionUtil.setData((String)"USER_SESSION_LISTENERS", list, (HttpSession)httpSession);
        _logger.debug((Object)("Session listeners set for " + string));
        if (list == null) {
            _logger.debug((Object)("Listeners null, setting SESSION_INITIALIZED_KEY true for " + string));
            return;
        }
        Locale locale = ResourceUtil.getLocale((HttpServletRequest)httpServletRequest);
        this.invokeSessionListeners(httpSession, locale, list, Phase.LOGIN);
        _logger.info((Object)("Session initialization complete for " + string));
    }

    private List<UserSessionListener> getSessionListeners(HttpServletRequest httpServletRequest) {
        String string = SessionUtil.getSessionInfo((HttpSession)httpServletRequest.getSession());
        _logger.info((Object)("Retrieving session listeners for " + string));
        String string2 = httpServletRequest.getContextPath();
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        _logger.debug((Object)("Context path: " + string2));
        try {
            List list = this._serviceRegistry.getServices(UserSessionListener.class.getName());
            return list;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when getting implementers of UserSessionListener interface", (Throwable)exception);
            return null;
        }
    }

    private void invokeSessionListeners(HttpSession httpSession, Locale locale, List<UserSessionListener> list, final Phase phase) {
        String string;
        if (_logger.isDebugEnabled()) {
            string = SessionUtil.getSessionInfo((HttpSession)httpSession);
            _logger.debug((Object)("Invoking session listeners for " + string));
        } else {
            _logger.info((Object)"Invoking session listeners");
        }
        if (list == null || list.isEmpty()) {
            _logger.info((Object)"There are no registered listeners.");
            return;
        }
        string = new HttpSessionEvent(httpSession);
        CountDownLatch countDownLatch = new CountDownLatch(list.size());
        CopyOnWriteArrayList<MethodFault> copyOnWriteArrayList = new CopyOnWriteArrayList<MethodFault>();
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext();
        List<UserSessionListener> list2 = Collections.synchronizedList(new ArrayList(list.size()));
        for (final UserSessionListener object2 : list) {
            Runnable runnable = new Runnable((HttpSessionEvent)string, locale, copyOnWriteArrayList, list2, countDownLatch){
                final /* synthetic */ HttpSessionEvent val$event;
                final /* synthetic */ Locale val$locale;
                final /* synthetic */ List val$errors;
                final /* synthetic */ List val$unfinishedListeners;
                final /* synthetic */ CountDownLatch val$workerDone;
                {
                    this.val$event = httpSessionEvent;
                    this.val$locale = locale;
                    this.val$errors = list;
                    this.val$unfinishedListeners = list2;
                    this.val$workerDone = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block9: {
                        TimeMonitor timeMonitor = new TimeMonitor();
                        try {
                            SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                            timeMonitor.init();
                            if (phase == Phase.LOGIN) {
                                object2.sessionStarted(this.val$event, this.val$locale);
                                break block9;
                            }
                            if (phase == Phase.LOGOUT) {
                                object2.sessionEnded(this.val$event);
                                break block9;
                            }
                            throw new IllegalStateException("Unsupported phase: " + (Object)((Object)phase));
                        }
                        catch (Throwable throwable) {
                            _logger.error((Object)(UserSessionListener.class.getSimpleName() + " " + object2.toString() + " failed."), throwable);
                            this.val$errors.add(throwable);
                        }
                        finally {
                            if (phase == Phase.LOGIN) {
                                timeMonitor.logTimeIfExceeding(LOGIN_TIME_THRESHOLD_FOR_USER_SESSION_LISTENERS, "DefaultAuthenticationProvider.invokeSessionListeners(login)", UserSessionListener.class, (Object)object2);
                            } else {
                                timeMonitor.logTimeIfExceeding(LOGOUT_TIME_THRESHOLD_FOR_USER_SESSION_LISTENERS, "DefaultAuthenticationProvider.invokeSessionListeners(logout)", UserSessionListener.class, (Object)object2);
                            }
                            SessionUtil.setThreadContext(null);
                            this.val$unfinishedListeners.remove(object2);
                            this.val$workerDone.countDown();
                        }
                    }
                }
            };
            list2.add(object2);
            _threadPool.submit(runnable);
        }
        boolean bl = BlockingUtil.await((CountDownLatch)countDownLatch, (long)this._userSessionListenerTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
        if (!bl) {
            if (Thread.currentThread().isInterrupted()) {
                _logger.warn((Object)((Object)((Object)phase) + ": Thread interruption occurred while waiting " + "for the UserSessionListeners to complete. " + "Listeners that haven't finished: " + list2.toString()));
            } else {
                _logger.warn((Object)((Object)((Object)phase) + ": Some UserSessionListeners did not complete " + "on time. Will not wait for them any longer. " + "Listeners that haven't finished: " + list2.toString()));
                if (phase == Phase.LOGIN) {
                    String string2 = SecurityUtil.getLocalizedString("error.someUserSessionListenersTimedOutDuringLogin");
                    copyOnWriteArrayList.add(new MethodFault(string2));
                }
            }
        }
        if (phase == Phase.LOGIN && !copyOnWriteArrayList.isEmpty()) {
            SessionUtil.setData((String)SESSION_ERROR_KEY, Collections.unmodifiableList(copyOnWriteArrayList), (HttpSession)httpSession);
        }
        if (_logger.isDebugEnabled()) {
            String string3 = SessionUtil.getSessionInfo((HttpSession)httpSession);
            _logger.debug((Object)("Invoke session listeners complete " + string3));
        }
    }

    static /* synthetic */ AuthenticationHandler[] access$102(DefaultAuthenticationProvider defaultAuthenticationProvider, AuthenticationHandler[] authenticationHandlerArray) {
        defaultAuthenticationProvider._authenticationHandlers = authenticationHandlerArray;
        return authenticationHandlerArray;
    }

    private static enum Phase {
        LOGIN,
        LOGOUT;

    }
}

