/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security;

import com.vmware.vise.security.SessionListener;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.session.SessionUtil;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiagnosticSessionListener
implements HttpSessionListener {
    private static final Log _logger = LogFactory.getLog(DiagnosticSessionListener.class);

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        try {
            String string;
            HttpSession httpSession = httpSessionEvent.getSession();
            LogUtil.putSessionInfoIntoLogContext((HttpSession)httpSession);
            String string2 = SessionUtil.getExtendedSessionInfo((HttpSession)httpSession);
            String string3 = ExceptionUtil.getCurrentStackTrace();
            boolean bl = string3.contains("SessionFixation");
            _logger.info((Object)("Session destroyed" + (bl ? " as part of the session fixation protection strategy and will be replaced by a nearly identical new session" : "") + ": " + string2));
            boolean bl2 = _logger.isDebugEnabled();
            if (bl2) {
                _logger.debug((Object)("Stack trace:\n" + string3));
            }
            if (!bl && (string = SessionUtil.getClientId((HttpSession)httpSession)) != null && SessionUtil.isValidClientId((String)string) && !SessionUtil.isCleanupClientSessionAssociatedWith((String)string) && !SessionUtil.isLoggingOut((String)string)) {
                String string4 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
                String string5 = SessionUtil.getHashedClientId((String)string);
                String string6 = httpSession.getServletContext().getContextPath();
                _logger.warn((Object)("The session with id " + string4 + " and context path " + string6 + " will have to destroy the client data container for clientId " + string5 + " because no legitimate client-destruction-capable" + " session has been associated with that clientId"));
                SessionListener.handleSessionDestroyed(httpSessionEvent);
                return;
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to log a sessionDestroyed event", (Throwable)exception);
        }
        finally {
            LogUtil.removeSessionInfoFromLogContext();
        }
    }
}

