/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security;

import com.vmware.vise.security.RedirectResponseWrapper;
import com.vmware.vise.util.session.SessionUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.filter.OncePerRequestFilter;

public class FlexLogoutFilter
extends OncePerRequestFilter {
    private static final Log _logger = LogFactory.getLog(FlexLogoutFilter.class);
    public static final String LOCATION_KEY = "url:";

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        RedirectResponseWrapper redirectResponseWrapper = new RedirectResponseWrapper(httpServletResponse);
        HttpSession httpSession = httpServletRequest.getSession(false);
        _logger.info((Object)("Processing Flex logout request (" + SessionUtil.getSessionInfo((HttpSession)httpSession) + ")"));
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)redirectResponseWrapper);
        _logger.info((Object)"Done processing Flex logout request");
        String string = redirectResponseWrapper.getRedirect();
        if (string != null) {
            httpServletRequest.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentType("text/plain;charset=utf-8");
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            httpServletResponse.setDateHeader("Expires", 0L);
            httpServletResponse.setHeader("Pragma", "no-cache");
            String string2 = httpServletRequest.getContextPath();
            String string3 = string.length() > 0 ? LOCATION_KEY + string.substring(string2.length() + 1) : ((AuthenticationException)httpServletRequest.getSession().getAttribute("SPRING_SECURITY_LAST_EXCEPTION")).getMessage();
            httpServletResponse.getOutputStream().write(string3.getBytes("UTF-8"));
        }
    }
}

