/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security;

import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.session.SessionUtil;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.OncePerRequestFilter;

public class SessionManagementFilter
extends OncePerRequestFilter {
    private static final Log _logger = LogFactory.getLog(SessionManagementFilter.class);
    private static final String HSTS_HEADER_NAME = "Strict-Transport-Security";
    private static final long HSTS_DEFAULT_MAX_AGE_SECONDS = 31536000L;
    private final boolean _isH5Client = BuildProperties.isH5Client();
    private boolean _hstsEnabled = false;
    private long _hstsMaxAgeSeconds = 31536000L;
    private boolean _hstsIncludeSubdomains = true;
    private boolean _xsrfProtectionEnabled = false;
    private String _xsrfCookieName = BuildProperties.getXsrfCookieName();
    private String _xsrfHeaderName = BuildProperties.getXsrfHeaderName();

    public void setHstsEnabled(boolean bl) {
        this._hstsEnabled = bl;
    }

    public void setHstsMaxAgeSeconds(long l) {
        this._hstsMaxAgeSeconds = l;
    }

    public void setHstsIncludeSubdomains(boolean bl) {
        this._hstsIncludeSubdomains = bl;
    }

    public void setXsrfProtectionEnabled(boolean bl) {
        this._xsrfProtectionEnabled = bl;
    }

    public void setXsrfCookieName(String string) {
        this._xsrfCookieName = string;
    }

    public void setXsrfHeaderName(String string) {
        this._xsrfHeaderName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
            String string = httpServletRequest.getRequestURI();
            if (this._isH5Client || string.endsWith(".html")) {
                if (this._hstsEnabled && httpServletRequest.isSecure()) {
                    String string2 = String.format("max-age=%d", this._hstsMaxAgeSeconds);
                    if (this._hstsIncludeSubdomains) {
                        string2 = string2 + "; includeSubDomains";
                    }
                    httpServletResponse.setHeader(HSTS_HEADER_NAME, string2);
                }
                if (this.authenticateWebClientSession(httpServletRequest, httpServletResponse)) {
                    filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                }
            } else {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    private boolean authenticateWebClientSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getRequestURI();
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            httpSession = httpServletRequest.getSession(true);
        } else if (SessionUtil.isLogoutInitiated((HttpSession)httpSession)) {
            _logger.error((Object)("An attempt was made to access a logged-out session (" + SessionUtil.getSessionInfo() + "), returning HTTP status code " + 401 + " to this request: " + string));
            httpServletResponse.setStatus(401);
            return false;
        }
        String string2 = httpServletRequest.getParameter("webClientSessionId");
        String string3 = SessionUtil.getClientId((HttpSession)httpSession);
        if (string2 != null) {
            if (!string2.equals(string3)) {
                try {
                    SessionUtil.associateSessionWithClientId((HttpSession)httpSession, (String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    _logger.warn((Object)"The clientId is invalid. This is probably because a different session associated with the clientId has expired or logged out.");
                    httpServletResponse.setStatus(401);
                    return false;
                }
            } else if (SessionUtil.isAssociatedWithInvalidClientId((HttpSession)httpSession)) {
                _logger.error((Object)("An attempt was made to access a session associated with an invalid clientId. (" + SessionUtil.getSessionInfo() + "), returning HTTP status code " + 401 + " to this request: " + string));
                httpServletResponse.setStatus(401);
                return false;
            }
        }
        if (this._isH5Client && this._xsrfProtectionEnabled && string3 != null) {
            String string4 = (String)SessionUtil.getData((String)this._xsrfCookieName, (String)string3);
            if (string4 == null) {
                string4 = UUID.randomUUID().toString();
                SessionUtil.setData((String)this._xsrfCookieName, (Object)string4, (String)string3);
                Cookie cookie = new Cookie(this._xsrfCookieName, string4);
                cookie.setMaxAge(-1);
                cookie.setSecure(true);
                httpServletResponse.addCookie(cookie);
            } else {
                String string5;
                String string6 = httpServletRequest.getMethod();
                if ((string6.equalsIgnoreCase(RequestMethod.POST.toString()) || string6.equalsIgnoreCase(RequestMethod.PUT.toString()) || string6.equalsIgnoreCase(RequestMethod.DELETE.toString())) && ((string5 = httpServletRequest.getHeader(this._xsrfHeaderName)) == null || !string4.equals(string5))) {
                    _logger.error((Object)("An attempt was made to access a session with an invalid synchronizer token. (" + SessionUtil.getSessionInfo() + "), returning HTTP status code " + 401 + " to this request: " + string));
                    httpServletResponse.setStatus(401);
                    return false;
                }
            }
        }
        return true;
    }
}

