/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security.websso;

import com.vmware.vise.security.DefaultAuthenticationProvider;
import com.vmware.vise.security.WebAuthenticationDetails;
import com.vmware.vise.security.websso.WebssoAuthenticationToken;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class WebssoAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    private DefaultAuthenticationProvider _authenticationProvider;

    protected WebssoAuthenticationProcessingFilter(String string, DefaultAuthenticationProvider defaultAuthenticationProvider) {
        super(string);
        this._authenticationProvider = defaultAuthenticationProvider;
    }

    public Authentication attemptAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws AuthenticationException, IOException, ServletException {
        WebssoAuthenticationToken webssoAuthenticationToken = new WebssoAuthenticationToken(httpServletRequest, httpServletResponse);
        WebAuthenticationDetails webAuthenticationDetails = new WebAuthenticationDetails(httpServletRequest);
        webAuthenticationDetails.setResponse(httpServletResponse);
        webssoAuthenticationToken.setDetails((Object)webAuthenticationDetails);
        return this.getAuthenticationManager().authenticate((Authentication)webssoAuthenticationToken);
    }

    protected void successfulAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) throws IOException, ServletException {
        this._authenticationProvider.successfulAuthentication(httpServletRequest, httpServletResponse, authentication);
        super.successfulAuthentication(httpServletRequest, httpServletResponse, authentication);
    }
}

