/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.rp;

import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.SharesInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.rp.util.ResourcePoolStringUtil;

public class ResourcePoolPropertyProvider
implements PropertyProviderBean {
    private static final String EMPTY_VALUE = "--";
    private static final String CPU_ALLOCATION_LEVEL = "config.cpuAllocation.shares.level";
    private static final String CPU_ALLOCATION_VALUE = "config.cpuAllocation.shares.shares";
    private static final String MEMORY_ALLOCATION_LEVEL = "config.memoryAllocation.shares.level";
    private static final String MEMORY_ALLOCATION_VALUE = "config.memoryAllocation.shares.shares";
    private QueryExecutor _queryExecutor;

    public ResourcePoolPropertyProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @type(value="ResourcePool,VirtualApp")
    public String getCpuSharesLevel(ManagedObjectReference target) throws Exception {
        return this.getLocalizedSharesLevelFromProperty(target, CPU_ALLOCATION_LEVEL);
    }

    @type(value="ResourcePool,VirtualApp")
    public String getCpuSharesValue(ManagedObjectReference target) throws Exception {
        return this.getLocalizedSharesValueFromProperty(target, CPU_ALLOCATION_VALUE, CPU_ALLOCATION_LEVEL);
    }

    @type(value="ResourcePool,VirtualApp")
    public String getMemorySharesLevel(ManagedObjectReference target) throws Exception {
        return this.getLocalizedSharesLevelFromProperty(target, MEMORY_ALLOCATION_LEVEL);
    }

    @type(value="ResourcePool,VirtualApp")
    public String getMemorySharesValue(ManagedObjectReference target) throws Exception {
        return this.getLocalizedSharesValueFromProperty(target, MEMORY_ALLOCATION_VALUE, MEMORY_ALLOCATION_LEVEL);
    }

    private String getLocalizedSharesLevelFromProperty(ManagedObjectReference target, String property) throws Exception {
        SharesInfo.Level result = (SharesInfo.Level)this._queryExecutor.getProperty((Object)target, property);
        if (result == null) {
            return EMPTY_VALUE;
        }
        String sharesInfoLevelLabel = EMPTY_VALUE;
        switch (result) {
            case custom: {
                sharesInfoLevelLabel = ResourcePoolStringUtil.getString("customSharesLabel");
                break;
            }
            case high: {
                sharesInfoLevelLabel = ResourcePoolStringUtil.getString("highSharesLabel");
                break;
            }
            case normal: {
                sharesInfoLevelLabel = ResourcePoolStringUtil.getString("normalSharesLabel");
                break;
            }
            case low: {
                sharesInfoLevelLabel = ResourcePoolStringUtil.getString("lowSharesLabel");
            }
        }
        return sharesInfoLevelLabel;
    }

    private String getLocalizedSharesValueFromProperty(ManagedObjectReference target, String sharesValueProperty, String sharesLevelProperty) throws Exception {
        PropertyValue[] properties = this._queryExecutor.getProperties((Object)target, new String[]{sharesLevelProperty, sharesValueProperty, "owner"});
        if (properties == null) {
            return EMPTY_VALUE;
        }
        Object sharesValue = null;
        Object sharesLevel = null;
        ManagedObjectReference owner = null;
        for (PropertyValue propertyValue : properties) {
            if (propertyValue.propertyName.equals(sharesValueProperty)) {
                sharesValue = propertyValue.value;
                continue;
            }
            if (propertyValue.propertyName.equals(sharesLevelProperty)) {
                sharesLevel = propertyValue.value;
                continue;
            }
            if (!propertyValue.propertyName.equals("owner")) continue;
            owner = (ManagedObjectReference)propertyValue.value;
        }
        if (sharesValue == null) {
            return EMPTY_VALUE;
        }
        if (ManagedObjectUtil.isOfType(owner, ComputeResource.class)) {
            if (SharesInfo.Level.custom.equals(sharesLevel)) {
                return sharesValue.toString();
            }
            if (sharesValue == Integer.valueOf(0)) {
                return EMPTY_VALUE;
            }
        }
        return sharesValue.toString();
    }
}

