/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam;

import com.vmware.eam.util.EamUtil;
import com.vmware.vim.binding.eam.Agency;
import com.vmware.vim.binding.eam.EamObject;
import com.vmware.vim.binding.impl.vmodl.DataObjectImpl;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.data;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@data
public class AgencyData
extends DataObjectImpl {
    private static final Log _logger = LogFactory.getLog(AgencyData.class);
    private static final long serialVersionUID = 1L;
    public String goalState;
    public ManagedEntity.Status status = ManagedEntity.Status.gray;
    public String name;
    public ManagedObjectReference agencyRef;
    public boolean optimizedDeploy;

    public AgencyData(Agency agency, ManagedObjectReference agencyRef) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{agency, agencyRef});
        this.name = agency.getConfig().getAgencyName();
        Boolean optimizedDeploymentEnabled = agency.getConfig().optimizedDeploymentEnabled;
        this.optimizedDeploy = optimizedDeploymentEnabled != null ? optimizedDeploymentEnabled.booleanValue() : Boolean.FALSE.booleanValue();
        this.goalState = AgencyData.getLocalizedGoalStateDescription(agency.getRuntime().goalState);
        String status = agency.getRuntime().getStatus();
        if (StringUtil.isNullOrEmpty((String)status)) {
            _logger.error((Object)("Agency '" + this.name + "'gave a null or empty status value."));
        } else {
            try {
                this.status = ManagedEntity.Status.valueOf((String)status);
            }
            catch (IllegalArgumentException e) {
                _logger.error((Object)("Unknown EAM agency status value likely indicates an unsupported change in EAM VMODL. The offending value is '" + agency.getRuntime().getStatus() + "'"));
            }
        }
        this.agencyRef = agencyRef;
    }

    public AgencyData() {
    }

    private static String getLocalizedGoalStateDescription(String goalState) {
        String key;
        switch (EamObject.RuntimeInfo.GoalState.valueOf((String)goalState)) {
            case disabled: {
                key = "eamObject.runtimeInfo.goalState.disabled";
                break;
            }
            case enabled: {
                key = "eamObject.runtimeInfo.goalState.enabled";
                break;
            }
            case uninstalled: {
                key = "eamObject.runtimeInfo.goalState.uninstalled";
                break;
            }
            default: {
                key = "eamObject.runtimeInfo.goalState.unknown";
                _logger.error((Object)"Unknown EamObject.RuntimeInfo.GoalState value");
            }
        }
        return EamUtil.getLocalizedString(key, new String[0]);
    }
}

