/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam.util;

import com.vmware.eam.util.EamUtil;
import com.vmware.vim.binding.eam.Agency;
import com.vmware.vim.binding.eam.Agent;
import com.vmware.vim.binding.eam.EsxAgentManager;
import com.vmware.vim.binding.eam.version.version1;
import com.vmware.vim.binding.eam.version.version2;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.vcextension.common.VcExtensionConnection;
import com.vmware.vsphere.client.vcextension.common.VmomiClientFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EamConnection
extends VcExtensionConnection {
    private static final String EAM_MOREF_TYPE = "EsxAgentManager";
    private static final String EAM_MOREF_VALUE = "EsxAgentManager";
    private static final String SERVER_INFO_TYPE = "com.vmware.vim.eam";
    private static final String VC_VERSION_50 = "5.0";
    private static final String VC_VERSION_51 = "5.1";
    private static final String EAM_VMODL_PACKAGE = "com.vmware.vim.binding.eam";
    private static final Log _logger = LogFactory.getLog(EamConnection.class);
    private final String _serverGuid;

    private EamConnection(VmomiClientFactory.ClientSpec clientSpec) throws Exception {
        super(clientSpec);
        this._serverGuid = clientSpec.serverGuid;
    }

    public static EamConnection newInstance(String serverGuid) throws Exception {
        VmomiClientFactory.ClientSpec clientSpec = new VmomiClientFactory.ClientSpec();
        clientSpec.serverGuid = serverGuid;
        clientSpec.vmodlVersion = EamConnection.getVmodlVersion(serverGuid);
        clientSpec.vmodlPackage = EAM_VMODL_PACKAGE;
        clientSpec.extensionKey = SERVER_INFO_TYPE;
        clientSpec.extensionServerType = SERVER_INFO_TYPE;
        return new EamConnection(clientSpec);
    }

    public EsxAgentManager getEsxAgentManager() throws Exception {
        ManagedObjectReference eamRef = new ManagedObjectReference("EsxAgentManager", "EsxAgentManager");
        EsxAgentManager eam = (EsxAgentManager)this.getClient().createStub(EsxAgentManager.class, eamRef);
        if (eam == null) {
            String message = EamUtil.getLocalizedString("error.unableToContactEam", new String[0]);
            throw new Exception(message);
        }
        return eam;
    }

    public String getServerGuid() {
        return this._serverGuid;
    }

    public Agency getAgency(ManagedObjectReference agencyRef) {
        if (agencyRef == null) {
            throw new IllegalArgumentException("agencyRef is null");
        }
        if (!"Agency".equals(agencyRef.getType())) {
            throw new IllegalArgumentException("Invalid moref type " + agencyRef.getType());
        }
        return (Agency)this.getClient().createStub(Agency.class, agencyRef);
    }

    public Agent getAgent(ManagedObjectReference agentRef) {
        if (agentRef == null) {
            throw new IllegalArgumentException("agentRef is null");
        }
        if (!"Agent".equals(agentRef.getType())) {
            throw new IllegalArgumentException("Invalid moref type " + agentRef.getType());
        }
        return (Agent)this.getClient().createStub(Agent.class, agentRef);
    }

    private static Class<?> getVmodlVersion(String serverGuid) {
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        String vcVersion = vcService.getServiceVersion();
        if (vcVersion.startsWith(VC_VERSION_50)) {
            return version1.class;
        }
        if (vcVersion.startsWith(VC_VERSION_51)) {
            return version2.class;
        }
        _logger.warn((Object)("Unknown VcService version " + vcVersion + " - defaulting to version2 EAM VMODL"));
        return version2.class;
    }
}

