/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam.util;

import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.task.impl.TaskUtil;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EamUtil {
    private static final String RESOURCE_BUNDLE_NAME = "EamService";

    public static String getLocalizedString(String key, String ... args) {
        String result = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (String[])args, (ClassLoader)EamUtil.class.getClassLoader());
        return result;
    }

    public static List<ManagedObjectReference> filterMoRefs(Object[] objects) {
        if (ArrayUtil.isNullOrEmpty((Object[])objects)) {
            return Collections.emptyList();
        }
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (Object object : objects) {
            if (object == null || !(object instanceof ManagedObjectReference)) continue;
            result.add((ManagedObjectReference)object);
        }
        return result;
    }

    public static Map<String, List<ManagedObjectReference>> moRefPerServer(List<ManagedObjectReference> moRefs) {
        if (moRefs == null) {
            throw new IllegalArgumentException("List is null");
        }
        if (moRefs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<ManagedObjectReference>> result = new HashMap<String, List<ManagedObjectReference>>();
        for (ManagedObjectReference moRef : moRefs) {
            if (moRef == null) {
                throw new IllegalArgumentException("Argument array contains a null object");
            }
            if (!result.containsKey(moRef.getServerGuid())) {
                result.put(moRef.getServerGuid(), new ArrayList());
            }
            List serverMos = (List)result.get(moRef.getServerGuid());
            serverMos.add(moRef);
        }
        return result;
    }

    public static ManagedObjectReference eamToDsMoref(ManagedObjectReference eamMoRef, String serverGuid) {
        if (eamMoRef == null || StringUtil.isNullOrEmpty((String)serverGuid)) {
            throw new IllegalArgumentException("null or empty input");
        }
        String type2 = null;
        type2 = VirtualMachine.class.getSimpleName().equals(eamMoRef.getType()) || VirtualApp.class.getSimpleName().equals(eamMoRef.getType()) ? eamMoRef.getType() : "eam:" + eamMoRef.getType();
        ManagedObjectReference moref = new ManagedObjectReference(type2, eamMoRef.getValue(), serverGuid);
        return moref;
    }

    public static ManagedObjectReference dsToEamMoref(ManagedObjectReference dsMoRef) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dsMoRef});
        String type2 = dsMoRef.getType().startsWith("eam:") ? dsMoRef.getType().substring(4) : dsMoRef.getType();
        return new ManagedObjectReference(type2, dsMoRef.getValue());
    }

    public static ManagedObjectReference eamToVimMoref(ManagedObjectReference eamMoRef, String serverGuid) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{eamMoRef, serverGuid});
        String type2 = eamMoRef.getType().startsWith("eam:") ? eamMoRef.getType().substring(4) : eamMoRef.getType();
        ManagedObjectReference newMoRef = new ManagedObjectReference(type2, eamMoRef.getValue(), serverGuid);
        return newMoRef;
    }

    public static ClientTaskInfo newEamTask(String serverGuid, String descriptionKey) {
        ClientTaskInfo task = new ClientTaskInfo();
        task.description = EamUtil.getLocalizedString(descriptionKey, new String[0]);
        task.entity = ExtensionUriSpec.toDataServiceUri((String)"com.vmware.vim.eam", (String)serverGuid);
        task.entityName = EamUtil.getLocalizedString("eam.fullName", new String[0]);
        task.entityType = "VcExtension";
        task.primaryIconId = "CommonImages:solution.vCenterExtension";
        task.serverGuid = serverGuid;
        task.service = VcServiceUtil.getServiceName((String)serverGuid);
        task.source = TaskUtil.getLocalizedString((String)"source.vCenter");
        task.initiator = (String)SessionUtil.getData((String)"USER_NAME");
        return task;
    }

    public static ClientTaskInfo newFinishedEamTask(String serverGuid, String descriptionKey, Exception error) {
        ClientTaskInfo task = EamUtil.newEamTask(serverGuid, descriptionKey);
        task.cancelable = false;
        task.progress = 100;
        task.error = error;
        task.state = error == null ? TaskState.SUCCESS : TaskState.ERROR;
        task.pausable = false;
        task.startTime = task.queueTime = new Date();
        task.completionTime = task.queueTime;
        return task;
    }
}

