/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.common;

import com.vmware.cis.cm.common.CommonEndPointDataKey;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointData;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointUtil {
    private static final Log _log = LogFactory.getLog(EndpointUtil.class);

    public static void applyLocalUrl(ServiceEndPoint ep, String clientHostId, String endpointHostId) {
        if (EndpointUtil.isSameHost(clientHostId, endpointHostId)) {
            EndpointUtil.applyLocalUrl(ep);
        }
    }

    public static void applyLocalUrl(ServiceInfo[] svcInfoArr, String clientHostId) {
        if (svcInfoArr != null) {
            for (ServiceInfo svcInfo : svcInfoArr) {
                EndpointUtil.applyLocalUrl(svcInfo, clientHostId);
            }
        }
    }

    public static void applyLocalUrl(ServiceInfo svcInfo, String clientHostId) {
        if (svcInfo != null && EndpointUtil.isSameHost(clientHostId, svcInfo.getHostId())) {
            EndpointUtil.applyLocalUrl(svcInfo.getServiceEndPoints());
        }
    }

    private static boolean isSameHost(String clientHostId, String serviceHostId) {
        if (clientHostId != null && !clientHostId.isEmpty()) {
            return clientHostId.equalsIgnoreCase(serviceHostId);
        }
        return false;
    }

    private static void applyLocalUrl(ServiceEndPoint[] endPoints) {
        if (endPoints != null) {
            for (ServiceEndPoint ep : endPoints) {
                EndpointUtil.applyLocalUrl(ep);
            }
        }
    }

    private static void applyLocalUrl(ServiceEndPoint ep) {
        ServiceEndPointData[] epDataArr = ep.getEndPointData();
        if (epDataArr != null) {
            for (ServiceEndPointData epData : epDataArr) {
                if (!epData.getKey().equals(CommonEndPointDataKey.LOCAL_URL.endPointDataKey())) continue;
                try {
                    ep.setUrl(new URI(epData.getValue()));
                    String protocol = ep.getEndPointType().getEndPointProtocol();
                    if (protocol == null || !protocol.equals("vapi.json.https")) break;
                    ep.getEndPointType().setEndPointProtocol("vapi.json.http");
                }
                catch (Exception e) {
                    _log.error((Object)"Invalid local URL. Skipped", (Throwable)e);
                }
                break;
            }
        }
    }
}

