/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.common;

import com.vmware.vim.binding.cis.cm.ServiceAttribute;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointData;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceSpec;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointDataImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceSpecImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.http.conn.util.InetAddressUtils;

public class ServiceRegistration {
    private static final String DEFAULT_VERSION = "1.0";
    private static final String DEFAULT_SERVICE_NAME_RESOURCE_KEY = "servicenameresourcekey";
    private static final String DEFAULT_SERVICE_DESC_RESOURCE_KEY = "servicedescresourcekey";
    private static final String DEFAULT_SERVICE_GROUP_RESOURCE_KEY = "servicegroupresourcekey";
    private static final String DEFAULT_OWNER_ID = "service@vmware.com";
    private static final String DEFAULT_PRODUCT_ID = "cis";
    private static final String DEFAULT_SERVICE_TYPE_ID = "service";

    public static PropertyKeys createPropertyKeys(String componentId) {
        return new PropertyKeys(componentId);
    }

    public static ServiceSpec createServiceSpec(String componentId, Properties serviceProperties, Properties deployProperties, EndPointInfo[] epInfos) throws Exception {
        PropertyKeys keys = ServiceRegistration.createPropertyKeys(componentId);
        ServiceSpecImpl spec = new ServiceSpecImpl();
        spec.setServiceEndPoints(ServiceRegistration.createEndPointList(keys, serviceProperties, deployProperties, epInfos));
        spec.setServiceAttributes(new ServiceAttribute[0]);
        spec.setServiceNameResourceKey(serviceProperties.getProperty(keys.SERVICE_NAME_RESOURCE_KEY, DEFAULT_SERVICE_NAME_RESOURCE_KEY));
        spec.setServiceDescriptionResourceKey(serviceProperties.getProperty(keys.SERVICE_DESC_RESOURCE_KEY, DEFAULT_SERVICE_DESC_RESOURCE_KEY));
        spec.setServiceGroupResourceKey(serviceProperties.getProperty(keys.SERVICE_GROUP_RESOURCE_KEY, DEFAULT_SERVICE_GROUP_RESOURCE_KEY));
        spec.setServiceGroupInternalId(serviceProperties.getProperty(keys.SERVICE_GROUP_INTERNAL_ID, ""));
        spec.setHostId(serviceProperties.getProperty(keys.HOST_ID));
        spec.setOwnerId(serviceProperties.getProperty(keys.OWNERID, DEFAULT_OWNER_ID));
        spec.setServiceVersion(serviceProperties.getProperty(keys.SERVICE_VERSION, DEFAULT_VERSION));
        spec.setServiceType((ServiceType)new ServiceTypeImpl(serviceProperties.getProperty(keys.SERVICE_PRODUCT_ID, DEFAULT_PRODUCT_ID), serviceProperties.getProperty(keys.SERVICE_TYPE_ID, DEFAULT_SERVICE_TYPE_ID)));
        return spec;
    }

    private static ServiceEndPoint[] createEndPointList(PropertyKeys keys, Properties serviceProperties, Properties deployProperties, EndPointInfo[] epInfos) throws Exception {
        ArrayList<ServiceEndPointImpl> endPoints = new ArrayList<ServiceEndPointImpl>();
        String ipAddr = deployProperties.getProperty(keys.IPADDR, "localhost");
        String port = deployProperties.getProperty(keys.PORT);
        String[] pubCerts = ServiceRegistration.getPubCerts(keys, serviceProperties);
        for (EndPointInfo epi : epInfos) {
            String urlString = serviceProperties.getProperty("url." + epi._type.getTypeId());
            if (urlString == null || urlString.isEmpty()) continue;
            urlString = urlString.replace("<ipaddr>", InetAddressUtils.isIPv6Address((String)ipAddr) ? "[" + ipAddr + "]" : ipAddr);
            urlString = urlString.replace("<port>", port);
            URI url = new URI(urlString);
            endPoints.add(new ServiceEndPointImpl(pubCerts, url, epi._type, ServiceRegistration.getEndPointData(serviceProperties, epi._dataKeys)));
        }
        return endPoints.toArray(new ServiceEndPoint[endPoints.size()]);
    }

    private static String[] getPubCerts(PropertyKeys keys, Properties serviceProperties) {
        String pubCert;
        ArrayList<String> pubCertList = new ArrayList<String>();
        int i = 0;
        while ((pubCert = serviceProperties.getProperty(keys.PUBCERT + (i == 0 ? "" : Integer.valueOf(i)))) != null && !pubCert.isEmpty()) {
            pubCertList.add(pubCert);
            ++i;
        }
        return pubCertList.toArray(new String[pubCertList.size()]);
    }

    private static ServiceEndPointData[] getEndPointData(Properties serviceProperties, String[] dataKeys) {
        ArrayList<ServiceEndPointDataImpl> res = new ArrayList<ServiceEndPointDataImpl>();
        for (String key : dataKeys) {
            String datum = serviceProperties.getProperty("epdata." + key);
            res.add(new ServiceEndPointDataImpl(key, datum));
        }
        return res.toArray(new ServiceEndPointData[res.size()]);
    }

    public static class EndPointInfo {
        public final ServiceEndPointType _type;
        public final String[] _dataKeys;

        public EndPointInfo(ServiceEndPointType type) {
            this(type, null);
        }

        public EndPointInfo(ServiceEndPointType type, String[] dataKeys) {
            this._type = type;
            this._dataKeys = dataKeys == null ? new String[0] : Arrays.copyOf(dataKeys, dataKeys.length);
        }
    }

    public static class PropertyKeys {
        public final String SERVICE_VERSION;
        public final String OWNERID;
        public final String SERVICE_GROUP_INTERNAL_ID;
        public final String SERVICE_GROUP_RESOURCE_KEY;
        public final String SERVICE_DESC_RESOURCE_KEY;
        public final String SERVICE_NAME_RESOURCE_KEY;
        public final String SERVICE_PRODUCT_ID;
        public final String SERVICE_TYPE_ID;
        public final String PUBCERT;
        public final String HOST_ID;
        public final String IPADDR;
        public final String PORT;

        private PropertyKeys(String componentId) {
            componentId = componentId + ".";
            this.SERVICE_VERSION = componentId + "serviceversion";
            this.OWNERID = componentId + "ownerid";
            this.SERVICE_GROUP_INTERNAL_ID = componentId + "servicegroupinternalid";
            this.SERVICE_GROUP_RESOURCE_KEY = componentId + ServiceRegistration.DEFAULT_SERVICE_GROUP_RESOURCE_KEY;
            this.SERVICE_DESC_RESOURCE_KEY = componentId + "servicedescriptionresourcekey";
            this.SERVICE_NAME_RESOURCE_KEY = componentId + ServiceRegistration.DEFAULT_SERVICE_NAME_RESOURCE_KEY;
            this.SERVICE_PRODUCT_ID = componentId + "productid";
            this.SERVICE_TYPE_ID = componentId + "servicetypeid";
            this.PUBCERT = componentId + "pubcert";
            this.HOST_ID = componentId + "hostid";
            this.IPADDR = componentId + "ipaddr";
            this.PORT = componentId + "port";
        }
    }
}

