/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.common.endpoint;

import com.vmware.cis.cm.common.endpoint.HealthStatusServlet;
import com.vmware.cis.cm.common.endpoint.ServletHelper;
import com.vmware.cis.services.common.sso.StsCertManager;
import com.vmware.vim.binding.cis.cm.monitor.HealthStatus;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

public class HealthStatusEndPoint {
    private static HealthStatus.Code _statusCode = HealthStatus.Code.GREEN;
    private static LocalizableMessage[] _messages;

    public static synchronized void updateStatus(HealthStatus.Code statusCode, LocalizableMessage[] messages) {
        _statusCode = statusCode;
        _messages = messages == null ? null : Arrays.copyOf(messages, messages.length);
    }

    public static synchronized HealthStatusServlet.StatusInfo getStatus() {
        return new HealthStatusServlet.StatusInfo(_statusCode, _messages);
    }

    public static HealthStatusServlet createServlet(StsCertManager stsCertManager, ServletHelper.SamlTokenPolicy policy) {
        HealthStatusServlet s = new HealthStatusServlet(new Callable<HealthStatusServlet.StatusInfo>(){

            @Override
            public HealthStatusServlet.StatusInfo call() {
                return HealthStatusEndPoint.getStatus();
            }
        }, stsCertManager, policy);
        return s;
    }

    public static HealthStatusServlet createServlet(StsCertManager stsCertManager) {
        return HealthStatusEndPoint.createServlet(stsCertManager, null);
    }

    @Deprecated
    public static HealthStatusServlet createServlet(List<X509Certificate> stsCerts, ServletHelper.SamlTokenPolicy policy) {
        HealthStatusServlet s = new HealthStatusServlet(new Callable<HealthStatusServlet.StatusInfo>(){

            @Override
            public HealthStatusServlet.StatusInfo call() {
                return HealthStatusEndPoint.getStatus();
            }
        }, stsCerts, policy);
        return s;
    }

    @Deprecated
    public static HealthStatusServlet createServlet(List<X509Certificate> stsCerts) {
        return HealthStatusEndPoint.createServlet(stsCerts, null);
    }
}

