/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.actions;

import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkHostActionResolverPropertyProvider {
    private static final String RUNTIME_CONNECTION_STATE = "runtime.connectionState";
    private static final String RUNTIME_POWER_STATE = "runtime.powerState";
    private QueryExecutor _queryExecutor;

    public NetworkHostActionResolverPropertyProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @PropertyProvider(value="HostSystem/networkActionForConnectedAndPoweredOnHost")
    public List<Boolean> getNetworkActionForConnectedAndPoweredOnHost(Collection<ManagedObjectReference> refs) throws Exception {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        if (refs == null || refs.isEmpty()) {
            return result;
        }
        PropertyValue[] propValues = this._queryExecutor.getProperties(refs.toArray(), new String[]{RUNTIME_CONNECTION_STATE, RUNTIME_POWER_STATE});
        Map<ManagedObjectReference, Map<String, Object>> hostPropertiesByHost = NetworkHostActionResolverPropertyProvider.groupPropertiesByMor(propValues);
        for (ManagedObjectReference hostRef : refs) {
            if (!hostPropertiesByHost.containsKey(hostRef)) {
                result.add(false);
                continue;
            }
            result.add(NetworkHostActionResolverPropertyProvider.isHostPowerOnAndConnected((HostSystem.PowerState)hostPropertiesByHost.get(hostRef).get(RUNTIME_POWER_STATE), (HostSystem.ConnectionState)hostPropertiesByHost.get(hostRef).get(RUNTIME_CONNECTION_STATE)));
        }
        return result;
    }

    private static Map<ManagedObjectReference, Map<String, Object>> groupPropertiesByMor(PropertyValue[] properties) {
        HashMap<ManagedObjectReference, Map<String, Object>> result = new HashMap<ManagedObjectReference, Map<String, Object>>();
        if (properties == null) {
            return result;
        }
        for (PropertyValue propValue : properties) {
            ManagedObjectReference moRef = (ManagedObjectReference)propValue.resourceObject;
            if (!result.containsKey(moRef)) {
                result.put(moRef, new HashMap());
            }
            ((Map)result.get(moRef)).put(propValue.propertyName, propValue.value);
        }
        return result;
    }

    private static boolean isHostPowerOnAndConnected(HostSystem.PowerState powerState, HostSystem.ConnectionState connectionState) {
        return powerState != null && connectionState != null && HostSystem.ConnectionState.connected.equals((Object)connectionState) && HostSystem.PowerState.poweredOn.equals((Object)powerState);
    }
}

