/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvPortgroup;

import com.vmware.vim.binding.vim.BoolPolicy;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.LongPolicy;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.h5.network.dvPortgroup.model.DvPortgroupData;
import com.vmware.vsphere.client.h5.network.dvPortgroup.model.DvPortgroupProperties;
import com.vmware.vsphere.client.h5.network.dvPortgroup.model.DvPortgroupPropertiesData;
import com.vmware.vsphere.client.h5.network.dvs.model.DvsPolicyData;
import com.vmware.vsphere.client.h5.network.model.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NumericRangeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DvPortgroupParser {
    public static DvPortgroupData getDistributedPortGroupData(String key, String switchUuid, DvPortgroupData[] dvPortgroupData) {
        if (key == null || switchUuid == null || dvPortgroupData == null || dvPortgroupData.length == 0) {
            return null;
        }
        for (DvPortgroupData portgroupData : dvPortgroupData) {
            if (!portgroupData.key.equals(key) || !portgroupData.switchUuid.equals(switchUuid)) continue;
            return portgroupData;
        }
        return null;
    }

    public static DvPortgroupProperties getPortgroupProperties(DvPortgroupPropertiesData dvPortgroupPropertiesData) {
        boolean isTrafficFilteringAvailable;
        boolean isNetIormAvailable;
        boolean isAutoExpandAvailable;
        DvPortgroupProperties dvPortgroupProperties = new DvPortgroupProperties();
        if (dvPortgroupPropertiesData == null) {
            return dvPortgroupProperties;
        }
        boolean isUplink = dvPortgroupPropertiesData.isUplink != null && dvPortgroupPropertiesData.isUplink != false;
        int niocVersion = dvPortgroupPropertiesData.niocVersion == null ? 0 : dvPortgroupPropertiesData.niocVersion;
        dvPortgroupProperties.name = dvPortgroupPropertiesData.name;
        dvPortgroupProperties.description = dvPortgroupPropertiesData.description;
        dvPortgroupProperties.portBinding = dvPortgroupPropertiesData.type;
        boolean isPortBindingStatic = dvPortgroupPropertiesData.type != null && dvPortgroupPropertiesData.type.equals(DistributedVirtualPortgroup.PortgroupType.earlyBinding.name());
        boolean bl = isAutoExpandAvailable = isPortBindingStatic && !isUplink;
        if (isAutoExpandAvailable) {
            dvPortgroupProperties.portAllocation = dvPortgroupPropertiesData.autoExpand;
        }
        dvPortgroupProperties.numberOfPorts = dvPortgroupPropertiesData.numPorts;
        boolean isVmVnicResourcePoolAvailable = !isUplink && niocVersion == 3;
        boolean bl2 = isNetIormAvailable = !isUplink && niocVersion == 2;
        if (isVmVnicResourcePoolAvailable) {
            dvPortgroupProperties.vmVnicResourcePoolName = DvPortgroupParser.getVmVnicNetworkResourcePoolNameForNiocV3(dvPortgroupPropertiesData.vmVnicNetworkResourcePoolKey, dvPortgroupPropertiesData.vmVnicNetworkResourcePool);
        } else if (isNetIormAvailable && dvPortgroupPropertiesData.policy != null) {
            dvPortgroupProperties.vmVnicResourcePoolName = DvPortgroupParser.getVmVnicNetworkResourcePoolNameForNiocV2(dvPortgroupPropertiesData.networkResourcePoolKey, dvPortgroupPropertiesData.networkResourcePool);
        }
        if (dvPortgroupPropertiesData.policy == null) {
            return dvPortgroupProperties;
        }
        dvPortgroupProperties.portConfigResetAtDisconnect = dvPortgroupPropertiesData.policy.portConfigResetAtDisconnect;
        dvPortgroupProperties.blockOverrideAllowed = dvPortgroupPropertiesData.policy.blockOverrideAllowed;
        if (!isUplink) {
            dvPortgroupProperties.shapingOverrideAllowed = dvPortgroupPropertiesData.policy.shapingOverrideAllowed;
        }
        dvPortgroupProperties.vendorConfigOverrideAllowed = dvPortgroupPropertiesData.policy.vendorConfigOverrideAllowed;
        boolean bl3 = isTrafficFilteringAvailable = dvPortgroupPropertiesData.dvsCapability != null && dvPortgroupPropertiesData.dvsCapability.featuresSupported != null && dvPortgroupPropertiesData.dvsCapability.featuresSupported.networkFilterSupported != null && dvPortgroupPropertiesData.dvsCapability.featuresSupported.networkFilterSupported != false;
        if (isTrafficFilteringAvailable) {
            dvPortgroupProperties.trafficFilterOverrideAllowed = dvPortgroupPropertiesData.policy.trafficFilterOverrideAllowed;
        }
        if (dvPortgroupPropertiesData.policy instanceof VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy) {
            boolean isVmwareImplementation;
            VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy policy = (VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy)dvPortgroupPropertiesData.policy;
            boolean bl4 = isVmwareImplementation = dvPortgroupPropertiesData.dvsCapability != null && dvPortgroupPropertiesData.dvsCapability.featuresSupported instanceof VmwareDistributedVirtualSwitch.FeatureCapability;
            if (isVmwareImplementation) {
                dvPortgroupProperties.vlanOverrideAllowed = policy.vlanOverrideAllowed;
                if (!isUplink) {
                    dvPortgroupProperties.uplinkTeamingOverrideAllowed = policy.uplinkTeamingOverrideAllowed;
                    dvPortgroupProperties.securityPolicyOverrideAllowed = policy.securityPolicyOverrideAllowed;
                }
                VmwareDistributedVirtualSwitch.FeatureCapability supportedFeatures = (VmwareDistributedVirtualSwitch.FeatureCapability)dvPortgroupPropertiesData.dvsCapability.featuresSupported;
                if (supportedFeatures.ipfixSupported != null && supportedFeatures.ipfixSupported.booleanValue()) {
                    dvPortgroupProperties.ipfixOverrideAllowed = policy.ipfixOverrideAllowed;
                }
            }
            if (!isUplink && niocVersion == 2) {
                dvPortgroupProperties.networkResourcePoolOverrideAllowed = policy.networkResourcePoolOverrideAllowed;
            }
        }
        return dvPortgroupProperties;
    }

    public static HostNetworkDetailsData.PortPolicy getPortPolicy(DvPortgroupData dvPortGroupData) {
        if (dvPortGroupData == null || dvPortGroupData.defaultPortConfig == null) {
            return null;
        }
        HostNetworkDetailsData.PortPolicy resultPortPolicy = new HostNetworkDetailsData.PortPolicy();
        resultPortPolicy.inTrafficShaping = DvPortgroupParser.getTrafficShaping(dvPortGroupData.defaultPortConfig.inShapingPolicy);
        resultPortPolicy.outTrafficShaping = DvPortgroupParser.getTrafficShaping(dvPortGroupData.defaultPortConfig.outShapingPolicy);
        resultPortPolicy.blocked = DvPortgroupParser.getBooleanPolicyValue(dvPortGroupData.defaultPortConfig.blocked);
        if (dvPortGroupData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortGroupData.defaultPortConfig;
            resultPortPolicy.security = DvPortgroupParser.getSecurityPolicy(vmwarePortConfig);
            resultPortPolicy.vlan = DvPortgroupParser.getVlan(vmwarePortConfig, dvPortGroupData.dvsPolicyData);
            resultPortPolicy.monitoring = DvPortgroupParser.getBooleanPolicyValue(vmwarePortConfig.ipfixEnabled);
            resultPortPolicy.teamingAndFailover = DvPortgroupParser.getTeamingAndFailover(vmwarePortConfig.uplinkTeamingPolicy, dvPortGroupData.dvsPolicyData.uplinkNames, DvPortgroupParser.getLagNames(dvPortGroupData.dvsPolicyData.lags));
        }
        return resultPortPolicy;
    }

    private static HostNetworkDetailsData.PortPolicy.TeamingAndFailover getTeamingAndFailover(VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy uplinkTeamingPolicy, String[] uplinkNames, String[] lagNames) {
        HostNetworkDetailsData.PortPolicy.TeamingAndFailover teamingAndFailover = null;
        if (uplinkTeamingPolicy != null) {
            teamingAndFailover = new HostNetworkDetailsData.PortPolicy.TeamingAndFailover();
            teamingAndFailover.notifySwitches = DvPortgroupParser.getBooleanPolicyValue(uplinkTeamingPolicy.notifySwitches, false);
            boolean bl = teamingAndFailover.failback = !DvPortgroupParser.getBooleanPolicyValue(uplinkTeamingPolicy.rollingOrder, true);
            if (uplinkTeamingPolicy.failureCriteria != null) {
                teamingAndFailover.failureDetection = DvPortgroupParser.getBooleanPolicyValue(uplinkTeamingPolicy.failureCriteria.checkBeacon, false);
            }
            String string = teamingAndFailover.loadBalancing = uplinkTeamingPolicy.policy != null ? uplinkTeamingPolicy.policy.value : null;
            if (uplinkTeamingPolicy.uplinkPortOrder != null) {
                if (uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort != null) {
                    teamingAndFailover.activeAdapters = Arrays.asList(uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort);
                }
                if (uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort != null) {
                    teamingAndFailover.standByAdapters = Arrays.asList(uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort);
                }
            }
            teamingAndFailover.unusedAdapters = DvPortgroupParser.getUnusedUplinkNames(teamingAndFailover.activeAdapters, teamingAndFailover.standByAdapters, Arrays.asList(uplinkNames), Arrays.asList(lagNames));
        }
        return teamingAndFailover;
    }

    private static List<String> getUnusedUplinkNames(List<String> activeAdapters, List<String> standByAdapters, List<String> uplinkNames, List<String> lagNames) {
        ArrayList<String> unusedUplinks = new ArrayList<String>();
        ArrayList<String> allUplinkNames = new ArrayList<String>();
        allUplinkNames.addAll(uplinkNames);
        allUplinkNames.addAll(lagNames);
        for (String uplink : allUplinkNames) {
            if (activeAdapters.contains(uplink) || standByAdapters.contains(uplink)) continue;
            unusedUplinks.add(uplink);
        }
        return unusedUplinks;
    }

    public static String getPvlanTypeText(String pvlanType) {
        try {
            switch (VmwareDistributedVirtualSwitch.PvlanPortType.valueOf((String)pvlanType)) {
                case promiscuous: {
                    return NetworkStringUtil.getString("dvpg.policy.vlan.private.type.promiscuous");
                }
                case isolated: {
                    return NetworkStringUtil.getString("dvpg.policy.vlan.private.type.isolated");
                }
                case community: {
                    return NetworkStringUtil.getString("dvpg.policy.vlan.private.type.community");
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return "Unsupported VLAN type.";
        }
    }

    private static HostNetworkDetailsData.PortPolicy.TrafficShaping getTrafficShaping(DistributedVirtualPort.TrafficShapingPolicy shapingPolicy) {
        HostNetworkDetailsData.PortPolicy.TrafficShaping trafficShaping = null;
        if (shapingPolicy != null) {
            trafficShaping = new HostNetworkDetailsData.PortPolicy.TrafficShaping();
            trafficShaping.enabled = shapingPolicy.enabled != null && shapingPolicy.enabled.value != null ? shapingPolicy.enabled.value : false;
            if (trafficShaping.enabled.booleanValue()) {
                trafficShaping.averageBandwidthSummary = FormatUtil.getBitRateFormatted((Number)DvPortgroupParser.getLongValue(shapingPolicy.averageBandwidth, 100000L * FormatUtil.KBPS), (int)0, (long)FormatUtil.BPS, (long)FormatUtil.KBPS, (boolean)true);
                trafficShaping.burstSizeSummary = FormatUtil.getDataSizeFormatted((Number)DvPortgroupParser.getLongValue(shapingPolicy.burstSize, 100000L * FormatUtil.KBPS), (int)0, (long)1L, (long)1024L, (boolean)true);
                trafficShaping.peakBandwidthSummary = FormatUtil.getBitRateFormatted((Number)DvPortgroupParser.getLongValue(shapingPolicy.peakBandwidth, 100000L * FormatUtil.KBPS), (int)0, (long)FormatUtil.BPS, (long)FormatUtil.KBPS, (boolean)true);
            }
        }
        return trafficShaping;
    }

    private static HostNetworkDetailsData.PortPolicy.Security getSecurityPolicy(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfig) {
        HostNetworkDetailsData.PortPolicy.Security security = null;
        if (vmwarePortConfig.securityPolicy != null) {
            security = new HostNetworkDetailsData.PortPolicy.Security();
            security.allowPromiscuous = vmwarePortConfig.securityPolicy.allowPromiscuous.value;
            security.forgedTransmits = vmwarePortConfig.securityPolicy.forgedTransmits.value;
            security.macChanges = vmwarePortConfig.securityPolicy.macChanges.value;
        }
        return security;
    }

    private static HostNetworkDetailsData.PortPolicy.Vlan getVlan(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfig, DvsPolicyData dvsPolicyData) {
        HostNetworkDetailsData.PortPolicy.Vlan vlan = new HostNetworkDetailsData.PortPolicy.Vlan();
        if (vmwarePortConfig.vlan instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            VmwareDistributedVirtualSwitch.VlanIdSpec vlanIdSpec = (VmwareDistributedVirtualSwitch.VlanIdSpec)vmwarePortConfig.vlan;
            if (vlanIdSpec.vlanId == 0) {
                vlan.type = "none";
            } else {
                vlan.type = "vlan";
                vlan.value = String.valueOf(vlanIdSpec.vlanId);
            }
        } else if (vmwarePortConfig.vlan instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            vlan.type = "trunk";
            vlan.value = NumericRangeUtil.asString(((VmwareDistributedVirtualSwitch.TrunkVlanSpec)vmwarePortConfig.vlan).vlanId);
        } else if (vmwarePortConfig.vlan instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanMapEntry = DvPortgroupParser.findPvlanMapEntry(dvsPolicyData.pvlanMapEntry, ((VmwareDistributedVirtualSwitch.PvlanSpec)vmwarePortConfig.vlan).pvlanId);
            vlan.type = "private";
            vlan.value = DvPortgroupParser.parsePvlanSpec(pvlanMapEntry);
        }
        return vlan;
    }

    private static String parsePvlanSpec(VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanMapEntry) {
        return NetworkStringUtil.getString("dvpg.policy.vlan.displayFormat", DvPortgroupParser.getPvlanTypeText(pvlanMapEntry.pvlanType), Integer.toString(pvlanMapEntry.primaryVlanId), Integer.toString(pvlanMapEntry.secondaryVlanId));
    }

    private static VmwareDistributedVirtualSwitch.PvlanMapEntry findPvlanMapEntry(VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanMapEntry, int pvlanId) {
        for (VmwareDistributedVirtualSwitch.PvlanMapEntry entry : pvlanMapEntry) {
            if (entry.secondaryVlanId != pvlanId) continue;
            return entry;
        }
        return null;
    }

    private static String[] getLagNames(VmwareDistributedVirtualSwitch.LacpGroupConfig[] lags) {
        if (lags == null) {
            return new String[0];
        }
        String[] lagNames = new String[lags.length];
        for (int i = 0; i < lags.length; ++i) {
            lagNames[i] = lags[i].name;
        }
        return lagNames;
    }

    private static boolean isVmwareImplementation(DistributedVirtualSwitch.Capability capability) {
        return capability != null && capability.featuresSupported instanceof VmwareDistributedVirtualSwitch.FeatureCapability;
    }

    private static Boolean getBooleanPolicyValue(BoolPolicy boolPolicy) {
        return boolPolicy != null ? boolPolicy.value : null;
    }

    private static boolean getBooleanPolicyValue(BoolPolicy boolPolicy, boolean defaultValue) {
        Boolean policyValue = DvPortgroupParser.getBooleanPolicyValue(boolPolicy);
        return policyValue != null ? policyValue : defaultValue;
    }

    private static Long getLongValue(LongPolicy valuePolicy, long defaultValue) {
        return valuePolicy == null || valuePolicy.value == null ? defaultValue : valuePolicy.value;
    }

    private static String getVmVnicNetworkResourcePoolNameForNiocV3(String key, VmVnicNetworkResourcePool[] poolsArray) {
        if (key != null && !key.equals("-1")) {
            if (poolsArray != null) {
                for (VmVnicNetworkResourcePool pool : poolsArray) {
                    if (pool == null || pool.key == null || pool.name == null || !pool.key.equals(key)) continue;
                    return pool.name;
                }
            }
            return NetworkStringUtil.getString("dvpg.properties.vmVnicResPool.na");
        }
        return NetworkStringUtil.getString("dvpg.properties.vmVnicResPool.default");
    }

    private static String getVmVnicNetworkResourcePoolNameForNiocV2(String key, NetworkResourcePool[] poolsArray) {
        if (key == null || key.equals("-1")) {
            return NetworkStringUtil.getString("dvpg.policy.iorm.pool.none");
        }
        if (poolsArray != null) {
            for (NetworkResourcePool pool : poolsArray) {
                if (pool == null || pool.key == null || pool.name == null || !pool.key.equals(key)) continue;
                return pool.name;
            }
        }
        return null;
    }
}

