/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvPortgroup;

import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.h5.network.dvPortgroup.DvPortgroupParser;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;

public class DvPortgroupVlanConfig {
    private VmwareDistributedVirtualSwitch.VlanSpec _vlanSpec;
    private VmwareDistributedVirtualSwitch.PvlanMapEntry[] _pvlanConfigs;
    private VmwareDistributedVirtualSwitch.PvlanMapEntry _pvlanConfig;
    private VlanType _vlanType;
    private int _vlanId = 0;
    private String _vlanIdRanges;

    public DvPortgroupVlanConfig(VmwareDistributedVirtualSwitch.VlanSpec vlanSpec, VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanConfigs) {
        this._vlanSpec = vlanSpec;
        this._pvlanConfigs = pvlanConfigs;
        this._pvlanConfig = this.getPrivateVlanConfig();
        this.setVlanDetails();
    }

    private void setVlanDetails() {
        this._vlanId = 0;
        this._vlanIdRanges = null;
        if (this._vlanSpec == null) {
            this._vlanType = VlanType.None;
        } else if (this._vlanSpec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            this._vlanId = ((VmwareDistributedVirtualSwitch.VlanIdSpec)this._vlanSpec).getVlanId();
            this._vlanType = this._vlanId == 0 ? VlanType.None : VlanType.Vlan;
        } else if (this._vlanSpec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            this._vlanType = VlanType.Trunk;
            NumericRange[] ranges = ((VmwareDistributedVirtualSwitch.TrunkVlanSpec)this._vlanSpec).getVlanId();
            this._vlanIdRanges = NetworkUtil.getNumericRangeAsString(ranges);
        } else {
            this._vlanType = this._vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec ? VlanType.Private : null;
        }
    }

    private VmwareDistributedVirtualSwitch.PvlanMapEntry getPrivateVlanConfig() {
        if (ArrayUtil.isNullOrEmpty((Object[])this._pvlanConfigs)) {
            return null;
        }
        if (this._vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            VmwareDistributedVirtualSwitch.PvlanSpec pvlanSpec = (VmwareDistributedVirtualSwitch.PvlanSpec)this._vlanSpec;
            int pvlanId = pvlanSpec.pvlanId;
            for (VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanEntry : this._pvlanConfigs) {
                if (pvlanEntry.secondaryVlanId != pvlanId) continue;
                this._pvlanConfig = pvlanEntry;
                break;
            }
        }
        return this._pvlanConfig;
    }

    public String getVlanTypeNameKey() {
        switch (this._vlanType) {
            case None: 
            case Vlan: {
                return "DvPortgroupSummaryView.vlanId";
            }
            case Trunk: {
                return "DvPortgroupSummaryView.vlanTrunk";
            }
            case Private: {
                return "DvPortgroupSummaryView.privateVlan";
            }
        }
        return null;
    }

    public String getVlanTypeValueLocalized() {
        switch (this._vlanType) {
            case None: {
                return NetworkStringUtil.getString("dvpg.policy.vlan.id.none");
            }
            case Vlan: {
                return Integer.toString(this._vlanId);
            }
            case Trunk: {
                return this._vlanIdRanges;
            }
            case Private: {
                if (this._pvlanConfig == null) {
                    return null;
                }
                String privateVlanTypeText = DvPortgroupParser.getPvlanTypeText(this._pvlanConfig.pvlanType);
                return NetworkStringUtil.getString("dvpg.policy.vlan.displayFormat", privateVlanTypeText, Integer.toString(this._pvlanConfig.getPrimaryVlanId()), Integer.toString(this._pvlanConfig.getSecondaryVlanId()));
            }
        }
        return null;
    }

    public static enum VlanType {
        None("none"),
        Vlan("vlan"),
        Trunk("trunk"),
        Private("private");

        private final String _type;

        private VlanType(String value) {
            this._type = value;
        }

        public String toString() {
            return this._type;
        }
    }
}

