/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvPortgroup.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.Tag;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceMeterData;
import com.vmware.vsphere.client.commonservice.util.Util;
import com.vmware.vsphere.client.h5.network.dvPortgroup.DvPortgroupVlanConfig;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;

@QueryBinding(value="DistributedVirtualPortgroup")
public final class DvPortgroupSummaryData
extends BaseSummaryData
implements ResourceMeterData {
    @Property(value="DistributedVirtualPortgroup/config")
    private DistributedVirtualPortgroup.ConfigInfo config;
    @Property(value="DistributedVirtualPortgroup/config/defaultPortConfig")
    private DistributedVirtualPort.Setting defaultPortConfig;
    @Relationship(value={"DistributedVirtualPortgroup/config/distributedVirtualSwitch"})
    @Property(value="VmwareDistributedVirtualSwitch/config/pvlanConfig")
    private VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanConfigs;
    @Property(value="DistributedVirtualPortgroup/tag")
    private Tag[] tags;
    @Relationship(value={"DistributedVirtualPortgroup/config/distributedVirtualSwitch"})
    @Property(value="AnyDistributedVirtualSwitch/name")
    private String switchName;
    @Property(value="DistributedVirtualPortgroup/availablePorts")
    private int availablePortsCount;

    private ManagedObjectReference getProviderRef() {
        return (ManagedObjectReference)this.provider;
    }

    public ResourceMeterData.ResourceMeter[] getResourceMeters() {
        if (StringUtil.isNullOrEmpty((String)this.switchName)) {
            return null;
        }
        int totalPortCount = this.config.getNumPorts();
        int usedPortCount = totalPortCount - this.availablePortsCount;
        return new ResourceMeterData.ResourceMeter[]{new ResourceMeterData.ResourceMeter("PortResourceDataItem.PortLabel", Integer.toString(this.availablePortsCount), Integer.toString(usedPortCount), Integer.toString(totalPortCount), Util.getPercentageUsage((long)usedPortCount, (long)totalPortCount))};
    }

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        boolean isPortAllocationAllowed = DvPortgroupSummaryData.isPortAllocationAllowed(this.config.getType(), this.getProviderRef(), this.tags);
        ArrayList<BaseSummaryData.LabelValue> listLabels = new ArrayList<BaseSummaryData.LabelValue>(3);
        listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupSummaryView.pgType", (Object)DvPortgroupSummaryData.getPortgroupType(this.config.getType())));
        if (isPortAllocationAllowed) {
            listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupSummaryView.pgAlloc", (Object)DvPortgroupSummaryData.getPortAllocationType(this.config.getAutoExpand())));
        }
        if (this.defaultPortConfig != null && this.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            DvPortgroupVlanConfig vlanConfig = new DvPortgroupVlanConfig(((VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)this.defaultPortConfig).getVlan(), this.pvlanConfigs);
            String vlanTypeNameKey = vlanConfig.getVlanTypeNameKey();
            String vlanTypeValue = vlanConfig.getVlanTypeValueLocalized();
            listLabels.add(new BaseSummaryData.LabelValue(vlanTypeNameKey, (Object)vlanTypeValue));
        }
        return listLabels.toArray(new BaseSummaryData.LabelValue[listLabels.size()]);
    }

    private static String getPortgroupType(String type) {
        DistributedVirtualPortgroup.PortgroupType pgType = Enum.valueOf(DistributedVirtualPortgroup.PortgroupType.class, type);
        switch (pgType) {
            case lateBinding: {
                return NetworkStringUtil.getString("dvpg.type.lateBinding");
            }
            case earlyBinding: {
                return NetworkStringUtil.getString("dvpg.type.earlyBinding");
            }
            case ephemeral: {
                return NetworkStringUtil.getString("dvpg.type.ephemeral");
            }
        }
        return null;
    }

    private static String getPortAllocationType(boolean isAutoExpand) {
        return isAutoExpand ? NetworkStringUtil.getString("dvpg.pgAlloc.autoExpand.true") : NetworkStringUtil.getString("dvpg.pgAlloc.autoExpand.false");
    }

    private static boolean isPortAllocationAllowed(String type, ManagedObjectReference objRef, Tag[] tags) {
        boolean isStaticPortBinding = type.equalsIgnoreCase(DistributedVirtualPortgroup.PortgroupType.earlyBinding.toString());
        boolean isUplink = NetworkUtil.isUplink(objRef, tags);
        return isStaticPortBinding && !isUplink;
    }
}

