/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.ProductSpec;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;

@QueryBinding(value="AnyDistributedVirtualSwitch")
public final class DvsSummaryData
extends BaseSummaryData {
    @Property(value="AnyDistributedVirtualSwitch/config/productInfo")
    public transient ProductSpec productInfo;
    @Property(value="AnyDistributedVirtualSwitch/config/networkResourceManagementEnabled")
    public transient boolean networkResourceManagementEnabled;
    @Property(value="AnyDistributedVirtualSwitch/capability/featuresSupported/networkResourceManagementCapability/networkResourceManagementSupported")
    public transient boolean networkResourceManagementSupported;
    @Property(value="AnyDistributedVirtualSwitch/config/healthCheckConfig")
    public DistributedVirtualSwitch.HealthCheckConfig[] healtCheckConfig;

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("DvsSummaryView.manufacturer", (Object)this.productInfo.getVendor()), new BaseSummaryData.LabelValue("DvsSummaryView.version", (Object)this.productInfo.getVersion())};
    }

    public BaseSummaryData.Badge[] getBadges() {
        boolean isHealthCheckEnabled;
        ArrayList<BaseSummaryData.Badge> listBadges = new ArrayList<BaseSummaryData.Badge>();
        if (NetworkUtil.isVmwareVendor(this.productInfo.getVendor())) {
            listBadges.add(new BaseSummaryData.Badge("icon-vSphere-vmwareDvs24", "DvsSummaryView.vmwareDvsTooltip", false));
        }
        if (this.networkResourceManagementEnabled && this.networkResourceManagementSupported) {
            listBadges.add(new BaseSummaryData.Badge("icon-vSphere-iorm24", "DvsSummaryView.iormEnabled", false));
        }
        if (isHealthCheckEnabled = this.getIsHealthCheckEnabled()) {
            listBadges.add(new BaseSummaryData.Badge("icon-vSphere-healthCheck24", "DvsSummaryView.healthcheckTooltip", false));
        }
        return listBadges.toArray(new BaseSummaryData.Badge[listBadges.size()]);
    }

    public boolean getIsHealthCheckEnabled() {
        if (ArrayUtil.isNullOrEmpty((Object[])this.healtCheckConfig)) {
            return false;
        }
        for (DistributedVirtualSwitch.HealthCheckConfig config : this.healtCheckConfig) {
            if (!config.getEnable().booleanValue()) continue;
            return true;
        }
        return false;
    }
}

