/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.netstack;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.host.DnsConfig;
import com.vmware.vim.binding.vim.host.IpRouteConfig;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.RuntimeInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import com.vmware.vsphere.client.h5.network.host.netstack.model.HostNetStackData;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackData;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackItem;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class HostNetstackPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;

    public HostNetstackPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="netstack", property="netStackData")
    public HostNetStackData getNetStackData(ManagedObjectReference hostRef) {
        LinkedList<NetStackItem> netStackItems = new LinkedList<NetStackItem>();
        NetStackData netStackData = (NetStackData)((Object)this._queryBindingService.prepare(NetStackData.class).fetch((Object)hostRef));
        HostNetStackData hostNetStackData = new HostNetStackData();
        if (netStackData != null) {
            hostNetStackData.ipv6Enabled = netStackData.ipv6Enabled;
            if (netStackData.multipleNetworkStackInstanceSupported) {
                if (!ArrayUtil.isNullOrEmpty((Object[])netStackData.netStackInstances)) {
                    Map<String, RuntimeInfo.NetStackInstanceRuntimeInfo> netStackInstRuntimeInfoMap = HostNetstackPropertyProvider.buildNetStackInstRuntimeInfoMap(netStackData.netStackInstanceRuntimeInfo);
                    for (NetStackInstance netStackInstance : netStackData.netStackInstances) {
                        if (netStackInstance == null || StringUtil.isNullOrEmpty((String)netStackInstance.key)) continue;
                        NetStackItem netStackItem = new NetStackItem();
                        netStackItem.name = NetStackUtil.getNetStackInstanceName(netStackInstance);
                        netStackItem.isSystemStack = NetStackUtil.isSystemStackKeyValue(netStackInstance.key);
                        HostNetstackPropertyProvider.populateGatewayInfo(netStackItem, netStackInstance.ipRouteConfig);
                        HostNetstackPropertyProvider.populateDnsInfo(netStackItem, netStackInstance.dnsConfig);
                        netStackItem.virtualNicCount = HostNetstackPropertyProvider.getVnicCount(netStackInstRuntimeInfoMap.get(netStackInstance.key));
                        if (NetStackUtil.isDefaultNetStackInstance(netStackInstance.key)) {
                            netStackItems.add(0, netStackItem);
                            continue;
                        }
                        netStackItems.add(netStackItem);
                    }
                }
            } else {
                NetStackItem defaultNetStackItem = new NetStackItem();
                defaultNetStackItem.name = NetworkStringUtil.getString("NetStackInstance.defaultStackName");
                defaultNetStackItem.isSystemStack = true;
                HostNetstackPropertyProvider.populateGatewayInfo(defaultNetStackItem, netStackData.hostRouteConfig);
                HostNetstackPropertyProvider.populateDnsInfo(defaultNetStackItem, netStackData.hostDnsConfig);
                defaultNetStackItem.virtualNicCount = netStackData.vmkernelVnicsCount;
                netStackItems.add(defaultNetStackItem);
            }
        }
        hostNetStackData.netStackItems = netStackItems.toArray(new NetStackItem[netStackItems.size()]);
        return hostNetStackData;
    }

    private static void populateGatewayInfo(NetStackItem netStackItem, IpRouteConfig ipRouteConfig) {
        if (ipRouteConfig != null) {
            netStackItem.ipv4GatewayAddress = ipRouteConfig.defaultGateway;
            netStackItem.ipv6GatewayAddress = ipRouteConfig.ipV6DefaultGateway;
        }
        netStackItem.ipv4GatewayAddress = NetworkStringUtil.returnNaIfEmpty(netStackItem.ipv4GatewayAddress);
        netStackItem.ipv6GatewayAddress = NetworkStringUtil.returnNaIfEmpty(netStackItem.ipv6GatewayAddress);
    }

    private static void populateDnsInfo(NetStackItem netStackItem, DnsConfig dnsConfig) {
        if (dnsConfig != null && !ArrayUtil.isNullOrEmpty((Object[])dnsConfig.address)) {
            netStackItem.preferredDnsServer = dnsConfig.address[0];
            if (dnsConfig.address.length > 1) {
                netStackItem.alternateDnsServer = dnsConfig.address[1];
            }
        }
        netStackItem.preferredDnsServer = NetworkStringUtil.returnNaIfEmpty(netStackItem.preferredDnsServer);
        netStackItem.alternateDnsServer = NetworkStringUtil.returnNaIfEmpty(netStackItem.alternateDnsServer);
    }

    private static int getVnicCount(RuntimeInfo.NetStackInstanceRuntimeInfo runtimeInfo) {
        if (runtimeInfo != null && runtimeInfo.vmknicKeys != null) {
            return runtimeInfo.vmknicKeys.length;
        }
        return 0;
    }

    private static Map<String, RuntimeInfo.NetStackInstanceRuntimeInfo> buildNetStackInstRuntimeInfoMap(RuntimeInfo.NetStackInstanceRuntimeInfo[] runtimeInfos) {
        HashMap<String, RuntimeInfo.NetStackInstanceRuntimeInfo> netStackInstanceRuntimeInfoMap = new HashMap<String, RuntimeInfo.NetStackInstanceRuntimeInfo>();
        if (runtimeInfos != null) {
            for (RuntimeInfo.NetStackInstanceRuntimeInfo runtimeInfo : runtimeInfos) {
                netStackInstanceRuntimeInfoMap.put(runtimeInfo.netStackInstanceKey, runtimeInfo);
            }
        }
        return netStackInstanceRuntimeInfoMap;
    }
}

