/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.pnic;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.host.pnic.PnicParser;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicDetailsData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicDetailsItem;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicItem;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicSwitchData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicsWithDetailsModel;
import java.util.LinkedList;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostPnicPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(HostPnicPropertyProvider.class);
    private final QueryBindingService _queryBindingService;

    public HostPnicPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="pnic", property="physicalAdapterItems")
    public HostPnicItem[] getPhysicalAdapterItems(ManagedObjectReference hostRef) throws Throwable {
        LinkedList<HostPnicItem> pnicItems = new LinkedList<HostPnicItem>();
        HostPnicData pnicData = null;
        try {
            pnicData = (HostPnicData)((Object)this._queryBindingService.prepare(HostPnicData.class).fetch((Object)hostRef));
        }
        catch (Exception ex) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
            _logger.error((Object)("Failed to retrieve data: " + ex.getMessage()), (Throwable)ex);
            if (rootCause != null) {
                throw rootCause;
            }
            throw ex;
        }
        PhysicalNic[] physicalNics = null;
        if (pnicData != null && pnicData.networkInfo != null) {
            physicalNics = pnicData.networkInfo.getPnic();
        }
        if (physicalNics != null) {
            for (PhysicalNic pnic : physicalNics) {
                HostPnicItem item = new HostPnicItem();
                item.device = pnic.device;
                if (pnic.linkSpeed != null) {
                    item.actualSpeed = pnic.linkSpeed.speedMb;
                }
                if (pnic.spec != null && pnic.spec.linkSpeed != null) {
                    item.configuredSpeed = pnic.spec.linkSpeed.speedMb;
                }
                item.mac = pnic.mac;
                item.wakeOnLanSupported = pnic.wakeOnLanSupported;
                item.virtualSwitch = PnicParser.getVirtualSwitchName(pnic, pnicData.networkInfo);
                item.networkHint = PnicParser.getNetworkHint(pnic.device, pnicData.networkInfo.ipV6Enabled, pnicData.networkHints);
                pnicItems.add(item);
            }
        }
        return pnicItems.toArray(new HostPnicItem[pnicItems.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="pnic", property="physicalAdapterItemDetails")
    public HostPnicDetailsItem getPhysicalAdapterItemDetails(ManagedObjectReference hostRef, String device) {
        HostPnicDetailsData pnicDetailsData = (HostPnicDetailsData)((Object)this._queryBindingService.prepare(HostPnicDetailsData.class).fetch((Object)hostRef));
        PhysicalNic pnic = null;
        for (PhysicalNic nic : pnicDetailsData.pnics) {
            if (!device.equals(nic.device)) continue;
            pnic = nic;
        }
        if (pnic == null) {
            _logger.error((Object)String.format("No physical adapter with key '%s' found in host '%s'", device, hostRef.toString()));
            return null;
        }
        return PnicParser.createHostPnicDetailsItem(pnic, pnicDetailsData);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="pnic", property="unclaimedPhysicalAdapters")
    public HostPnicsWithDetailsModel getUnclaimedPhysicalAdapters(ManagedObjectReference hostRef) {
        HostPnicSwitchData pnicSwitchData = (HostPnicSwitchData)((Object)this._queryBindingService.prepare(HostPnicSwitchData.class).fetch((Object)hostRef));
        return PnicParser.getUnclaimedPhysicalAdapters(pnicSwitchData);
    }
}

