/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.pnic;

import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PciDevice;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.host.pnic.model.CdpInfoItem;
import com.vmware.vsphere.client.h5.network.host.pnic.model.DeviceCapabilitiesItem;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicDetailsData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicDetailsItem;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicSwitchData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicsWithDetailsModel;
import com.vmware.vsphere.client.h5.network.host.pnic.model.LldpInfoItem;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PnicParser {
    private static final Log _logger = LogFactory.getLog(PnicParser.class);
    public static final int VLAN_NUM_NONE = 0;
    public static final int VLAN_NUM_ALL = 4095;

    public static HostPnicDetailsItem createHostPnicDetailsItem(PhysicalNic pnic, HostPnicDetailsData pnicDetailsData) {
        PciDevice pciDevice;
        if (pnic == null || pnicDetailsData == null) {
            return null;
        }
        HostPnicDetailsItem pnicDetailsItem = new HostPnicDetailsItem();
        pnicDetailsItem.location = NetworkStringUtil.getString("pnicDetails.pci", pnic.getPci());
        pnicDetailsItem.deviceName = pnic.getDevice();
        pnicDetailsItem.driverName = pnic.getDriver();
        boolean bl = pnicDetailsItem.isConnected = pnic.getLinkSpeed() != null;
        if (pnicDetailsItem.isConnected) {
            pnicDetailsItem.actualSpeed = pnic.getLinkSpeed().getSpeedMb();
            pnicDetailsItem.isActualSpeedFullDuplex = pnic.getLinkSpeed().isDuplex();
            if (pnic.getSpec() != null && pnic.getSpec().getLinkSpeed() != null) {
                pnicDetailsItem.configuredSpeed = pnic.getSpec().getLinkSpeed().getSpeedMb();
                pnicDetailsItem.isConfiguredSpeedFullDuplex = pnic.getSpec().getLinkSpeed().isDuplex();
            }
        }
        if ((pciDevice = PnicParser.getPciDevice(pnic, pnicDetailsData.pciDevices)) != null) {
            pnicDetailsItem.adapterName = String.format("%s %s", pciDevice.getVendorName(), pciDevice.getDeviceName());
        }
        pnicDetailsItem.networkHints = PnicParser.getNetworkHints(pnic.getDevice(), pnicDetailsData.ipV6Enabled, pnicDetailsData.networkHints);
        if (pnic.resourcePoolSchedulerAllowed != null && !NetworkUtil.isPnicAttachedToVss(pnic, pnicDetailsData.vSwitches)) {
            pnicDetailsItem.resourcePoolSchedulerAllowed = pnic.resourcePoolSchedulerAllowed;
            pnicDetailsItem.resourcePoolSchedulerDisallowedReasons = PnicParser.getResourcePoolSchedulerDisallowedReasons(pnic);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])pnicDetailsData.networkHints)) {
            pnicDetailsItem.areNetworkHintsRetrieved = true;
            PhysicalNic.NetworkHint networkHint = PnicParser.getNetworkHint(pnic.device, pnicDetailsData.networkHints);
            pnicDetailsItem.cdpInfo = PnicParser.getCdpInfoItem(networkHint);
            pnicDetailsItem.lldpInfo = PnicParser.getLldpInfoItem(networkHint);
        }
        return pnicDetailsItem;
    }

    public static HostPnicsWithDetailsModel getUnclaimedPhysicalAdapters(HostPnicSwitchData pnicSwitchData) {
        HostPnicsWithDetailsModel hostPnicsWithDetailsModel = new HostPnicsWithDetailsModel();
        if (pnicSwitchData == null || pnicSwitchData.pnics == null || pnicSwitchData.pnics.length == 0) {
            return hostPnicsWithDetailsModel;
        }
        hostPnicsWithDetailsModel.pnicDetails = new HashMap<String, HostPnicDetailsItem>();
        for (PhysicalNic pnic : pnicSwitchData.pnics) {
            if (PnicParser.getVirtualSwitchName(pnic, pnicSwitchData.vSwitches, pnicSwitchData.proxySwitches, pnicSwitchData.opaqueSwitches) != null) continue;
            if (hostPnicsWithDetailsModel.pnics == null) {
                hostPnicsWithDetailsModel.pnics = new ArrayList<KeyValue>();
            }
            hostPnicsWithDetailsModel.pnics.add(new KeyValue(pnic.key, pnic.device));
            hostPnicsWithDetailsModel.pnicDetails.put(pnic.key, PnicParser.getHostPnicDetailsItem(pnic, pnicSwitchData));
        }
        return hostPnicsWithDetailsModel;
    }

    public static String getNetworkHint(String pnicDevice, Boolean ipV6Enabled, PhysicalNic.NetworkHint[] networkHints) {
        String networkHint = NetworkStringUtil.getString("pnicData.noNetworks");
        if (pnicDevice != null && networkHints != null) {
            List<String> allNetworkHints = PnicParser.getIpNetworkHints(ipV6Enabled, networkHints, pnicDevice);
            allNetworkHints.addAll(PnicParser.getNamedNetworkHints(networkHints, pnicDevice));
            String hintText = StringUtils.join((Object[])allNetworkHints.toArray(new String[allNetworkHints.size()]), (String)",\n");
            if (!StringUtil.isNullOrEmpty((String)hintText)) {
                networkHint = hintText;
            }
        }
        return networkHint;
    }

    public static String getVirtualSwitchName(PhysicalNic pnic, NetworkInfo networkInfo) {
        if (pnic == null || networkInfo == null) {
            return null;
        }
        return PnicParser.getVirtualSwitchName(pnic, networkInfo.vswitch, networkInfo.proxySwitch, networkInfo.opaqueSwitch);
    }

    private static String[] getNetworkHints(String pnicDevice, Boolean ipV6Enabled, PhysicalNic.NetworkHint[] networkHints) {
        if (pnicDevice != null && networkHints != null) {
            List<String> allNetworkHints = PnicParser.getIpNetworkHints(ipV6Enabled, networkHints, pnicDevice);
            allNetworkHints.addAll(PnicParser.getNamedNetworkHints(networkHints, pnicDevice));
            return allNetworkHints.toArray(new String[allNetworkHints.size()]);
        }
        return new String[0];
    }

    private static PciDevice getPciDevice(PhysicalNic pnic, PciDevice[] pciDevices) {
        PciDevice pciDevice = null;
        if (pciDevices != null) {
            for (PciDevice pci : pciDevices) {
                if (!pnic.getPci().equals(pci.getId())) continue;
                pciDevice = pci;
            }
        }
        return pciDevice;
    }

    private static String[] getResourcePoolSchedulerDisallowedReasons(PhysicalNic pnic) {
        if (pnic.resourcePoolSchedulerDisallowedReason == null) {
            return new String[0];
        }
        ArrayList<String> localizedReasons = new ArrayList<String>();
        for (String reason : pnic.resourcePoolSchedulerDisallowedReason) {
            if (PhysicalNic.ResourcePoolSchedulerDisallowedReason.hardwareUnsupported.name().equals(reason)) {
                localizedReasons.add(NetworkStringUtil.getString("PnicView.resAllocDisallowReason.hardwareUnsupported"));
                continue;
            }
            if (PhysicalNic.ResourcePoolSchedulerDisallowedReason.userOptOut.name().equals(reason)) {
                localizedReasons.add(NetworkStringUtil.getString("PnicView.resAllocDisallowReason.usrOptOut"));
                continue;
            }
            _logger.warn((Object)("Unknown resource pool scheduler disallowed reason: " + reason));
        }
        return localizedReasons.toArray(new String[localizedReasons.size()]);
    }

    private static CdpInfoItem getCdpInfoItem(PhysicalNic.NetworkHint networkHint) {
        if (networkHint == null || networkHint.connectedSwitchPort == null) {
            return null;
        }
        PhysicalNic.CdpInfo cdpInfo = networkHint.connectedSwitchPort;
        CdpInfoItem cdpInfoItem = new CdpInfoItem();
        cdpInfoItem.version = PnicParser.formatValue(cdpInfo.cdpVersion);
        cdpInfoItem.timeout = PnicParser.formatValue(cdpInfo.timeout);
        cdpInfoItem.ttl = PnicParser.formatValue(cdpInfo.ttl);
        cdpInfoItem.samples = PnicParser.formatValue(cdpInfo.samples);
        cdpInfoItem.devId = PnicParser.formatValue(cdpInfo.devId);
        cdpInfoItem.address = PnicParser.formatValue(cdpInfo.address);
        cdpInfoItem.portId = PnicParser.formatValue(cdpInfo.portId);
        cdpInfoItem.softwareVersion = PnicParser.formatValue(cdpInfo.softwareVersion);
        cdpInfoItem.hardwarePlatform = PnicParser.formatValue(cdpInfo.hardwarePlatform);
        cdpInfoItem.ipPrefix = PnicParser.formatValue(cdpInfo.ipPrefix);
        cdpInfoItem.ipPrefixLen = PnicParser.formatValue(cdpInfo.ipPrefixLen);
        cdpInfoItem.vlan = PnicParser.formatValue(cdpInfo.vlan);
        cdpInfoItem.fullDuplex = PnicParser.formatValue(cdpInfo.fullDuplex);
        cdpInfoItem.mtu = PnicParser.formatValue(cdpInfo.mtu);
        cdpInfoItem.systemName = PnicParser.formatValue(cdpInfo.systemName);
        cdpInfoItem.systemOID = PnicParser.formatValue(cdpInfo.systemOID);
        cdpInfoItem.mgmtAddr = PnicParser.formatValue(cdpInfo.mgmtAddr);
        cdpInfoItem.location = PnicParser.formatValue(cdpInfo.location);
        cdpInfoItem.deviceCapabilities = PnicParser.getDeviceCapability(cdpInfo.deviceCapability);
        return cdpInfoItem;
    }

    private static LldpInfoItem getLldpInfoItem(PhysicalNic.NetworkHint networkHint) {
        if (networkHint == null || networkHint.lldpInfo == null) {
            return null;
        }
        PhysicalNic.LldpInfo lldpInfo = networkHint.lldpInfo;
        LldpInfoItem lldpInfoItem = new LldpInfoItem();
        lldpInfoItem.chassisId = PnicParser.formatValue(lldpInfo.chassisId);
        lldpInfoItem.portId = PnicParser.formatValue(lldpInfo.portId);
        lldpInfoItem.ttl = PnicParser.formatValue(lldpInfo.timeToLive);
        if (!ArrayUtil.isNullOrEmpty((Object[])lldpInfo.parameter)) {
            lldpInfoItem.parameter = new ArrayList<KeyAnyValue>();
            for (KeyAnyValue param : lldpInfo.parameter) {
                if (param == null || param.getValue() instanceof PhysicalNic.CdpDeviceCapability) continue;
                lldpInfoItem.parameter.add(param);
            }
        }
        PhysicalNic.CdpDeviceCapability deviceCapability = PnicParser.getCdpDeviceCapability(lldpInfo.parameter);
        lldpInfoItem.deviceCapabilities = PnicParser.getDeviceCapability(deviceCapability);
        return lldpInfoItem;
    }

    private static DeviceCapabilitiesItem getDeviceCapability(PhysicalNic.CdpDeviceCapability deviceCapability) {
        DeviceCapabilitiesItem deviceCapabilitiesItem = new DeviceCapabilitiesItem();
        if (deviceCapability != null) {
            deviceCapabilitiesItem.router = PnicParser.formatValue(deviceCapability.router);
            deviceCapabilitiesItem.transparentBridge = PnicParser.formatValue(deviceCapability.transparentBridge);
            deviceCapabilitiesItem.sourceRouteBridge = PnicParser.formatValue(deviceCapability.sourceRouteBridge);
            deviceCapabilitiesItem.networkSwitch = PnicParser.formatValue(deviceCapability.networkSwitch);
            deviceCapabilitiesItem.host = PnicParser.formatValue(deviceCapability.host);
            deviceCapabilitiesItem.igmpEnabled = PnicParser.formatValue(deviceCapability.igmpEnabled);
            deviceCapabilitiesItem.repeater = PnicParser.formatValue(deviceCapability.repeater);
        }
        return deviceCapabilitiesItem;
    }

    private static PhysicalNic.CdpDeviceCapability getCdpDeviceCapability(KeyAnyValue[] keyAnyValues) {
        if (ArrayUtil.isNullOrEmpty((Object[])keyAnyValues)) {
            return null;
        }
        for (KeyAnyValue param : keyAnyValues) {
            if (param == null || param.getValue() == null || !(param.getValue() instanceof PhysicalNic.CdpDeviceCapability)) continue;
            return (PhysicalNic.CdpDeviceCapability)param.getValue();
        }
        return null;
    }

    private static PhysicalNic.NetworkHint getNetworkHint(String pnicDevice, PhysicalNic.NetworkHint[] networkHints) {
        if (!ArrayUtil.isNullOrEmpty((Object[])networkHints) && pnicDevice != null) {
            for (PhysicalNic.NetworkHint hint : networkHints) {
                if (!pnicDevice.equals(hint.device)) continue;
                return hint;
            }
        }
        return null;
    }

    private static List<String> getNamedNetworkHints(PhysicalNic.NetworkHint[] networkHints, String pnicDevice) {
        ArrayList<String> namedHints = new ArrayList<String>();
        if (networkHints != null && pnicDevice != null) {
            for (PhysicalNic.NetworkHint nHint : networkHints) {
                if (!StringUtils.equals((String)pnicDevice, (String)nHint.device) || ArrayUtil.isNullOrEmpty((Object[])nHint.network)) continue;
                for (PhysicalNic.NetworkHint.NamedNetwork nNetwork : nHint.network) {
                    namedHints.add(nNetwork.network);
                }
            }
        }
        return namedHints;
    }

    private static List<String> getIpNetworkHints(Boolean isIpv6Enabled, PhysicalNic.NetworkHint[] networkHints, String pnicDevice) {
        ArrayList<String> ipHints = new ArrayList<String>();
        ArrayList<String> ipv6Hints = new ArrayList<String>();
        if (networkHints != null && !StringUtil.isNullOrEmpty((String)pnicDevice)) {
            for (PhysicalNic.NetworkHint nHint : networkHints) {
                if (StringUtils.equals((String)pnicDevice, (String)nHint.device) && !ArrayUtil.isNullOrEmpty((Object[])nHint.subnet)) {
                    for (PhysicalNic.NetworkHint.IpNetwork ipNetwork : nHint.subnet) {
                        if (ipNetwork.ipSubnet == null) continue;
                        String ipNetworkHint = ipNetwork.vlanId != 0 && ipNetwork.vlanId != 4095 ? NetworkStringUtil.getString("pnicData.vlan", ipNetwork.ipSubnet, ipNetwork.vlanId.toString()) : ipNetwork.ipSubnet;
                        if (ipNetwork.ipSubnet.contains(".")) {
                            ipHints.add(ipNetworkHint);
                            continue;
                        }
                        if (isIpv6Enabled == null || !isIpv6Enabled.booleanValue() || !ipNetwork.ipSubnet.contains(":")) continue;
                        ipv6Hints.add(ipNetworkHint);
                    }
                }
                ipHints.addAll(ipv6Hints);
            }
        }
        return ipHints;
    }

    private static String getVirtualSwitchName(PhysicalNic pnic, VirtualSwitch[] vSwitches, HostProxySwitch[] proxySwitches, OpaqueSwitch[] opaqueSwitches) {
        if (vSwitches != null) {
            for (VirtualSwitch virtualSwitch : vSwitches) {
                if (virtualSwitch.pnic == null) continue;
                for (String pnicKey : virtualSwitch.pnic) {
                    if (!StringUtils.equals((String)pnicKey, (String)pnic.key)) continue;
                    return virtualSwitch.name;
                }
            }
        }
        if (proxySwitches != null) {
            for (VirtualSwitch virtualSwitch : proxySwitches) {
                if (virtualSwitch.pnic == null) continue;
                for (String pnicKey : virtualSwitch.pnic) {
                    if (!StringUtils.equals((String)pnicKey, (String)pnic.key)) continue;
                    return virtualSwitch.dvsName;
                }
            }
        }
        if (opaqueSwitches != null) {
            for (VirtualSwitch virtualSwitch : opaqueSwitches) {
                if (virtualSwitch.pnic == null) continue;
                for (String pnicKey : virtualSwitch.pnic) {
                    if (!StringUtils.equals((String)pnicKey, (String)pnic.key)) continue;
                    if (!StringUtil.isNullOrEmpty((String)virtualSwitch.name)) {
                        return virtualSwitch.name;
                    }
                    if (virtualSwitch.key == null) continue;
                    return virtualSwitch.key.replace("key-vim.host.OpaqueSwitch-", "");
                }
            }
        }
        return null;
    }

    private static HostPnicDetailsItem getHostPnicDetailsItem(PhysicalNic pnic, HostPnicSwitchData pnicSwitchData) {
        return PnicParser.createHostPnicDetailsItem(pnic, pnicSwitchData);
    }

    private static <T> String formatValue(T value) {
        if (value instanceof Boolean) {
            return PnicParser.formatBooleanValue((Boolean)value);
        }
        return value == null ? "" : value.toString();
    }

    private static String formatBooleanValue(Boolean value) {
        if (value == null) {
            return "";
        }
        if (value.booleanValue()) {
            return NetworkStringUtil.getString("enabled");
        }
        return NetworkStringUtil.getString("disabled");
    }
}

