/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.portgroup;

import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.host.portgroup.model.EditPortgroupDialogData;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostStandardPortgroupInfo;
import com.vmware.vsphere.client.h5.network.util.VlanUtil;
import java.util.HashSet;
import org.apache.commons.lang.Validate;

public class HostPortgroupPropertyProvider
implements PropertyProviderBean {
    private static final String HOST_PORT_GROUPS = "config.network.portgroup";
    private final QueryExecutor _queryExecutor;

    public HostPortgroupPropertyProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="portgroup", property="portgroupDialogData")
    public EditPortgroupDialogData getPortgroupDialogData(ManagedObjectReference hostRef, String portgroupKey) throws Exception {
        if (StringUtil.isNullOrEmpty((String)portgroupKey)) {
            throw new IllegalArgumentException("Invalid key value: " + portgroupKey);
        }
        EditPortgroupDialogData result = null;
        PortGroup[] portgroups = (PortGroup[])this._queryExecutor.getProperty((Object)hostRef, HOST_PORT_GROUPS);
        if (portgroups != null) {
            for (PortGroup portgroup : portgroups) {
                if (!portgroupKey.equals(portgroup.key)) continue;
                result = this.createEditPortgroupDialogData(portgroup);
                result.properties.hostVlanIds = VlanUtil.getAvailableVlanIds(portgroups);
                break;
            }
        }
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="portgroup", property="hostStandardPortgroupInfo")
    public HostStandardPortgroupInfo getHostStandardPortgroupInfo(ManagedObjectReference hostRef, String uniqueNamePrefix) throws Exception {
        HostStandardPortgroupInfo hostStandardPortgroupInfo = new HostStandardPortgroupInfo();
        PortGroup[] portGroups = (PortGroup[])this._queryExecutor.getProperty((Object)hostRef, HOST_PORT_GROUPS);
        hostStandardPortgroupInfo.uniquePortGroupName = this.getUniqueName(portGroups, uniqueNamePrefix);
        hostStandardPortgroupInfo.vlanIds = VlanUtil.getAvailableVlanIds(portGroups);
        return hostStandardPortgroupInfo;
    }

    private String getUniqueName(PortGroup[] portGroups, String uniqueNamePrefix) {
        if (portGroups == null) {
            return uniqueNamePrefix;
        }
        HashSet<String> portGroupNames = new HashSet<String>();
        for (PortGroup portGroup : portGroups) {
            portGroupNames.add(portGroup.spec.name);
        }
        int i = 2;
        String uniqueName = uniqueNamePrefix;
        while (portGroupNames.contains(uniqueName)) {
            uniqueName = uniqueNamePrefix + " " + i;
            ++i;
        }
        return uniqueName;
    }

    private EditPortgroupDialogData createEditPortgroupDialogData(PortGroup portgroup) {
        Validate.notNull((Object)portgroup);
        Validate.notNull((Object)portgroup.spec);
        Validate.notNull((Object)portgroup.spec.policy);
        Validate.notNull((Object)portgroup.computedPolicy);
        EditPortgroupDialogData result = new EditPortgroupDialogData();
        if (portgroup.spec != null) {
            result.properties = new EditPortgroupDialogData.Properties();
            result.properties.portgroupName = portgroup.spec.name;
            result.properties.oldPortgroupName = portgroup.spec.name;
            result.properties.vswitchName = portgroup.spec.vswitchName;
            result.properties.portgroupVlanId = portgroup.spec.vlanId;
            result.securityPolicies = new EditPortgroupDialogData.SecurityPolicies();
            boolean isSecurityPolicyDefined = portgroup.spec.policy != null && portgroup.spec.policy.security != null;
            boolean isComputedSecurityPolicyDefined = portgroup.computedPolicy != null && portgroup.computedPolicy.security != null;
            result.securityPolicies.isPromiscuousModeOverriden = isSecurityPolicyDefined && portgroup.spec.policy.security.allowPromiscuous != null;
            result.securityPolicies.allowPromiscuousMode = result.securityPolicies.isPromiscuousModeOverriden ? portgroup.spec.policy.security.allowPromiscuous : isComputedSecurityPolicyDefined && portgroup.computedPolicy.security.allowPromiscuous != false;
            result.securityPolicies.isForgedTransmitsOverriden = isSecurityPolicyDefined && portgroup.spec.policy.security.forgedTransmits != null;
            result.securityPolicies.forgedTransmits = result.securityPolicies.isForgedTransmitsOverriden ? portgroup.spec.policy.security.forgedTransmits : isComputedSecurityPolicyDefined && portgroup.computedPolicy.security.forgedTransmits != false;
            result.securityPolicies.isMacChangesOverriden = isSecurityPolicyDefined && portgroup.spec.policy.security.macChanges != null;
            result.securityPolicies.macChanges = result.securityPolicies.isMacChangesOverriden ? portgroup.spec.policy.security.macChanges : isComputedSecurityPolicyDefined && portgroup.computedPolicy.security.macChanges != false;
        }
        return result;
    }
}

