/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.virtualswitch;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.HostSwitchType;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.DvsUuidData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostSwitchIssueType;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostSwitchItem;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostSwitchItemsData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualStandardSwitchData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualSwitchData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualSwitchPortGroupData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.PortGroupItem;
import com.vmware.vsphere.client.h5.network.host.vnic.PortGroupParser;
import com.vmware.vsphere.client.h5.network.model.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.modules.api.network.ProxySwitchSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostVirtualSwitchPropertyProvider
implements PropertyProviderBean {
    private static final String DVS_BY_UUIDS_PROPERTY = "dvsesByUuids";
    private static final String HOST_PORT_GROUPS = "config.network.portgroup";
    private static final Log _logger = LogFactory.getLog(HostVirtualSwitchPropertyProvider.class);
    private QueryBindingService _queryBindingService;
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;

    public HostVirtualSwitchPropertyProvider(QueryBindingService queryBindingService, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryBindingService = queryBindingService;
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="virtualSwitches")
    public HostSwitchItemsData getAllVirtualSwitches(ManagedObjectReference hostMor) {
        HostVirtualSwitchData data = (HostVirtualSwitchData)((Object)this._queryBindingService.prepare(HostVirtualSwitchData.class).fetch((Object)hostMor));
        if (data == null) {
            return HostSwitchItemsData.newEmptyInstance();
        }
        Map<String, ManagedObjectReference> dvsUuidToMor = this.extractDvsRefs(data);
        Map<String, ProxySwitchSpec> uuidToMissingDvsSpecMap = this.getUuidToMissingDvsSpecMap(hostMor, data);
        boolean showNumberOfPortsColumn = data.hostNetworkCapability != null && !data.hostNetworkCapability.proxySwitchAutoScaleSupported;
        ArrayList<HostSwitchItem> hostSwitchItems = new ArrayList<HostSwitchItem>();
        if (data.proxySwitches != null) {
            for (HostProxySwitch proxySwitch : data.proxySwitches) {
                if (proxySwitch == null) continue;
                HostSwitchItem switchItem = new HostSwitchItem();
                switchItem.key = proxySwitch.key;
                switchItem.name = proxySwitch.dvsName;
                switchItem.type = HostSwitchType.DistributedSwitch;
                switchItem.numberOfPorts = proxySwitch.numPorts;
                this.populateIssueData(switchItem, proxySwitch, uuidToMissingDvsSpecMap, data.hostName);
                hostSwitchItems.add(switchItem);
                ManagedObjectReference dvsRef = dvsUuidToMor.get(proxySwitch.dvsUuid);
                if (dvsRef == null || ManagedObjectUtil.isOfType((ManagedObjectReference)dvsRef, VmwareDistributedVirtualSwitch.class)) continue;
                showNumberOfPortsColumn = true;
            }
        }
        if (!showNumberOfPortsColumn) {
            HostVirtualSwitchPropertyProvider.resetNumberOfPorts(hostSwitchItems);
        }
        hostSwitchItems.addAll(this.getHostVirtualStandardSwitchItems(data.standardSwitches, showNumberOfPortsColumn));
        HostSwitchItemsData result = new HostSwitchItemsData();
        result.switchItems = hostSwitchItems.toArray(new HostSwitchItem[hostSwitchItems.size()]);
        result.showNumberOfPortsColumn = showNumberOfPortsColumn;
        return result;
    }

    private static void resetNumberOfPorts(List<HostSwitchItem> switchItems) {
        for (HostSwitchItem item : switchItems) {
            item.numberOfPorts = -1;
        }
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="virtualStandardSwitches")
    public HostSwitchItemsData getVirtualStandardSwitches(ManagedObjectReference hostMor) {
        HostVirtualStandardSwitchData data = (HostVirtualStandardSwitchData)((Object)this._queryBindingService.prepare(HostVirtualStandardSwitchData.class).fetch((Object)hostMor));
        if (data == null) {
            return HostSwitchItemsData.newEmptyInstance();
        }
        boolean showNumberOfPortsColumn = data.hostNetworkCapability != null && !data.hostNetworkCapability.proxySwitchAutoScaleSupported;
        ArrayList<HostSwitchItem> standardSwitchItems = this.getHostVirtualStandardSwitchItems(data.standardSwitches, showNumberOfPortsColumn);
        HostSwitchItemsData result = new HostSwitchItemsData();
        result.switchItems = standardSwitchItems.toArray(new HostSwitchItem[standardSwitchItems.size()]);
        result.showNumberOfPortsColumn = showNumberOfPortsColumn;
        return result;
    }

    private ArrayList<HostSwitchItem> getHostVirtualStandardSwitchItems(VirtualSwitch[] standardSwitches, boolean populateNumberOfPorts) {
        ArrayList<HostSwitchItem> hostSwitchItems = new ArrayList<HostSwitchItem>();
        if (standardSwitches != null) {
            for (VirtualSwitch vswitch : standardSwitches) {
                if (vswitch == null) continue;
                HostSwitchItem switchItem = new HostSwitchItem();
                switchItem.key = vswitch.key;
                switchItem.name = vswitch.name;
                switchItem.type = HostSwitchType.StandardSwitch;
                switchItem.issueType = HostSwitchIssueType.None;
                switchItem.numberOfPorts = populateNumberOfPorts ? vswitch.numPorts : -1;
                switchItem.mtu = vswitch.mtu;
                hostSwitchItems.add(switchItem);
            }
        }
        return hostSwitchItems;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="portGroupPropertyViewData")
    public HostNetworkDetailsData getHostPortGroupPropertyViewData(ManagedObjectReference hostMor, String portGroupKey) throws Exception {
        Validate.notNull((Object)portGroupKey);
        HostVirtualSwitchPortGroupData portGroupsData = (HostVirtualSwitchPortGroupData)this._queryBindingService.prepare(HostVirtualSwitchPortGroupData.class).fetch((Object)hostMor);
        return PortGroupParser.getPortGroupDetails(portGroupsData, portGroupKey);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="portGroups")
    public PortGroupItem[] getPortGroups(ManagedObjectReference hostMor, String vswitch) throws Exception {
        ArrayList<PortGroupItem> portGroupItems = new ArrayList<PortGroupItem>();
        PortGroup[] portGroups = (PortGroup[])this._queryExecutor.getProperty((Object)hostMor, HOST_PORT_GROUPS);
        if (portGroups != null && vswitch != null) {
            for (PortGroup portGroup : portGroups) {
                if (!vswitch.equals(portGroup.vswitch)) continue;
                PortGroupItem portGroupItem = new PortGroupItem();
                portGroupItem.portgroupName = portGroup.spec.name;
                portGroupItem.vlanId = portGroup.spec.vlanId;
                portGroupItem.portgroupKey = portGroup.key;
                if (portGroup.port != null) {
                    portGroupItem.activePorts = portGroup.port.length;
                }
                StringBuffer uplinks = new StringBuffer();
                if (portGroup.computedPolicy.nicTeaming != null && portGroup.computedPolicy.nicTeaming.nicOrder != null) {
                    NetworkPolicy.NicOrderPolicy nicOrder = portGroup.computedPolicy.nicTeaming.nicOrder;
                    if (nicOrder.activeNic != null) {
                        for (String activeNic : nicOrder.activeNic) {
                            if (uplinks.length() > 0) {
                                uplinks.append(", ");
                            }
                            uplinks.append(activeNic);
                        }
                    }
                    if (nicOrder.standbyNic != null) {
                        for (String standbyNic : nicOrder.standbyNic) {
                            if (uplinks.length() > 0) {
                                uplinks.append(", ");
                            }
                            uplinks.append(standbyNic);
                        }
                    }
                }
                portGroupItem.uplinks = uplinks.toString();
                portGroupItems.add(portGroupItem);
            }
        }
        Collections.sort(portGroupItems, new Comparator<PortGroupItem>(){

            @Override
            public int compare(PortGroupItem item1, PortGroupItem item2) {
                if (item1.portgroupName == null && item2.portgroupName == null) {
                    return 0;
                }
                if (item1.portgroupName == null) {
                    return -1;
                }
                if (item2.portgroupName == null) {
                    return 1;
                }
                return item1.portgroupName.compareTo(item2.portgroupName);
            }
        });
        return portGroupItems.toArray(new PortGroupItem[portGroupItems.size()]);
    }

    private Map<String, ProxySwitchSpec> getUuidToMissingDvsSpecMap(ManagedObjectReference hostMor, HostVirtualSwitchData data) {
        String[] missingDvsUuids = this.extractMissingDvsUuids(data);
        ProxySwitchSpec[] missingProxySwitches = this.retrieveMissingProxySwitches(hostMor, missingDvsUuids);
        return this.createUuidToMissingDvsSpecMap(missingProxySwitches);
    }

    private ProxySwitchSpec[] retrieveMissingProxySwitches(ManagedObjectReference hostMor, String[] missingDvsUuids) {
        if (ArrayUtil.isNullOrEmpty((Object[])missingDvsUuids)) {
            return null;
        }
        try {
            return (ProxySwitchSpec[])NetworkUtil.requestPropertyWithParam(this._queryExecutor, this._querySpecBuilder, hostMor, DVS_BY_UUIDS_PROPERTY, missingDvsUuids);
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to load dvsesByUuid property: " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    private String[] extractMissingDvsUuids(HostVirtualSwitchData data) {
        ArrayList<String> missingUuids = new ArrayList<String>();
        HashSet<String> existingUuids = new HashSet<String>();
        if (data.dvsUuidData != null) {
            for (DvsUuidData dvsUuidData : data.dvsUuidData) {
                if (dvsUuidData == null || StringUtil.isNullOrEmpty((String)dvsUuidData.uuid)) continue;
                existingUuids.add(dvsUuidData.uuid);
            }
        }
        if (data.proxySwitches != null) {
            for (DvsUuidData dvsUuidData : data.proxySwitches) {
                if (StringUtil.isNullOrEmpty((String)((HostProxySwitch)dvsUuidData).dvsUuid) || existingUuids.contains(((HostProxySwitch)dvsUuidData).dvsUuid)) continue;
                missingUuids.add(((HostProxySwitch)dvsUuidData).dvsUuid);
            }
        }
        return missingUuids.toArray(new String[missingUuids.size()]);
    }

    private Map<String, ManagedObjectReference> extractDvsRefs(HostVirtualSwitchData data) {
        HashMap<String, ManagedObjectReference> result = new HashMap<String, ManagedObjectReference>();
        if (data.dvsUuidData != null) {
            for (DvsUuidData dvsUuidData : data.dvsUuidData) {
                if (dvsUuidData == null || StringUtil.isNullOrEmpty((String)dvsUuidData.uuid)) continue;
                result.put(dvsUuidData.uuid, (ManagedObjectReference)dvsUuidData.provider);
            }
        }
        return result;
    }

    private void populateIssueData(HostSwitchItem item, HostProxySwitch proxySwitch, Map<String, ProxySwitchSpec> uuidToMissingDvsSpecMap, String hostName) {
        if (uuidToMissingDvsSpecMap == null || proxySwitch == null || proxySwitch.dvsUuid == null) {
            item.issueType = HostSwitchIssueType.None;
            return;
        }
        ProxySwitchSpec missingDvsProxySpec = uuidToMissingDvsSpecMap.get(proxySwitch.dvsUuid);
        if (missingDvsProxySpec != null && missingDvsProxySpec.isGhostProxySwitch) {
            item.issueText = NetworkStringUtil.getString("HostSwitchIssueType.ghostProxySwitchError", hostName);
            item.issueType = HostSwitchIssueType.Alert;
        } else if (this.arePrivilegesMissing(missingDvsProxySpec).booleanValue()) {
            item.issueText = NetworkStringUtil.getString("HostSwitchIssueType.noPrivilegesOnDvsWarning");
            item.issueType = HostSwitchIssueType.Warning;
        } else if (!this.arePnicsAttached(proxySwitch).booleanValue()) {
            item.issueText = NetworkStringUtil.getString("HostSwitchIssueType.noHostPnicsAttachedWarning");
            item.issueType = HostSwitchIssueType.Warning;
        } else {
            item.issueType = HostSwitchIssueType.None;
        }
    }

    private HashMap<String, ProxySwitchSpec> createUuidToMissingDvsSpecMap(ProxySwitchSpec[] proxySwitches) {
        HashMap<String, ProxySwitchSpec> uuidToMissingDvsSpecMap = new HashMap<String, ProxySwitchSpec>();
        if (proxySwitches == null) {
            return uuidToMissingDvsSpecMap;
        }
        for (ProxySwitchSpec missingDvsSpec : proxySwitches) {
            uuidToMissingDvsSpecMap.put(missingDvsSpec.dvsUuid, missingDvsSpec);
        }
        return uuidToMissingDvsSpecMap;
    }

    private Boolean arePnicsAttached(HostProxySwitch proxySwitch) {
        return proxySwitch != null && !ArrayUtil.isNullOrEmpty((Object[])proxySwitch.pnic);
    }

    private Boolean arePrivilegesMissing(ProxySwitchSpec proxySpec) {
        return proxySpec != null && proxySpec.dvsRef == null && !proxySpec.isGhostProxySwitch;
    }
}

