/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic;

import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.modules.api.network.VirtualNicRemoveSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostVnicsMutationProvider
implements MutationProvider {
    private static final String HOST_CONFIG_NETWORK_PROPERTY = "config.network";
    private static final Log _logger = LogFactory.getLog(HostVnicsMutationProvider.class);
    private final QueryExecutor _queryExecutor;

    public HostVnicsMutationProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    public ValidationResult validate(ManagedObjectReference objRef, VirtualNicRemoveSpec spec) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = objRef;
        NetworkInfo networkInfo = (NetworkInfo)this._queryExecutor.getProperty((Object)objRef, HOST_CONFIG_NETWORK_PROPERTY);
        if (networkInfo == null) {
            validationResult.result = NetworkStringUtil.getString("removeVirtualNic.genericError");
            _logger.warn((Object)("Unable to retrieve the network config info of the host: " + objRef));
            return validationResult;
        }
        if (NetworkUtil.isLastManagementVmnic(networkInfo, spec.virtualNicName)) {
            validationResult.result = NetworkStringUtil.getString("removeVirtualNic.managementVmkernelError");
        }
        return validationResult;
    }
}

