/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.host.vnic.VnicParser;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostNetworkData;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicFeatures;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicItem;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicsResult;
import com.vmware.vsphere.client.h5.network.model.HostNetworkDetailsData;
import java.util.List;

public class HostVnicsPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;

    public HostVnicsPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="virtualAdaptersData")
    public HostVnicsResult getVirtualAdaptersData(ManagedObjectReference hostRef) {
        HostVnicsResult vnicsResult = new HostVnicsResult();
        HostNetworkData hostNetworkData = this.fetchHostNetworkInfo(hostRef);
        if (hostNetworkData != null) {
            List<HostVnicItem> vnics = VnicParser.parse(hostNetworkData);
            vnicsResult.items = vnics.toArray(new HostVnicItem[vnics.size()]);
            vnicsResult.hostFeatures = hostNetworkData.hostVnicSupportedFeatures;
        } else {
            vnicsResult.items = new HostVnicItem[0];
            vnicsResult.hostFeatures = new HostVnicFeatures();
        }
        return vnicsResult;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="virtualAdapterDetailsData")
    public HostNetworkDetailsData getVirtualAdapterDetailsData(ManagedObjectReference hostRef, String device) {
        HostNetworkData hostNetworkData = this.fetchHostNetworkInfo(hostRef);
        if (hostNetworkData == null || hostNetworkData.networkInfo == null) {
            return null;
        }
        VirtualNic virtualNic = HostVnicsPropertyProvider.getVirtualNicByDevice(hostNetworkData.networkInfo.vnic, device);
        return VnicParser.parseVnicDetails(hostNetworkData, virtualNic);
    }

    private static VirtualNic getVirtualNicByDevice(VirtualNic[] virtualNics, String device) {
        if (device == null || virtualNics == null) {
            return null;
        }
        for (VirtualNic vnic : virtualNics) {
            if (!device.equals(vnic.device)) continue;
            return vnic;
        }
        return null;
    }

    private HostNetworkData fetchHostNetworkInfo(ManagedObjectReference hostRef) {
        return (HostNetworkData)((Object)this._queryBindingService.prepare(HostNetworkData.class).fetch((Object)hostRef));
    }
}

