/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic;

import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualSwitchPortGroupData;
import com.vmware.vsphere.client.h5.network.model.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;

public class PortGroupParser {
    public static HostNetworkDetailsData getPortGroupDetails(HostVirtualSwitchPortGroupData portGroupsData, String portGroupKey) {
        HostNetworkDetailsData portGroupData = new HostNetworkDetailsData();
        PortGroup portGroup = PortGroupParser.getPortGroupByKey(portGroupKey, portGroupsData.portGroups);
        if (portGroup == null) {
            throw new IllegalStateException(NetworkStringUtil.getString("PortGroupParser.missingPortGroupMessage", portGroupKey));
        }
        portGroupData.networkLabel = portGroup.spec.name;
        portGroupData.vlanId = portGroup.spec.vlanId;
        portGroupData.showVlanId = true;
        portGroupData.portPolicy = PortGroupParser.getPortPolicy(portGroup, portGroupsData.standardSwitches, portGroupsData.pnics);
        return portGroupData;
    }

    public static PortGroup getPortGroupByName(PortGroup[] portGroups, String portGroupName) {
        if (portGroups != null) {
            for (PortGroup portGroup : portGroups) {
                if (!portGroup.spec.name.equals(portGroupName)) continue;
                return portGroup;
            }
        }
        return null;
    }

    public static HostNetworkDetailsData.PortPolicy getPortPolicy(PortGroup portGroup, NetworkInfo networkInfo) {
        if (portGroup == null || networkInfo == null) {
            return null;
        }
        return PortGroupParser.getPortPolicy(portGroup, networkInfo.vswitch, networkInfo.pnic);
    }

    private static PortGroup getPortGroupByKey(String portGroupKey, PortGroup[] portGroups) {
        if (!ArrayUtil.isNullOrEmpty((Object[])portGroups) && portGroupKey != null) {
            for (PortGroup portGroup : portGroups) {
                if (portGroup == null || !portGroupKey.equals(portGroup.key)) continue;
                return portGroup;
            }
        }
        return null;
    }

    private static HostNetworkDetailsData.PortPolicy getPortPolicy(PortGroup portGroup, VirtualSwitch[] vSwitches, PhysicalNic[] pnics) {
        HostNetworkDetailsData.PortPolicy portPolicy = new HostNetworkDetailsData.PortPolicy();
        PortGroupParser.setSecurityPolicy(portGroup, portPolicy);
        PortGroupParser.setTrafficShapingPolicy(portGroup, portPolicy);
        PortGroupParser.setNicTeamingAndFailoverPolicy(portGroup, vSwitches, pnics, portPolicy);
        return portPolicy;
    }

    private static void setSecurityPolicy(PortGroup vnicPortGroup, HostNetworkDetailsData.PortPolicy portPolicy) {
        NetworkPolicy.SecurityPolicy security = vnicPortGroup.spec.policy.security;
        HostNetworkDetailsData.PortPolicy.Security securityPolicy = new HostNetworkDetailsData.PortPolicy.Security();
        if (security != null) {
            securityPolicy.allowPromiscuous = BooleanUtils.toBoolean((Boolean)security.allowPromiscuous);
            securityPolicy.forgedTransmits = BooleanUtils.toBoolean((Boolean)security.forgedTransmits);
            securityPolicy.macChanges = BooleanUtils.toBoolean((Boolean)security.macChanges);
        }
        if (vnicPortGroup.computedPolicy != null && vnicPortGroup.computedPolicy.security != null) {
            NetworkPolicy.SecurityPolicy computedSecurityPolicy = vnicPortGroup.computedPolicy.security;
            securityPolicy.allowPromiscuous = securityPolicy.allowPromiscuous || BooleanUtils.toBoolean((Boolean)computedSecurityPolicy.allowPromiscuous);
            securityPolicy.forgedTransmits = securityPolicy.forgedTransmits || BooleanUtils.toBoolean((Boolean)computedSecurityPolicy.forgedTransmits);
            securityPolicy.macChanges = securityPolicy.macChanges || BooleanUtils.toBoolean((Boolean)computedSecurityPolicy.macChanges);
        }
        portPolicy.security = securityPolicy;
    }

    private static void setTrafficShapingPolicy(PortGroup vnicPortGroup, HostNetworkDetailsData.PortPolicy portPolicy) {
        NetworkPolicy.TrafficShapingPolicy shapingPolicy = null;
        if (!PortGroupParser.isTrafficShapingPolicyNullOrEmpty(vnicPortGroup.spec.policy.shapingPolicy)) {
            shapingPolicy = vnicPortGroup.spec.policy.shapingPolicy;
        } else if (vnicPortGroup.computedPolicy != null && !PortGroupParser.isTrafficShapingPolicyNullOrEmpty(vnicPortGroup.computedPolicy.shapingPolicy)) {
            shapingPolicy = vnicPortGroup.computedPolicy.shapingPolicy;
        }
        HostNetworkDetailsData.PortPolicy.TrafficShaping trafficShaping = new HostNetworkDetailsData.PortPolicy.TrafficShaping();
        if (shapingPolicy != null && shapingPolicy.enabled.booleanValue()) {
            trafficShaping.averageBandwidthSummary = FormatUtil.getBitRateFormatted((Number)PortGroupParser.getLongValue(shapingPolicy.averageBandwidth, 100000L * FormatUtil.KBPS), (int)0, (long)FormatUtil.BPS, (long)FormatUtil.KBPS, (boolean)true);
            trafficShaping.burstSizeSummary = FormatUtil.getDataSizeFormatted((Number)PortGroupParser.getLongValue(shapingPolicy.burstSize, 100000L * FormatUtil.KBPS), (int)0, (long)1L, (long)1024L, (boolean)true);
            trafficShaping.peakBandwidthSummary = FormatUtil.getBitRateFormatted((Number)PortGroupParser.getLongValue(shapingPolicy.peakBandwidth, 100000L * FormatUtil.KBPS), (int)0, (long)FormatUtil.BPS, (long)FormatUtil.KBPS, (boolean)true);
        }
        portPolicy.trafficShaping = trafficShaping;
    }

    private static void setNicTeamingAndFailoverPolicy(PortGroup vnicPortGroup, VirtualSwitch[] vSwitches, PhysicalNic[] pnics, HostNetworkDetailsData.PortPolicy portPolicy) {
        boolean computedPolicyAvailable;
        HostNetworkDetailsData.PortPolicy.TeamingAndFailover teamingAndFailover = new HostNetworkDetailsData.PortPolicy.TeamingAndFailover();
        NetworkPolicy.NicTeamingPolicy nicTeaming = vnicPortGroup.spec.policy.nicTeaming;
        NetworkPolicy.NicTeamingPolicy computedNicTeaming = null;
        boolean policyAvailable = vnicPortGroup.spec.policy.nicTeaming != null;
        boolean bl = computedPolicyAvailable = vnicPortGroup.computedPolicy != null && vnicPortGroup.computedPolicy.nicTeaming != null;
        if (computedPolicyAvailable) {
            computedNicTeaming = vnicPortGroup.computedPolicy.nicTeaming;
        }
        if (policyAvailable && nicTeaming.policy != null) {
            teamingAndFailover.loadBalancing = nicTeaming.policy;
        } else if (computedPolicyAvailable && computedNicTeaming.policy != null) {
            teamingAndFailover.loadBalancing = computedNicTeaming.policy;
        }
        if (policyAvailable && nicTeaming.failureCriteria != null && nicTeaming.failureCriteria.checkBeacon != null) {
            teamingAndFailover.failureDetection = nicTeaming.failureCriteria.checkBeacon;
        } else if (computedPolicyAvailable && computedNicTeaming.failureCriteria != null && computedNicTeaming.failureCriteria.checkBeacon != null) {
            teamingAndFailover.failureDetection = computedNicTeaming.failureCriteria.checkBeacon;
        }
        if (policyAvailable && nicTeaming.notifySwitches != null) {
            teamingAndFailover.notifySwitches = nicTeaming.notifySwitches;
        } else if (computedPolicyAvailable && computedNicTeaming.notifySwitches != null) {
            teamingAndFailover.notifySwitches = computedNicTeaming.notifySwitches;
        }
        if (policyAvailable && vnicPortGroup.spec.policy.nicTeaming.rollingOrder != null) {
            teamingAndFailover.failback = vnicPortGroup.spec.policy.nicTeaming.rollingOrder == false;
        } else if (computedPolicyAvailable && computedNicTeaming.rollingOrder != null) {
            teamingAndFailover.failback = computedNicTeaming.rollingOrder == false;
        }
        NetworkPolicy.NicOrderPolicy nicOrder = null;
        if (policyAvailable && nicTeaming.nicOrder != null) {
            nicOrder = nicTeaming.nicOrder;
        } else if (computedPolicyAvailable && computedNicTeaming.nicOrder != null) {
            nicOrder = computedNicTeaming.nicOrder;
        }
        if (nicOrder != null) {
            if (nicOrder.activeNic != null) {
                teamingAndFailover.activeAdapters.addAll(Arrays.asList(nicOrder.activeNic));
            }
            if (nicOrder.standbyNic != null) {
                teamingAndFailover.standByAdapters.addAll(Arrays.asList(nicOrder.standbyNic));
            }
        }
        VirtualSwitch vSwitch = NetworkUtil.getVswitchByName(vnicPortGroup.spec.vswitchName, vSwitches);
        List<PhysicalNic> physycalAdapters = NetworkUtil.getSwitchPnics(vSwitch, pnics);
        for (PhysicalNic pnic : physycalAdapters) {
            if (teamingAndFailover.activeAdapters.contains(pnic.device) || teamingAndFailover.standByAdapters.contains(pnic.device)) continue;
            teamingAndFailover.unusedAdapters.add(pnic.device);
        }
        portPolicy.teamingAndFailover = teamingAndFailover;
    }

    private static boolean isTrafficShapingPolicyNullOrEmpty(NetworkPolicy.TrafficShapingPolicy shapingPolicy) {
        return shapingPolicy == null || shapingPolicy.averageBandwidth == null && shapingPolicy.peakBandwidth == null && shapingPolicy.burstSize == null && shapingPolicy.enabled == null;
    }

    private static long getLongValue(Long longValue, long defaultValue) {
        return longValue != null ? longValue : defaultValue;
    }
}

