/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic;

import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.IpConfig;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.OpaqueNetworkInfo;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vim.host.VirtualNicManagerInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.dvPortgroup.DvPortgroupParser;
import com.vmware.vsphere.client.h5.network.dvPortgroup.model.DvPortgroupData;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import com.vmware.vsphere.client.h5.network.host.vnic.PortGroupParser;
import com.vmware.vsphere.client.h5.network.host.vnic.VnicConnectionType;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostNetworkData;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicItem;
import com.vmware.vsphere.client.h5.network.model.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.util.IpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

public class VnicParser {
    private static final String OPAQUE_NETWORK_KEY_SEPARATOR = "-";

    public static List<HostVnicItem> parse(HostNetworkData hostNetworkData) {
        ArrayList<HostVnicItem> vnics = new ArrayList<HostVnicItem>();
        Map<String, String> opaqueNetworkToOpaqueSwitchNameMap = VnicParser.getOpaqueNetworkToOpaqueSwitchNameMap(hostNetworkData.networkInfo);
        if (hostNetworkData.networkInfo != null && hostNetworkData.networkInfo.vnic != null) {
            for (VirtualNic rawVnic : hostNetworkData.networkInfo.vnic) {
                HostVnicItem vnic = VnicParser.buildVnic(rawVnic, hostNetworkData, opaqueNetworkToOpaqueSwitchNameMap);
                vnics.add(vnic);
            }
        }
        return vnics;
    }

    public static HostNetworkDetailsData parseVnicDetails(HostNetworkData hostNetworkData, VirtualNic virtualNic) {
        if (virtualNic == null || hostNetworkData == null) {
            return null;
        }
        HostNetworkDetailsData result = new HostNetworkDetailsData();
        result.device = virtualNic.device;
        if (!(virtualNic.spec.distributedVirtualPort != null && virtualNic.spec.distributedVirtualPort.portgroupKey != null || VnicParser.isConnectedToOpaqueNetwork(virtualNic, hostNetworkData))) {
            PortGroup vnicPortGroup = PortGroupParser.getPortGroupByName(hostNetworkData.networkInfo.portgroup, virtualNic.portgroup);
            result.portPolicy = PortGroupParser.getPortPolicy(vnicPortGroup, hostNetworkData.networkInfo);
            result.showVlanId = true;
            result.vlanId = vnicPortGroup != null ? vnicPortGroup.spec.vlanId : 0;
        } else if (virtualNic.spec.distributedVirtualPort != null && virtualNic.spec.distributedVirtualPort.portgroupKey != null) {
            DvPortgroupData dvPortgroupData = DvPortgroupParser.getDistributedPortGroupData(virtualNic.spec.distributedVirtualPort.portgroupKey, virtualNic.spec.distributedVirtualPort.switchUuid, hostNetworkData.dvPortgroupData);
            result.portPolicy = DvPortgroupParser.getPortPolicy(dvPortgroupData);
            result.showVlanId = false;
            result.dvPortgroup = true;
        }
        if (hostNetworkData.hostVnicSupportedFeatures != null && hostNetworkData.hostVnicSupportedFeatures.isTcpIpStackSupported) {
            result.showNetworkStack = true;
            result.networkStack = VnicParser.extractNetworkStackName(virtualNic, hostNetworkData);
        } else {
            result.showNetworkStack = false;
        }
        result.networkLabel = VnicParser.extractNetworkLabel(virtualNic, hostNetworkData);
        result.enabledServices = new HostNetworkDetailsData.EnabledServices();
        result.enabledServices.isManagementTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.management, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isVmotionEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vmotion, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isFtEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.faultToleranceLogging, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isVsanEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vsan, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isProvisioningNfcTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vSphereProvisioning, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isVrTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vSphereReplication, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isVrNfcTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vSphereReplicationNFC, hostNetworkData.vnicManagerInfo);
        result.mac = virtualNic.spec.mac;
        result.mtu = virtualNic.spec.mtu != null ? virtualNic.spec.mtu : 0;
        result.ipProperties = VnicParser.getIpProperties(virtualNic, hostNetworkData);
        return result;
    }

    private static HostNetworkDetailsData.IpProperties getIpProperties(VirtualNic vnic, HostNetworkData hostNetworkData) {
        HostNetworkDetailsData.IpProperties ipProperties = new HostNetworkDetailsData.IpProperties();
        ipProperties.hasIpv4Settings = IpUtil.hasAnyIpv4Settings(vnic.spec.ip);
        boolean bl = ipProperties.ipv4DhcpEnabled = !ipProperties.hasIpv4Settings || vnic.spec.ip.dhcp;
        if (vnic.spec.ip != null) {
            ipProperties.ipv4Address = vnic.spec.ip.ipAddress;
            ipProperties.subnetMask = vnic.spec.ip.subnetMask;
        }
        if (hostNetworkData.hostVnicSupportedFeatures != null && hostNetworkData.hostVnicSupportedFeatures.isTcpIpStackSupported) {
            NetStackInstance netStackInstance = NetStackUtil.getNetStackInstanceByKey(vnic.spec.netStackInstanceKey, hostNetworkData.netStackInstance);
            if (netStackInstance != null) {
                ipProperties.initDefaultGateways(netStackInstance.ipRouteConfig);
                if (netStackInstance.dnsConfig != null) {
                    ipProperties.dnsServers = netStackInstance.dnsConfig.address;
                }
            }
        } else if (hostNetworkData.networkInfo != null) {
            ipProperties.initDefaultGateways(hostNetworkData.networkInfo.ipRouteConfig);
            if (hostNetworkData.networkInfo.dnsConfig != null) {
                ipProperties.dnsServers = hostNetworkData.networkInfo.dnsConfig.address;
            }
        }
        boolean bl2 = ipProperties.hasIpv6Settings = BooleanUtils.toBoolean((Boolean)hostNetworkData.networkInfo.ipV6Enabled) && IpUtil.hasAnyIpv6Addresses(vnic.spec.ip);
        if (ipProperties.hasIpv6Settings && vnic.spec.ip != null && vnic.spec.ip.ipV6Config != null) {
            ipProperties.ipv6DhcpEnabled = BooleanUtils.toBoolean((Boolean)vnic.spec.ip.ipV6Config.dhcpV6Enabled);
            ipProperties.ipv6AutoConfigEnabled = BooleanUtils.toBoolean((Boolean)vnic.spec.ip.ipV6Config.autoConfigurationEnabled);
            ipProperties.formattedIpv6Addresses = IpUtil.formatIpv6Addresses(vnic.spec.ip.ipV6Config.ipV6Address);
        }
        return ipProperties;
    }

    private static boolean isConnectedToOpaqueNetwork(VirtualNic virtualNic, HostNetworkData hostNetworkData) {
        if (virtualNic.spec.opaqueNetwork == null || hostNetworkData.networkInfo == null || hostNetworkData.networkInfo.opaqueNetwork == null) {
            return false;
        }
        String opaqueNetworkId = virtualNic.spec.opaqueNetwork.opaqueNetworkId;
        String opaqueNetworkType = virtualNic.spec.opaqueNetwork.opaqueNetworkType;
        for (OpaqueNetworkInfo opaqueNetwork : hostNetworkData.networkInfo.opaqueNetwork) {
            if (!opaqueNetworkId.equals(opaqueNetwork.opaqueNetworkId) || !opaqueNetworkType.equals(opaqueNetwork.opaqueNetworkType)) continue;
            return true;
        }
        return false;
    }

    private static HostVnicItem buildVnic(VirtualNic rawVnic, HostNetworkData hostNetworkData, Map<String, String> opaqueNetworkToOpaqueSwitchNameMap) {
        if (rawVnic.spec == null) {
            return new HostVnicItem();
        }
        VirtualNicManagerInfo vnicInfo = hostNetworkData.vnicManagerInfo;
        HostVnicItem vnicItem = new HostVnicItem();
        vnicItem.device = rawVnic.device != null ? rawVnic.device : "";
        vnicItem.networkStackName = VnicParser.extractNetworkStackName(rawVnic, hostNetworkData);
        vnicItem.firstIpAddress = VnicParser.extractIpAddress(rawVnic);
        vnicItem.isManagementTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.management, vnicInfo);
        vnicItem.isVmotionEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vmotion, vnicInfo);
        vnicItem.isFtEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.faultToleranceLogging, vnicInfo);
        vnicItem.isVsanEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vsan, vnicInfo);
        vnicItem.isProvisioningNfcTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vSphereProvisioning, vnicInfo);
        vnicItem.isVrTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vSphereReplication, vnicInfo);
        vnicItem.isVrNfcTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vSphereReplicationNFC, vnicInfo);
        vnicItem.networkLabel = VnicParser.extractNetworkLabel(rawVnic, hostNetworkData);
        if (rawVnic.spec.portgroup != null) {
            vnicItem.virtualSwitch = VnicParser.extractStandardSwitchName(rawVnic, hostNetworkData.networkInfo.getPortgroup());
            vnicItem.connectedTo = VnicConnectionType.STANDARD_NETWORK.toString();
        } else if (rawVnic.spec.distributedVirtualPort != null) {
            vnicItem.virtualSwitch = VnicParser.extractDVSwitchName(rawVnic, hostNetworkData.networkInfo.getProxySwitch());
            vnicItem.connectedTo = VnicConnectionType.DVS.toString();
        } else if (rawVnic.spec.opaqueNetwork != null) {
            vnicItem.virtualSwitch = VnicParser.getOpaqueSwitchName(rawVnic, opaqueNetworkToOpaqueSwitchNameMap);
            vnicItem.connectedTo = VnicConnectionType.OPAQUE_NETWORK.toString();
        }
        return vnicItem;
    }

    private static String extractNetworkLabel(VirtualNic rawVnic, HostNetworkData hostNetworkData) {
        if (rawVnic.spec.portgroup != null) {
            return rawVnic.spec.portgroup;
        }
        if (rawVnic.spec.distributedVirtualPort != null) {
            return VnicParser.getDistributedVirtualPortgroupName(rawVnic.spec.distributedVirtualPort.portgroupKey, rawVnic.spec.distributedVirtualPort.switchUuid, hostNetworkData.dvPortgroupData);
        }
        if (rawVnic.spec.opaqueNetwork != null) {
            return VnicParser.getOpaqueNetwork(rawVnic.spec.opaqueNetwork.opaqueNetworkId, rawVnic.spec.opaqueNetwork.opaqueNetworkType, hostNetworkData.networkInfo);
        }
        return "";
    }

    private static Boolean isTrafficEnabled(VirtualNic rawVnic, VirtualNicManager.NicType nicType, VirtualNicManagerInfo vnicManagerInfo) {
        if (vnicManagerInfo == null || vnicManagerInfo.netConfig == null) {
            return false;
        }
        for (VirtualNicManager.NetConfig netConfig : vnicManagerInfo.netConfig) {
            if (!netConfig.nicType.equals(nicType.name()) || netConfig.selectedVnic == null) continue;
            for (String selectedVnicId : netConfig.selectedVnic) {
                String selectedVnicKey = selectedVnicId.substring(selectedVnicId.indexOf(".") + 1);
                if (!rawVnic.key.equals(selectedVnicKey)) continue;
                return true;
            }
        }
        return false;
    }

    private static String extractIpAddress(VirtualNic rawVnic) {
        IpConfig.IpV6Address[] ipV6Addresses;
        String subnetMask;
        if (rawVnic.spec.ip == null) {
            return "";
        }
        IpConfig ipConfig = rawVnic.spec.ip;
        String ipv4 = ipConfig.getIpAddress();
        if (!IpUtil.isIpV4LinkLocal(ipv4, subnetMask = ipConfig.getSubnetMask()) && !StringUtil.isNullOrEmpty((String)ipv4)) {
            return ipv4;
        }
        for (IpConfig.IpV6Address ipV6Address : ipV6Addresses = ipConfig.ipV6Config != null ? ipConfig.ipV6Config.getIpV6Address() : new IpConfig.IpV6Address[]{}) {
            if (StringUtil.isNullOrEmpty((String)ipV6Address.getIpAddress()) || IpUtil.isIpV6LinkLocal(ipV6Address)) continue;
            return ipV6Address.getIpAddress();
        }
        if (!StringUtil.isNullOrEmpty((String)ipv4)) {
            return ipv4;
        }
        for (IpConfig.IpV6Address ipV6Address : ipV6Addresses) {
            if (StringUtil.isNullOrEmpty((String)ipV6Address.getIpAddress())) continue;
            return ipV6Address.getIpAddress();
        }
        return "";
    }

    private static String getOpaqueNetwork(String vnicOpaqueNetworkId, String vnicOpaqueNetworkType, NetworkInfo hostNetworkInfo) {
        if (!ArrayUtil.isNullOrEmpty((Object[])hostNetworkInfo.opaqueNetwork)) {
            for (OpaqueNetworkInfo hostOpaqueNetwork : hostNetworkInfo.opaqueNetwork) {
                if (!hostOpaqueNetwork.opaqueNetworkId.equals(vnicOpaqueNetworkId) || !hostOpaqueNetwork.opaqueNetworkType.equals(vnicOpaqueNetworkType)) continue;
                return hostOpaqueNetwork.opaqueNetworkName;
            }
        }
        return "";
    }

    private static String getDistributedVirtualPortgroupName(String portgroupKey, String switchUuid, DvPortgroupData[] hostPortgroups) {
        DvPortgroupData dvPortgroupData = DvPortgroupParser.getDistributedPortGroupData(portgroupKey, switchUuid, hostPortgroups);
        return dvPortgroupData == null ? "" : dvPortgroupData.name;
    }

    private static String extractDVSwitchName(VirtualNic rawVnic, HostProxySwitch[] proxySwitches) {
        String vnicDvpSwitchId = rawVnic.spec.distributedVirtualPort.switchUuid;
        if (proxySwitches == null) {
            return null;
        }
        for (HostProxySwitch proxySwitch : proxySwitches) {
            if (!proxySwitch.dvsUuid.equals(vnicDvpSwitchId)) continue;
            return proxySwitch.dvsName;
        }
        return null;
    }

    private static String extractStandardSwitchName(VirtualNic rawVnic, PortGroup[] portGroups) {
        if (portGroups == null) {
            return null;
        }
        for (PortGroup portGroup : portGroups) {
            if (!rawVnic.spec.portgroup.equals(portGroup.spec.getName())) continue;
            return portGroup.spec.getVswitchName();
        }
        return null;
    }

    public static String extractNetworkStackName(VirtualNic rawVnic, HostNetworkData hostNetworkData) {
        if (rawVnic == null || rawVnic.spec == null || hostNetworkData == null || hostNetworkData.hostVnicSupportedFeatures == null || !hostNetworkData.hostVnicSupportedFeatures.isTcpIpStackSupported) {
            return null;
        }
        return NetStackUtil.getNetStackInstanceName(NetStackUtil.getNetStackInstanceByKey(rawVnic.spec.netStackInstanceKey, hostNetworkData.netStackInstance));
    }

    private static Map<String, String> getOpaqueNetworkToOpaqueSwitchNameMap(NetworkInfo networkInfo) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (networkInfo == null || networkInfo.opaqueNetwork == null || networkInfo.opaqueSwitch == null) {
            return result;
        }
        block0: for (OpaqueNetworkInfo opaqueNetwork : networkInfo.opaqueNetwork) {
            for (OpaqueSwitch opaqueSwitch : networkInfo.opaqueSwitch) {
                if (!VnicParser.checkOpaqueSwitchOwnership(opaqueNetwork, opaqueSwitch)) continue;
                String opaqueNetworkKey = VnicParser.constructOpaqueNetworkKey(opaqueNetwork.opaqueNetworkId, opaqueNetwork.opaqueNetworkType);
                result.put(opaqueNetworkKey, opaqueSwitch.name);
                continue block0;
            }
        }
        return result;
    }

    private static boolean checkOpaqueSwitchOwnership(OpaqueNetworkInfo opaqueNetwork, OpaqueSwitch opaqueSwitch) {
        Object[] opaqueNetworkZoneIds = opaqueNetwork.pnicZone;
        Object[] opaqueSwitchZones = opaqueSwitch.pnicZone;
        if (ArrayUtil.isNullOrEmpty((Object[])opaqueNetworkZoneIds) || ArrayUtil.isNullOrEmpty((Object[])opaqueSwitchZones)) {
            return false;
        }
        for (Object opaqueNetworkZoneId : opaqueNetworkZoneIds) {
            boolean found = false;
            for (Object opaqueSwitchZone : opaqueSwitchZones) {
                if (!((String)opaqueNetworkZoneId).equals(((OpaqueSwitch.PhysicalNicZone)opaqueSwitchZone).key)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static String constructOpaqueNetworkKey(String opaqueNetworkId, String opaqueNetworkType) {
        return opaqueNetworkId + OPAQUE_NETWORK_KEY_SEPARATOR + opaqueNetworkType;
    }

    private static String getOpaqueSwitchName(VirtualNic vnic, Map<String, String> opaqueNetworkToOpaqueSwitchNameMap) {
        String opaqueNetworkKey = VnicParser.constructOpaqueNetworkKey(vnic.spec.opaqueNetwork.opaqueNetworkId, vnic.spec.opaqueNetwork.opaqueNetworkType);
        String result = opaqueNetworkToOpaqueSwitchNameMap.get(opaqueNetworkKey);
        if (result == null) {
            result = "";
        }
        return result;
    }
}

