/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.wizard.addnetworking;

import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import java.util.HashSet;

public class HostStandardSwitchSettingsPropertyProvider
implements PropertyProviderBean {
    private static final String V_SWITCH = "vSwitch";
    private static final String CONFIG_NETWORK_VSWITCH = "config.network.vswitch";
    private QueryExecutor _queryExecutor;

    public HostStandardSwitchSettingsPropertyProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="host", property="uniqueStandardSwitchName")
    public String getUniqueStandardSwitchName(ManagedObjectReference hostRef) throws Exception {
        String name;
        VirtualSwitch[] vSwitches = (VirtualSwitch[])this._queryExecutor.getProperty((Object)hostRef, CONFIG_NETWORK_VSWITCH);
        HashSet<String> vSwitchNames = new HashSet<String>();
        if (vSwitches != null) {
            for (VirtualSwitch vSwitch : vSwitches) {
                vSwitchNames.add(vSwitch.name);
            }
        }
        int index = 0;
        while (vSwitchNames.contains(name = String.format("%s%d", V_SWITCH, index))) {
            ++index;
        }
        return name;
    }
}

