/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.wizard.addnetworking;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.IpConfig;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostVnicIpRoutingData;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostVnicIpRoutingInfo;
import com.vmware.vsphere.client.h5.network.util.IpUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VnicSettingsPropertyProvider
implements PropertyProviderBean {
    private QueryBindingService _queryBindingService;
    private QueryExecutor _queryExecutor;

    public VnicSettingsPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory, QueryExecutor queryExecutor) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._queryExecutor = queryExecutor;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="vnic", property="portgroupMtuData")
    public Object getPortgroupMtuData(ManagedObjectReference portGroupRef) throws Exception {
        PropertyValue[] result = this._queryExecutor.getPropertyForRelatedObjects((Object)portGroupRef, "dvs", VmwareDistributedVirtualSwitch.class.getSimpleName(), "config[@type='VMwareDVSConfigInfo'].maxMtu");
        if (result != null && result.length == 1) {
            return result[0].value;
        }
        return null;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="virtualAdapterIpRouting")
    public HostVnicIpRoutingInfo getVirtualAdapterIpRouting(ManagedObjectReference hostRef) {
        HostVnicIpRoutingInfo ipRoutingInfo = new HostVnicIpRoutingInfo();
        HostVnicIpRoutingData ipRoutingData = this.fetchHostIpRoutingInfo(hostRef);
        if (ipRoutingData == null) {
            return ipRoutingInfo;
        }
        if (ipRoutingData.isTcpIpStackSupported) {
            NetStackInstance defaultNetStackInstance = null;
            if (!ArrayUtil.isNullOrEmpty((Object[])ipRoutingData.netStackInstances)) {
                for (NetStackInstance netStackInstance : ipRoutingData.netStackInstances) {
                    if (!NetStackUtil.isDefaultNetStackInstance(netStackInstance.key)) continue;
                    defaultNetStackInstance = netStackInstance;
                    break;
                }
                if (defaultNetStackInstance != null) {
                    if (defaultNetStackInstance.ipRouteConfig != null) {
                        ipRoutingInfo.ipv4DefaultGateway = defaultNetStackInstance.ipRouteConfig.defaultGateway;
                        ipRoutingInfo.ipv6DefaultGateway = defaultNetStackInstance.ipRouteConfig.ipV6DefaultGateway;
                    }
                    if (defaultNetStackInstance.dnsConfig != null) {
                        ipRoutingInfo.dnsAddresses = defaultNetStackInstance.dnsConfig.address;
                    }
                }
            }
        } else {
            if (ipRoutingData.ipRouteConfig != null) {
                ipRoutingInfo.ipv4DefaultGateway = ipRoutingData.ipRouteConfig.defaultGateway;
                ipRoutingInfo.ipv6DefaultGateway = ipRoutingData.ipRouteConfig.ipV6DefaultGateway;
            }
            if (ipRoutingData.dnsConfig != null) {
                ipRoutingInfo.dnsAddresses = ipRoutingData.dnsConfig.address;
            }
        }
        HashMap<String, Set<String>> hostIpv6Addresses = new HashMap<String, Set<String>>();
        if (!ArrayUtil.isNullOrEmpty((Object[])ipRoutingData.consoleVnic)) {
            hostIpv6Addresses.putAll(VnicSettingsPropertyProvider.getHostIpAddresses(ipRoutingData.consoleVnic));
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])ipRoutingData.vnic)) {
            hostIpv6Addresses.putAll(VnicSettingsPropertyProvider.getHostIpAddresses(ipRoutingData.vnic));
        }
        if (hostIpv6Addresses.size() > 0) {
            ipRoutingInfo.hostIpv6Addresses = hostIpv6Addresses;
        }
        return ipRoutingInfo;
    }

    private static Map<String, Set<String>> getHostIpAddresses(VirtualNic[] vnics) {
        HashMap<String, Set<String>> hostIpv6Addresses = new HashMap<String, Set<String>>();
        for (VirtualNic vnic : vnics) {
            Set<String> vnicIpAddresses = VnicSettingsPropertyProvider.getVirtualNicIpAddresses(vnic);
            if (vnicIpAddresses.size() <= 0) continue;
            hostIpv6Addresses.put(vnic.device, vnicIpAddresses);
        }
        return hostIpv6Addresses;
    }

    private static Set<String> getVirtualNicIpAddresses(VirtualNic virtualNic) {
        HashSet<String> ipAddresses = new HashSet<String>();
        if (virtualNic == null || virtualNic.spec == null) {
            return ipAddresses;
        }
        if (IpUtil.hasAnyIpv4Settings(virtualNic.spec.ip)) {
            ipAddresses.add(virtualNic.spec.ip.ipAddress);
        }
        if (IpUtil.hasAnyIpv6Addresses(virtualNic.spec.ip)) {
            for (IpConfig.IpV6Address ipv6Address : virtualNic.spec.ip.ipV6Config.ipV6Address) {
                ipAddresses.add(ipv6Address.ipAddress);
            }
        }
        return ipAddresses;
    }

    private HostVnicIpRoutingData fetchHostIpRoutingInfo(ManagedObjectReference hostRef) {
        return (HostVnicIpRoutingData)((Object)this._queryBindingService.prepare(HostVnicIpRoutingData.class).fetch((Object)hostRef));
    }
}

