/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vsphere.client.modules.api.network.HostNetworkCapability;

@QueryBinding(value="HostSystem")
public class HostStandardSwitchData
extends IdentifiableQueryBinding {
    private static final int MAX_PORTS_NUMBER = 4096;
    @Property(value="HostSystem/config/product/version")
    public transient String hostVersion;
    @Property(value="HostSystem/config/network/vswitch")
    public transient VirtualSwitch[] standardSwitches;
    @Property(value="HostSystem/config/network/proxySwitch")
    public transient HostProxySwitch[] proxySwitches;
    @Property(value="HostSystem/hostNetworkCapability")
    public transient HostNetworkCapability hostNetworkCapability;
    @Property(value="HostSystem/name")
    public String name;

    public boolean getSwitchAutoScaleSupported() {
        return this.hostNetworkCapability.proxySwitchAutoScaleSupported;
    }

    public int getAvailablePortsNumber() {
        if (this.hostNetworkCapability == null || this.hostNetworkCapability.proxySwitchAutoScaleSupported) {
            return -1;
        }
        int portNumbersReserved = 0;
        if (this.proxySwitches != null) {
            for (HostProxySwitch hostProxySwitch : this.proxySwitches) {
                portNumbersReserved += hostProxySwitch.numPorts;
            }
        }
        if (this.standardSwitches != null) {
            for (HostProxySwitch hostProxySwitch : this.standardSwitches) {
                portNumbersReserved += hostProxySwitch.numPorts;
            }
        }
        return 4096 - portNumbersReserved > 0 ? 4096 - portNumbersReserved : 0;
    }
}

