/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.util;

import com.vmware.vim.binding.vim.host.IpConfig;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Iterator;

public class IpUtil {
    private static final String IPV6_LINK_LOCAL_PREFIX = "FE80";
    private static final int IPV6_LINK_LOCAL_PREFIX_LENGTH = 64;
    private static final String IPV4_LINK_LOCAL_PREFIX = "169.254";
    private static final String IPV4_LINK_LOCAL_MASK = "255.255.0.0";

    public static boolean isIpV6LinkLocal(IpConfig.IpV6Address ipV6Address) {
        if (ipV6Address == null || ipV6Address.ipAddress == null) {
            return false;
        }
        return ipV6Address.ipAddress.trim().toUpperCase().indexOf(IPV6_LINK_LOCAL_PREFIX) == 0 && ipV6Address.prefixLength == 64;
    }

    public static boolean isIpV4LinkLocal(String address, String subnetMask) {
        return address != null && address.trim().indexOf(IPV4_LINK_LOCAL_PREFIX) == 0 && subnetMask.trim().equals(IPV4_LINK_LOCAL_MASK);
    }

    public static String ipv6AddressToString(IpConfig.IpV6Address ipv6Address) {
        if (ipv6Address == null || ipv6Address.ipAddress == null) {
            return "";
        }
        return ipv6Address.ipAddress + "/" + ipv6Address.prefixLength;
    }

    private static IpConfig.IpV6Address[] reorderIpv6Addresses(IpConfig.IpV6Address[] ipv6Addresses) {
        if (ipv6Addresses == null) {
            return null;
        }
        IpConfig.IpV6Address[] reorderedAddresses = new IpConfig.IpV6Address[ipv6Addresses.length];
        ArrayList<IpConfig.IpV6Address> linkLocalAddresses = new ArrayList<IpConfig.IpV6Address>();
        int addressCount = 0;
        for (IpConfig.IpV6Address address : ipv6Addresses) {
            if (IpUtil.isIpV6LinkLocal(address)) {
                linkLocalAddresses.add(address);
                continue;
            }
            reorderedAddresses[addressCount] = address;
            ++addressCount;
        }
        Iterator i$ = linkLocalAddresses.iterator();
        while (i$.hasNext()) {
            IpConfig.IpV6Address linkLocal;
            reorderedAddresses[addressCount] = linkLocal = (IpConfig.IpV6Address)i$.next();
            ++addressCount;
        }
        return reorderedAddresses;
    }

    public static String getLocalizedIPv6AddrConfigType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals(IpConfig.IpV6AddressConfigType.dhcp.toString())) {
            return NetworkStringUtil.getString("IpV6AddressConfigType.ipAddrDhcpTypeFormat");
        }
        if (type.equals(IpConfig.IpV6AddressConfigType.manual.toString())) {
            return NetworkStringUtil.getString("IpV6AddressConfigType.ipAddrStaticTypeFormat");
        }
        if (type.equals(IpConfig.IpV6AddressConfigType.linklayer.toString())) {
            return NetworkStringUtil.getString("IpV6AddressConfigType.ipAddrLinkLayerTypeFormat");
        }
        if (type.equals(IpConfig.IpV6AddressConfigType.random.toString())) {
            return NetworkStringUtil.getString("IpV6AddressConfigType.ipAddrRandomTypeFormat");
        }
        return null;
    }

    public static String[] formatIpv6Addresses(IpConfig.IpV6Address[] addresses) {
        IpConfig.IpV6Address[] reorderedAddress = IpUtil.reorderIpv6Addresses(addresses);
        if (reorderedAddress == null) {
            return null;
        }
        String[] formattedAddresses = new String[reorderedAddress.length];
        for (int i = 0; i < formattedAddresses.length; ++i) {
            String localizedAddressConfigType = IpUtil.getLocalizedIPv6AddrConfigType(reorderedAddress[i].origin);
            String localizedIpAddress = IpUtil.ipv6AddressToString(reorderedAddress[i]);
            formattedAddresses[i] = !StringUtil.isNullOrEmpty((String)localizedAddressConfigType) ? NetworkStringUtil.getString("IpV6Address.ipAddressTypeFormat", localizedIpAddress, localizedAddressConfigType) : localizedIpAddress;
        }
        return formattedAddresses;
    }

    public static boolean hasAnyIpv6Addresses(IpConfig ipConfig) {
        return ipConfig != null && ipConfig.ipV6Config != null && !ArrayUtil.isNullOrEmpty((Object[])ipConfig.ipV6Config.ipV6Address);
    }

    public static boolean hasAnyIpv4Settings(IpConfig ipConfig) {
        return ipConfig != null && (ipConfig.dhcp || !StringUtil.isNullOrEmpty((String)ipConfig.ipAddress));
    }
}

