/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.util;

import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.Tag;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class NetworkUtil {
    private static final String DVS_UPLINK_PORTGROUP_TAG = "SYSTEM/DVS.UPLINKPG";
    public static final int VLAN_NONE_ID = 0;
    private static final String OUT_RANGE_DELIMITER = ", ";
    private static final String OUT_RANGE_DIVIDER = "-";
    private static final String VMWARE_VENDOR = "VMware";
    private static final String VMWARE_VENDOR_INC = "VMware, Inc.";
    public static final long DEFAULT_BANDWIDTH = 100000L;

    public static boolean isUplink(ManagedObjectReference objRef, Tag[] tags) {
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, DistributedVirtualPortgroup.class)) {
            return NetworkUtil.isUplinkPortGroup(tags);
        }
        return false;
    }

    public static boolean isUplinkPortGroup(Tag[] tags) {
        if (ArrayUtil.isNullOrEmpty((Object[])tags)) {
            return false;
        }
        for (Tag tag : tags) {
            if (!tag.getKey().equals(DVS_UPLINK_PORTGROUP_TAG)) continue;
            return true;
        }
        return false;
    }

    public static String getNumericRangeAsString(NumericRange[] ranges) {
        if (ranges == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String outRangeDelimiter = "";
        for (NumericRange range : ranges) {
            result.append(outRangeDelimiter);
            if (range.getStart() == range.getEnd()) {
                result.append(Integer.toString(range.getStart()));
            } else {
                result.append(Integer.toString(range.getStart()));
                result.append(OUT_RANGE_DIVIDER);
                result.append(Integer.toString(range.getEnd()));
            }
            outRangeDelimiter = OUT_RANGE_DELIMITER;
        }
        return result.toString();
    }

    public static boolean isVmwareVendor(String vendor) {
        return VMWARE_VENDOR.equals(vendor) || VMWARE_VENDOR_INC.equals(vendor);
    }

    public static <T> T requestPropertyWithParam(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, Object mor, String propertyName, Object param) throws Exception {
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.propertyName = propertyName;
        paramSpec.parameter = param;
        QuerySpec querySpec = querySpecBuilder.buildQuerySpec(mor, new String[]{propertyName});
        querySpec.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{paramSpec};
        ResultSet resultSet = queryExecutor.getData(querySpec);
        if (resultSet != null && resultSet.items != null && resultSet.items.length > 0 && resultSet.items[0].properties != null) {
            for (PropertyValue propValue : resultSet.items[0].properties) {
                if (!propertyName.equals(propValue.propertyName)) continue;
                return (T)propValue.value;
            }
        }
        return null;
    }

    public static VirtualSwitch getVswitchByName(String vSwitchName, VirtualSwitch[] vSwitches) {
        if (vSwitches == null || StringUtils.isEmpty((String)vSwitchName)) {
            return null;
        }
        for (VirtualSwitch vs : vSwitches) {
            if (!vs.name.equals(vSwitchName)) continue;
            return vs;
        }
        return null;
    }

    public static List<PhysicalNic> getSwitchPnics(VirtualSwitch vSwitch, PhysicalNic[] pnics) {
        ArrayList<PhysicalNic> switchPnics = new ArrayList<PhysicalNic>();
        if (vSwitch != null && vSwitch.pnic != null && pnics != null) {
            for (PhysicalNic pnic : pnics) {
                for (String pnicKey : vSwitch.pnic) {
                    if (!pnicKey.equals(pnic.key)) continue;
                    switchPnics.add(pnic);
                }
            }
        }
        return switchPnics;
    }

    public static boolean isPnicAttachedToVss(PhysicalNic pnic, VirtualSwitch[] vSwitches) {
        if (pnic == null || vSwitches == null) {
            return false;
        }
        for (VirtualSwitch vSwitch : vSwitches) {
            if (vSwitch.pnic == null) continue;
            for (String pnicKey : vSwitch.pnic) {
                if (!pnicKey.equals(pnic.key)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLastManagementVmnic(NetworkInfo networkInfo, String virtualNicName) {
        VirtualNic[] defaultNetStackVnics = networkInfo.vnic;
        if (!ArrayUtil.isNullOrEmpty((Object[])networkInfo.netStackInstance)) {
            LinkedList<VirtualNic> defaultStackVnics = new LinkedList<VirtualNic>();
            for (VirtualNic vnic : defaultNetStackVnics) {
                if (!StringUtil.isNullOrEmpty((String)vnic.getSpec().getNetStackInstanceKey()) && !NetStackUtil.isDefaultNetStackInstance(vnic.getSpec().getNetStackInstanceKey())) continue;
                defaultStackVnics.add(vnic);
            }
            defaultNetStackVnics = defaultStackVnics.toArray(new VirtualNic[defaultStackVnics.size()]);
        }
        return defaultNetStackVnics.length == 1 && defaultNetStackVnics[0].getDevice().equals(virtualNicName);
    }

    public static VirtualNic getVirtualNicByPortGroupName(String portGroupName, VirtualNic[] virtualNics) {
        VirtualNic portGroupVirtualNic = null;
        if (portGroupName != null && virtualNics != null) {
            for (VirtualNic vnic : virtualNics) {
                if (vnic == null || !portGroupName.equals(vnic.portgroup)) continue;
                portGroupVirtualNic = vnic;
                break;
            }
        }
        return portGroupVirtualNic;
    }
}

