/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.util;

import com.vmware.vim.binding.vim.host.PortGroup;
import java.util.Arrays;
import java.util.HashSet;

public class VlanUtil {
    public static final String VLAN_NONE = "none";
    public static final String VLAN_VLAN = "vlan";
    public static final String VLAN_TRUNK = "trunk";
    public static final String VLAN_PRIVATE = "private";
    public static final int VLAN_NUM_NONE = 0;
    public static final int VLAN_NUM_ALL = 4095;

    public static int[] getAvailableVlanIds(PortGroup[] portGroups) {
        HashSet<Integer> vlanIds = new HashSet<Integer>();
        vlanIds.add(0);
        vlanIds.add(4095);
        if (portGroups != null) {
            for (PortGroup portGroup : portGroups) {
                if (portGroup == null || portGroup.spec == null) continue;
                vlanIds.add(portGroup.spec.vlanId);
            }
        }
        int[] vlanIdArr = new int[vlanIds.size()];
        int index = 0;
        for (Integer vlandId : vlanIds) {
            vlanIdArr[index] = vlandId;
            ++index;
        }
        Arrays.sort(vlanIdArr);
        return vlanIdArr;
    }
}

