/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authz;

import com.vmware.cis.authz.RoleDefinitions;
import com.vmware.cis.authz.RoleSyncProvider;
import com.vmware.cis.authz.RoleTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class RoleSyncApiInterface
extends ApiInterfaceSkeleton {
    private RoleSyncProvider impl;

    public RoleSyncApiInterface() {
        this((Class<? extends RoleSyncProvider>)null);
    }

    public RoleSyncApiInterface(Class<? extends RoleSyncProvider> clazz) {
        this((RoleSyncProvider)RoleSyncApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.authz.impl.RoleImpl", RoleSyncProvider.class));
    }

    public RoleSyncApiInterface(RoleSyncProvider roleSyncProvider) {
        super("com.vmware.cis.authz.role");
        Validate.notNull((Object)roleSyncProvider);
        this.impl = roleSyncProvider;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(RoleSyncApiInterface.this.getIdentifier(), "list", RoleDefinitions.__listInput, RoleDefinitions.__listOutput, RoleSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(structValue, RoleDefinitions.__listInput, RoleSyncApiInterface.this.getTypeConverter());
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)RoleSyncApiInterface.this.getTypeConverter().convertToVapi(RoleSyncApiInterface.this.impl.list(invocationContext), RoleDefinitions.__listOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(RoleSyncApiInterface.this.getIdentifier(), "delete", RoleDefinitions.__deleteInput, RoleDefinitions.__deleteOutput, RoleSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unsupported;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, RoleDefinitions.__deleteInput, RoleSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            try {
                RoleSyncApiInterface.this.impl.delete(string, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(RoleSyncApiInterface.this.getIdentifier(), "update", RoleDefinitions.__updateInput, RoleDefinitions.__updateOutput, RoleSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unsupported;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, RoleDefinitions.__updateInput, RoleSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            RoleTypes.UpdateSpec updateSpec = (RoleTypes.UpdateSpec)structValueExtractor.valueForField("update_spec");
            try {
                RoleSyncApiInterface.this.impl.update(string, updateSpec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(RoleSyncApiInterface.this.getIdentifier(), "get", RoleDefinitions.__getInput, RoleDefinitions.__getOutput, RoleSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, RoleDefinitions.__getInput, RoleSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)RoleSyncApiInterface.this.getTypeConverter().convertToVapi((Object)RoleSyncApiInterface.this.impl.get(string, invocationContext), RoleDefinitions.__getOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(RoleSyncApiInterface.this.getIdentifier(), "create", RoleDefinitions.__createInput, RoleDefinitions.__createOutput, RoleSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, RoleDefinitions.__createInput, RoleSyncApiInterface.this.getTypeConverter());
            RoleTypes.CreateSpec createSpec = (RoleTypes.CreateSpec)structValueExtractor.valueForField("create_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)RoleSyncApiInterface.this.getTypeConverter().convertToVapi((Object)RoleSyncApiInterface.this.impl.create(createSpec, invocationContext), RoleDefinitions.__createOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }
}

