/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.idp;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;

public final class IdpService {
    private final URI _type;
    private final Set<Endpoint> _endpoints;

    public IdpService(URI type, Set<Endpoint> endpoints) {
        ValidateUtil.validateNotNull(type, "ServiceType");
        ValidateUtil.validateNotEmpty(endpoints, "Endpoints");
        this._type = type;
        this._endpoints = Collections.unmodifiableSet(endpoints);
    }

    public URI getType() {
        return this._type;
    }

    public Set<Endpoint> getEndpoints() {
        return this._endpoints;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IdpService)) {
            return false;
        }
        IdpService _other = (IdpService)obj;
        return this._type.equals(_other._type);
    }

    public int hashCode() {
        return this._type.hashCode();
    }

    public String toString() {
        return String.format("Service (type: %s, endpoints: %d)", this._type, this._endpoints.size());
    }

    public static final class Endpoint {
        private final X509Certificate _sslTrustAnchor;
        private final URI _url;

        public Endpoint(URI url, X509Certificate sslTrustAnchor) {
            ValidateUtil.validateNotNull(url, "Url");
            ValidateUtil.validateNotNull(sslTrustAnchor, "SSL trust anchor");
            this._url = url;
            this._sslTrustAnchor = sslTrustAnchor;
        }

        public X509Certificate getSslTrustAnchor() {
            return this._sslTrustAnchor;
        }

        public URI getUrl() {
            return this._url;
        }

        public boolean equals(Object other) {
            return other != null && other instanceof IdpService && this._url.equals(((IdpService)other)._type);
        }

        public int hashCode() {
            return this._url.hashCode();
        }

        public String toString() {
            return String.format("Endpoint: (uri='%s', SSLCertIssuer='%s')", this._url, this._sslTrustAnchor.getIssuerDN());
        }
    }
}

