/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.ExternalDomainDetails;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;

public final class ExternalDomain {
    private final String _name;
    private final String _alias;
    private final Type _type;
    private final ExternalDomainDetails _details;
    private final AuthenticationDetails _authenticationDetails;

    public ExternalDomain(String name, String alias, Type type, ExternalDomainDetails details, AuthenticationDetails authenticationDetails) {
        ValidateUtil.validateNotEmpty(name, "name");
        ValidateUtil.validateNotNull((Object)type, "type");
        ValidateUtil.validateNotNull(details, "details");
        ValidateUtil.validateNotNull(authenticationDetails, "authenticationDetails");
        this._name = name;
        this._alias = alias;
        this._type = type;
        this._details = details;
        this._authenticationDetails = authenticationDetails;
    }

    public String getName() {
        return this._name;
    }

    public String getAlias() {
        return this._alias;
    }

    public Type getType() {
        return this._type;
    }

    public ExternalDomainDetails getDetails() {
        return this._details;
    }

    public AuthenticationDetails getAuthenticationDetails() {
        return this._authenticationDetails;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExternalDomain)) {
            return false;
        }
        return this._name.equalsIgnoreCase(((ExternalDomain)obj)._name);
    }

    public int hashCode() {
        return this._name.toLowerCase().hashCode();
    }

    public String toString() {
        StringBuilder objString = new StringBuilder(100);
        objString.append(super.toString());
        objString.append(", name=");
        objString.append(this.getName());
        objString.append(", alias=");
        objString.append(this.getAlias());
        objString.append(", type=");
        objString.append((Object)this.getType());
        objString.append(", authenticationDetails=(");
        objString.append(this.getAuthenticationDetails());
        objString.append("), details=(");
        objString.append(this.getDetails());
        objString.append(")");
        return objString.toString();
    }

    public static final class AuthenticationDetails {
        private final AuthenticationType _authenticationType;
        private final String _username;

        public AuthenticationDetails(AuthenticationType authenticationType, String username) {
            ValidateUtil.validateNotNull((Object)authenticationType, "authenticationType");
            if (AuthenticationType.password.equals((Object)authenticationType)) {
                ValidateUtil.validateNotEmpty(username, "username");
            }
            this._authenticationType = authenticationType;
            this._username = username;
        }

        public AuthenticationType getAuthenticationType() {
            return this._authenticationType;
        }

        public String getUsername() {
            return this._username;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(70);
            objString.append(super.toString());
            objString.append(", type=");
            objString.append((Object)this.getAuthenticationType());
            objString.append(", userName=");
            objString.append(this.getUsername());
            return objString.toString();
        }
    }

    public static enum AuthenticationType {
        anonymous,
        password,
        reuseSession;

    }

    public static enum Type {
        ActiveDirectory,
        OpenLdap,
        NIS;

    }
}

