/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.ExternalDomainSchemaDetails;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ExternalDomainDetails {
    private final String _friendlyName;
    private final String _userBaseDn;
    private final String _groupBaseDn;
    private final URI _primaryUrl;
    private final URI _failoverUrl;
    private final int _searchTimeoutSeconds;
    private final ExternalDomainSchemaDetails _schemaDetails;
    private final Set<String> _upnSuffixes;

    public ExternalDomainDetails(String friendlyName, String userBaseDn, String groupBaseDn, URI primaryUrl, URI failoverUrl, int searchTimeoutSeconds) {
        this(friendlyName, userBaseDn, groupBaseDn, primaryUrl, failoverUrl, searchTimeoutSeconds, null);
    }

    public ExternalDomainDetails(String friendlyName, String userBaseDn, String groupBaseDn, URI primaryUrl, URI failoverUrl, int searchTimeoutSeconds, ExternalDomainSchemaDetails externalDomainSchemaDetails) {
        this(friendlyName, userBaseDn, groupBaseDn, primaryUrl, failoverUrl, searchTimeoutSeconds, externalDomainSchemaDetails, Collections.emptySet());
    }

    public ExternalDomainDetails(String friendlyName, String userBaseDn, String groupBaseDn, URI primaryUrl, URI failoverUrl, int searchTimeoutSeconds, ExternalDomainSchemaDetails externalDomainSchemaDetails, Set<String> upnSuffixes) {
        ValidateUtil.validateNotEmpty(friendlyName, "friendlyName");
        ValidateUtil.validateNotNull(primaryUrl, "primaryUrl");
        if (searchTimeoutSeconds < 0) {
            throw new IllegalArgumentException("'searchTimeoutSeconds' value should be positive; actual value is " + searchTimeoutSeconds);
        }
        this._friendlyName = friendlyName;
        this._userBaseDn = userBaseDn;
        this._groupBaseDn = groupBaseDn;
        this._primaryUrl = primaryUrl;
        this._failoverUrl = failoverUrl;
        this._searchTimeoutSeconds = searchTimeoutSeconds;
        this._schemaDetails = externalDomainSchemaDetails;
        this._upnSuffixes = new HashSet<String>();
        if (upnSuffixes != null) {
            this._upnSuffixes.addAll(upnSuffixes);
        }
    }

    public String getFriendlyName() {
        return this._friendlyName;
    }

    public String getUserBaseDn() {
        return this._userBaseDn;
    }

    public String getGroupBaseDn() {
        return this._groupBaseDn;
    }

    public URI getPrimaryUrl() {
        return this._primaryUrl;
    }

    public URI getFailoverUrl() {
        return this._failoverUrl;
    }

    public int getSearchTimeoutSeconds() {
        return this._searchTimeoutSeconds;
    }

    public ExternalDomainSchemaDetails getSchemaDetails() {
        return this._schemaDetails;
    }

    public Set<String> getUpnSuffixes() {
        return Collections.unmodifiableSet(this._upnSuffixes);
    }

    public String toString() {
        StringBuilder objString = new StringBuilder(100);
        objString.append(super.toString());
        objString.append(" friendlyName=");
        objString.append(this._friendlyName);
        objString.append(", userBaseDn=");
        objString.append(this._userBaseDn);
        objString.append(", groupBaseDn=");
        objString.append(this._groupBaseDn);
        objString.append(", primaryUrl=");
        objString.append(this._primaryUrl);
        objString.append(", failoverUrl=");
        objString.append(this._failoverUrl);
        objString.append(", searchTimeoutSeconds=");
        objString.append(this._searchTimeoutSeconds);
        if (this._schemaDetails != null) {
            objString.append(", _schemaDetails=[");
            objString.append(this._schemaDetails);
            objString.append("]");
        }
        objString.append(", _upnSuffixes=");
        objString.append(this._upnSuffixes);
        return objString.toString();
    }
}

