/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.ExternalDomainAttributeMapping;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ExternalDomainObjectMapping {
    private String _objectId;
    private String _objectClass;
    private Map<String, ExternalDomainAttributeMapping> _attributeMappings;

    private ExternalDomainObjectMapping(String objectId, String objectClass, Map<String, ExternalDomainAttributeMapping> attributeMappings) {
        this._objectId = objectId;
        this._objectClass = objectClass;
        this._attributeMappings = new HashMap<String, ExternalDomainAttributeMapping>();
        this._attributeMappings.putAll(attributeMappings);
        this._attributeMappings = Collections.unmodifiableMap(this._attributeMappings);
    }

    public String getObjectId() {
        return this._objectId;
    }

    public String getObjectClass() {
        return this._objectClass;
    }

    public Collection<ExternalDomainAttributeMapping> getMappedAttributes() {
        return this._attributeMappings.values();
    }

    public ExternalDomainAttributeMapping getAttributeMapping(String attributeId) {
        ValidateUtil.validateNotEmpty(attributeId, attributeId);
        return this._attributeMappings.get(attributeId);
    }

    public String toString() {
        StringBuilder objString = new StringBuilder(200);
        objString.append(super.toString());
        objString.append(" [ObjectId=");
        objString.append(this._objectId);
        objString.append(", ObjectClass=");
        objString.append(this._objectClass != null ? this._objectClass : "(null)");
        objString.append(" MappedAttributes={ ");
        for (ExternalDomainAttributeMapping mapping : this._attributeMappings.values()) {
            objString.append(mapping);
            objString.append(", ");
        }
        objString.append(" }");
        objString.append("]");
        return objString.toString();
    }

    public static final class ObjectIds {
        public static final String ObjectIdUser = "ObjectIdUser";
        public static final String ObjectIdGroup = "ObjectIdGroup";
        public static final String ObjectIdPasswordSettings = "ObjectIdPasswordSettings";
        public static final String ObjectIdDomain = "ObjectIdDomain";

        private ObjectIds() {
        }
    }

    public static final class Builder {
        Map<String, ExternalDomainAttributeMapping> _attributeMappings;
        private String _idOfObject;
        private String _objectClassOfObject;

        public Builder(String objectId) {
            ExternalDomainAttributeMapping.validateId(objectId, "objectId");
            this._attributeMappings = new HashMap<String, ExternalDomainAttributeMapping>();
            this._idOfObject = objectId;
            this._objectClassOfObject = null;
        }

        public void setObjectClass(String objectClass) {
            if (objectClass != null && !objectClass.isEmpty()) {
                ExternalDomainAttributeMapping.validateName(objectClass, "objectClass");
            }
            this._objectClassOfObject = objectClass;
        }

        public void addAttributeMapping(ExternalDomainAttributeMapping attributeMapping) {
            ValidateUtil.validateNotNull(attributeMapping, "attributeMapping");
            this._attributeMappings.put(attributeMapping.getAttributeId(), attributeMapping);
        }

        public ExternalDomainObjectMapping buildObjectMapping() {
            return new ExternalDomainObjectMapping(this._idOfObject, this._objectClassOfObject, this._attributeMappings);
        }
    }
}

