/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.AttributeConfig;
import com.vmware.vim.sso.admin.ServiceEndpoint;
import com.vmware.vim.sso.admin.TokenClaimAttribute;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IDPConfiguration {
    private final String entityID;
    private final String entityName;
    private final Collection<String> nameIDFormats;
    private final Collection<ServiceEndpoint> ssoServices;
    private final Collection<ServiceEndpoint> sloServices;
    private final List<X509Certificate> signingCertificateChain;
    private AttributeConfig[] subjectFormatMappings;
    private Map<TokenClaimAttribute, List<String>> tokenClaimGroupMappings;
    private boolean isJitEnabled;
    private String upnSuffix;

    public IDPConfiguration(String entityID, Collection<String> nameIDFormats, Collection<ServiceEndpoint> ssoServices, Collection<ServiceEndpoint> sloServices, List<X509Certificate> signingCertificateChain, AttributeConfig[] subjectFormatMappings, boolean isJitEnabled, Map<TokenClaimAttribute, List<String>> tokenClaimGroupMappings, String upnSuffix) {
        ValidateUtil.validateNotEmpty(entityID, "entityID");
        ValidateUtil.validateNotNull(nameIDFormats, "nameIDFormats");
        ValidateUtil.validateNotNull(ssoServices, "ssoServices");
        ValidateUtil.validateNotEmpty(signingCertificateChain, "signingCertificateChain");
        this.entityID = entityID;
        this.entityName = entityID;
        this.nameIDFormats = nameIDFormats;
        this.ssoServices = ssoServices;
        if (sloServices == null) {
            sloServices = Collections.emptyList();
        }
        this.sloServices = sloServices;
        this.signingCertificateChain = signingCertificateChain;
        if (subjectFormatMappings == null) {
            subjectFormatMappings = new AttributeConfig[]{};
        }
        if (tokenClaimGroupMappings == null) {
            tokenClaimGroupMappings = new HashMap<TokenClaimAttribute, List<String>>();
        }
        if (!tokenClaimGroupMappings.isEmpty() && tokenClaimGroupMappings.values().contains(null)) {
            throw new IllegalArgumentException("One or more group lists are null in claim group mappings.");
        }
        this.subjectFormatMappings = subjectFormatMappings;
        this.isJitEnabled = isJitEnabled;
        this.tokenClaimGroupMappings = tokenClaimGroupMappings;
        this.upnSuffix = upnSuffix;
    }

    public IDPConfiguration(String entityID, Collection<String> nameIDFormats, Collection<ServiceEndpoint> ssoServices, Collection<ServiceEndpoint> sloServices, List<X509Certificate> signingCertificateChain, AttributeConfig[] subjectFormatMappings) {
        this(entityID, nameIDFormats, ssoServices, sloServices, signingCertificateChain, subjectFormatMappings, false, null, null);
    }

    public IDPConfiguration(String entityID, Collection<String> nameIDFormats, Collection<ServiceEndpoint> ssoServices, List<X509Certificate> signingCertificateChain) {
        this(entityID, nameIDFormats, ssoServices, Collections.emptyList(), signingCertificateChain, new AttributeConfig[0], false, null, null);
    }

    public String getEntityID() {
        return this.entityID;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Collection<String> getNameIDFormats() {
        return this.nameIDFormats;
    }

    public boolean getJitAttribute() {
        return this.isJitEnabled;
    }

    public void setJitAttribute(boolean isJitEnabled) {
        this.isJitEnabled = isJitEnabled;
    }

    public String getUpnSuffix() {
        return this.upnSuffix;
    }

    public Collection<ServiceEndpoint> getSsoServices() {
        return this.ssoServices;
    }

    public Collection<ServiceEndpoint> getSloServices() {
        return this.sloServices;
    }

    public List<X509Certificate> getSigningCertificateChain() {
        return this.signingCertificateChain;
    }

    public AttributeConfig[] getSubjectFormatMappings() {
        return this.subjectFormatMappings;
    }

    public void setSubjectFormatMappings(AttributeConfig[] subjectFormatMappings) {
        this.subjectFormatMappings = subjectFormatMappings;
    }

    public Map<TokenClaimAttribute, List<String>> getTokenClaimGroupMappings() {
        return this.tokenClaimGroupMappings;
    }
}

