/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.Domain;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.util.Collections;
import java.util.Set;

public abstract class IdentitySource {
    protected final String _name;
    protected final Set<Domain> _domains;

    public IdentitySource(String name, Set<Domain> domains) {
        ValidateUtil.validateNotEmpty(name, "name");
        ValidateUtil.validateNotNull(domains, "domains");
        ValidateUtil.validatePositiveNumber(domains.size(), "domains.size");
        this._name = name;
        this._domains = Collections.unmodifiableSet(domains);
    }

    public String getName() {
        return this._name;
    }

    public Set<Domain> getDomains() {
        return this._domains;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this._name + ", domains=" + this._domains + "]";
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this._name.equalsIgnoreCase(((IdentitySource)obj)._name);
    }

    public final int hashCode() {
        return this._name.toLowerCase().hashCode();
    }
}

