/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.GenericIdentitySource;
import com.vmware.vim.sso.admin.IdentitySource;
import com.vmware.vim.sso.admin.LdapIdentitySource;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class IdentitySources {
    private final Set<LdapIdentitySource> _ldaps;
    private final IdentitySource _system;
    private final IdentitySource _localOS;
    private final IdentitySource _nativeAD;
    private final Set<IdentitySource> _all;

    public IdentitySources(Set<LdapIdentitySource> ldaps, GenericIdentitySource system, GenericIdentitySource localOS, GenericIdentitySource nativeAD) {
        this(ldaps, system, localOS, nativeAD, IdentitySources.collectAll(ldaps, system, localOS, nativeAD));
    }

    public IdentitySources(Set<LdapIdentitySource> ldaps, GenericIdentitySource system, GenericIdentitySource localOS, GenericIdentitySource nativeAD, Set<IdentitySource> all) {
        ValidateUtil.validateNotNull(system, "system");
        ValidateUtil.validateNotNull(ldaps, "ldaps");
        ValidateUtil.validateNotNull(all, "all");
        this._ldaps = Collections.unmodifiableSet(ldaps);
        this._system = system;
        this._localOS = localOS;
        this._nativeAD = nativeAD;
        this._all = all;
    }

    public Set<LdapIdentitySource> getLdaps() {
        return this._ldaps;
    }

    public Set<IdentitySource> getAll() {
        return this._all;
    }

    public IdentitySource getNativeAD() {
        return this._nativeAD;
    }

    public IdentitySource getLocalOS() {
        return this._localOS;
    }

    public IdentitySource getSystem() {
        return this._system;
    }

    public String getSystemDomainName() {
        return this._system.getDomains().iterator().next().getName();
    }

    public String getLocalOSDomainName() {
        if (this._localOS == null) {
            return null;
        }
        return this._localOS.getDomains().iterator().next().getName();
    }

    private static Set<IdentitySource> collectAll(Set<LdapIdentitySource> ldaps, GenericIdentitySource system, GenericIdentitySource localOs, GenericIdentitySource nativeAd) {
        HashSet<LdapIdentitySource> all = new HashSet<LdapIdentitySource>(ldaps);
        all.add((LdapIdentitySource)((Object)system));
        if (localOs != null) {
            all.add((LdapIdentitySource)((Object)localOs));
        }
        if (nativeAd != null) {
            all.add((LdapIdentitySource)((Object)nativeAd));
        }
        return Collections.unmodifiableSet(all);
    }
}

