/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.util.Arrays;

public final class PasswordExpirationConfig {
    private final boolean _isEmailNotificationEnabled;
    private final String _emailFrom;
    private final String _emailSubject;
    private final int[] _notificationDays;

    private PasswordExpirationConfig(boolean isEmailNotificationEnabled, String emailFrom, String emailSubject, int[] notificationDays) {
        this._isEmailNotificationEnabled = isEmailNotificationEnabled;
        this._emailFrom = emailFrom;
        this._emailSubject = emailSubject;
        this._notificationDays = notificationDays;
    }

    public boolean isEmailNotificationEnabled() {
        return this._isEmailNotificationEnabled;
    }

    public String getEmailFrom() {
        return this._emailFrom;
    }

    public String getEmailSubject() {
        return this._emailSubject;
    }

    public int[] getNotificationDays() {
        return this._notificationDays;
    }

    public static PasswordExpirationConfig createNotificationDisabledConfig() {
        return new PasswordExpirationConfig(false, null, null, null);
    }

    public static PasswordExpirationConfig createNotificationEnabledConfig(String emailFrom, String emailSubject, int[] notificationDays) {
        ValidateUtil.validateNotEmpty(emailFrom, "Email address");
        ValidateUtil.validateNotEmpty(emailSubject, "Email subject");
        ValidateUtil.validateNotNull(notificationDays, "Notification days");
        ValidateUtil.validatePositiveNumber(notificationDays.length, "Notification days count");
        for (int day : notificationDays) {
            ValidateUtil.validatePositiveNumber(day, "Notification day");
        }
        return new PasswordExpirationConfig(true, emailFrom, emailSubject, Arrays.copyOf(notificationDays, notificationDays.length));
    }
}

