/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.util;

import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.ValidatableSamlToken;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ExternalIDPUserGUIDUtil {
    public static boolean validateToken(ValidatableSamlToken validatableToken, List<X509Certificate> externalIDPCertChain, long clockToleranceMs) {
        boolean validated = false;
        X509Certificate[] trustedroots = new X509Certificate[]{externalIDPCertChain.get(0)};
        try {
            validatableToken.validate(trustedroots, clockToleranceMs);
            validated = true;
        }
        catch (InvalidTokenException ite) {
            return false;
        }
        return validated;
    }

    public static PrincipalId constructExternalUserId(String subjectNameID, String IdpUID) {
        String UPN_SEPARATOR = "@";
        String NETBIOS_SEPARATOR = "\\";
        String CERTGUID_DOMAIN_SEPARATOR = ".";
        String[] fields = null;
        if (-1 != subjectNameID.indexOf(UPN_SEPARATOR)) {
            fields = subjectNameID.split(UPN_SEPARATOR);
            return new PrincipalId(fields[0], ExternalIDPUserGUIDUtil.sanitized(IdpUID) + CERTGUID_DOMAIN_SEPARATOR + fields[1]);
        }
        if (-1 != subjectNameID.indexOf(NETBIOS_SEPARATOR)) {
            fields = subjectNameID.split(NETBIOS_SEPARATOR);
            return new PrincipalId(fields[1], ExternalIDPUserGUIDUtil.sanitized(IdpUID) + CERTGUID_DOMAIN_SEPARATOR + fields[0]);
        }
        return null;
    }

    private static String sanitized(String IdpUID) {
        return IdpUID.replaceAll("\\\\", "").replaceAll(",", "_");
    }

    public static String getIssuer(Document tokenDoc) {
        String ISSUER_ELEMENT_NAME = "Issuer";
        NodeList issuerNodes = tokenDoc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer");
        return ExternalIDPUserGUIDUtil.validateIssuerNodes(issuerNodes);
    }

    private static String validateIssuerNodes(NodeList issuerNodes) {
        if (0 == issuerNodes.getLength()) {
            throw new InvalidCredentials();
        }
        String contentFrom1stNode = issuerNodes.item(0).getTextContent();
        for (int i = 1; i < issuerNodes.getLength(); ++i) {
            if (0 == issuerNodes.item(i).getTextContent().compareTo(contentFrom1stNode)) continue;
            throw new InvalidCredentials();
        }
        return contentFrom1stNode;
    }
}

