/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.internal.ApplicationRecoverer;
import org.eclipse.virgo.kernel.deployer.core.internal.BlockingAbortableSignal;
import org.eclipse.virgo.kernel.deployer.core.internal.ExistingNodeLocator;
import org.eclipse.virgo.kernel.deployer.core.internal.StandardDeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.core.internal.event.DeploymentListener;
import org.eclipse.virgo.kernel.deployer.model.DuplicateDeploymentIdentityException;
import org.eclipse.virgo.kernel.deployer.model.DuplicateFileNameException;
import org.eclipse.virgo.kernel.deployer.model.DuplicateLocationException;
import org.eclipse.virgo.kernel.deployer.model.GCRoots;
import org.eclipse.virgo.kernel.deployer.model.RuntimeArtifactModel;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphInclosure;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironmentFactory;
import org.eclipse.virgo.kernel.install.pipeline.Pipeline;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyBundleDependenciesException;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyDependenciesException;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.core.KernelException;
import org.eclipse.virgo.nano.deployer.api.core.ApplicationDeployer;
import org.eclipse.virgo.nano.deployer.api.core.DeployUriNormaliser;
import org.eclipse.virgo.nano.deployer.api.core.DeployerConfiguration;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.WatchableRepository;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.io.PathReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

final class PipelinedApplicationDeployer
implements ApplicationDeployer,
ApplicationRecoverer {
    private static final String BUNDLE_TYPE = "bundle";
    private final EventLogger eventLogger;
    private final Object monitor;
    private final InstallEnvironmentFactory installEnvironmentFactory;
    private final InstallArtifactGraphInclosure installArtifactGraphInclosure;
    private final ArtifactIdentityDeterminer artifactIdentityDeterminer;
    private final RuntimeArtifactModel ram;
    private final DeploymentListener deploymentListener;
    private final Map<DeploymentIdentity, DeploymentOptions> deploymentOptionsMap;
    private final Pipeline pipeline;
    private final DeployUriNormaliser deployUriNormaliser;
    private final int deployerConfiguredTimeoutInSeconds;
    private final BundleContext bundleContext;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;

    public PipelinedApplicationDeployer(@NonNull Pipeline pipeline, @NonNull InstallArtifactGraphInclosure installArtifactGraphInclosure, @NonNull ArtifactIdentityDeterminer artifactIdentityDeterminer, @NonNull InstallEnvironmentFactory installEnvironmentFactory, @NonNull RuntimeArtifactModel ram, @NonNull DeploymentListener deploymentListener, @NonNull EventLogger eventLogger, @NonNull DeployUriNormaliser normaliser, @NonNull DeployerConfiguration deployerConfiguration, @NonNull BundleContext bundleContext) {
        DeploymentListener deploymentListener2 = deploymentListener;
        RuntimeArtifactModel runtimeArtifactModel = ram;
        InstallEnvironmentFactory installEnvironmentFactory2 = installEnvironmentFactory;
        ArtifactIdentityDeterminer artifactIdentityDeterminer2 = artifactIdentityDeterminer;
        InstallArtifactGraphInclosure installArtifactGraphInclosure2 = installArtifactGraphInclosure;
        Pipeline pipeline2 = pipeline;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)pipeline2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)installArtifactGraphInclosure2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)artifactIdentityDeterminer2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)installEnvironmentFactory2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$5$e9cfb671((Object)runtimeArtifactModel);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$6$2b4b16f2((Object)deploymentListener2);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.monitor = new Object();
            this.deploymentOptionsMap = new HashMap<DeploymentIdentity, DeploymentOptions>();
            this.eventLogger = eventLogger;
            this.installArtifactGraphInclosure = installArtifactGraphInclosure;
            this.artifactIdentityDeterminer = artifactIdentityDeterminer;
            this.installEnvironmentFactory = installEnvironmentFactory;
            this.ram = ram;
            this.deploymentListener = deploymentListener;
            this.deployUriNormaliser = normaliser;
            this.bundleContext = bundleContext;
            this.pipeline = pipeline;
            this.deployerConfiguredTimeoutInSeconds = deployerConfiguration.getDeploymentTimeoutSeconds();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIdentity deploy(URI location) throws DeploymentException {
        try {
            try {
                DeploymentIdentity deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                Object object = this.monitor;
                synchronized (object) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    deploymentIdentity = this.deploy(location, new DeploymentOptions());
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private URI normaliseDeploymentUri(URI uri) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                URI normalisedLocation = this.deployUriNormaliser.normalise(uri);
                if (normalisedLocation == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.UNSUPPORTED_URI_SCHEME, new Object[]{uri, uri.getScheme()});
                    throw new DeploymentException("PipelinedApplicationDeployer.deploy does not support '" + uri.getScheme() + "' scheme URIs");
                }
                URI uRI = normalisedLocation;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return uRI;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public DeploymentIdentity install(URI location) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                DeploymentIdentity deploymentIdentity = this.install(location, new DeploymentOptions());
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public DeploymentIdentity install(URI uri, DeploymentOptions deploymentOptions) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                URI normalisedUri = this.normaliseDeploymentUri(uri);
                DeploymentIdentity deploymentIdentity = this.doInstall(normalisedUri, deploymentOptions);
                this.deploymentListener.deployed(normalisedUri, deploymentOptions);
                DeploymentIdentity deploymentIdentity2 = deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return deploymentIdentity2;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentIdentity doInstall(URI normalisedUri, DeploymentOptions deploymentOptions) throws DeploymentException {
        try {
            try {
                DeploymentIdentity deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                Object object = this.monitor;
                synchronized (object) {
                    DeploymentIdentity deploymentIdentity2;
                    GraphNode<InstallArtifact> installNode;
                    block19: {
                        DeploymentIdentity refreshedIdentity;
                        InstallArtifact existingArtifact = this.ram.get(normalisedUri);
                        if (existingArtifact == null || (refreshedIdentity = this.refreshExistingArtifact(normalisedUri, existingArtifact)) == null) break block19;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 7] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                        deploymentIdentity = refreshedIdentity;
                    }
                    boolean shared = false;
                    try {
                        ArtifactIdentity artifactIdentity = this.determineIdentity(normalisedUri);
                        installNode = this.findSharedNode(artifactIdentity);
                        if (installNode == null) {
                            installNode = this.installArtifactGraphInclosure.constructGraphNode(artifactIdentity, new File(normalisedUri), null, null);
                        } else {
                            shared = true;
                        }
                    }
                    catch (Exception e) {
                        throw new DeploymentException(String.valueOf(e.getMessage()) + ": uri='" + normalisedUri + "'", (Throwable)e);
                    }
                    try {
                        deploymentIdentity2 = this.addGraphToModel(normalisedUri, installNode);
                    }
                    catch (KernelException ke) {
                        if (!shared) {
                            this.destroyInstallGraph(installNode);
                        }
                        throw new DeploymentException(ke.getMessage(), (Throwable)ke);
                    }
                    if (!shared) {
                        this.deploymentOptionsMap.put(deploymentIdentity2, deploymentOptions);
                        try {
                            this.driveInstallPipeline(normalisedUri, installNode);
                        }
                        catch (DeploymentException de) {
                            this.removeFromModel(deploymentIdentity2);
                            this.destroyInstallGraph(installNode);
                            throw de;
                        }
                        catch (RuntimeException re) {
                            this.removeFromModel(deploymentIdentity2);
                            this.destroyInstallGraph(installNode);
                            throw re;
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 7] lbl45 : MonitorExitStatement: MONITOREXIT : var3_3
                    deploymentIdentity = deploymentIdentity2;
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ArtifactIdentity determineIdentity(URI artifactUri) throws DeploymentException {
        try {
            try {
                ArtifactIdentity artifactIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                try {
                    File artifact = new File(artifactUri);
                    if (!artifact.exists()) {
                        throw new DeploymentException(artifact + " does not exist");
                    }
                    artifactIdentity = this.determineIdentity(artifact, null);
                }
                catch (Exception e) {
                    throw new DeploymentException(String.valueOf(e.getMessage()) + ": uri='" + artifactUri + "'", (Throwable)e);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return artifactIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private GraphNode<InstallArtifact> findSharedNode(ArtifactIdentity artifactIdentity) {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                GCRoots gcRoots = (GCRoots)((Object)this.ram);
                GraphNode<InstallArtifact> graphNode = ExistingNodeLocator.findSharedNode(gcRoots, artifactIdentity);
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return graphNode;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void destroyInstallGraph(GraphNode<InstallArtifact> installGraph) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                ((InstallArtifact)installGraph.getValue()).uninstall();
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void removeFromModel(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
                this.ram.delete(deploymentIdentity);
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private DeploymentIdentity refreshExistingArtifact(URI normalisedLocation, InstallArtifact existingArtifact) throws DeploymentException {
        try {
            try {
                DeploymentIdentity deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
                String oldType = existingArtifact.getType();
                String oldName = existingArtifact.getName();
                Version oldVersion = existingArtifact.getVersion();
                DeploymentIdentity deploymentIdentity2 = this.refreshArtifact(normalisedLocation, existingArtifact);
                if (deploymentIdentity2 != null) {
                    deploymentIdentity = deploymentIdentity2;
                } else {
                    StandardDeploymentIdentity oldDeploymentIdentity = new StandardDeploymentIdentity(oldType, oldName, oldVersion.toString());
                    this.undeployInternal(oldDeploymentIdentity, true, false);
                    deploymentIdentity = null;
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIdentity deploy(URI location, DeploymentOptions deploymentOptions) throws DeploymentException {
        try {
            try {
                InstallArtifact installedArtifact;
                DeploymentIdentity deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_10);
                URI normalisedLocation = this.normaliseDeploymentUri(location);
                Object object = this.monitor;
                synchronized (object) {
                    deploymentIdentity = this.install(location, deploymentOptions);
                    installedArtifact = this.ram.get(normalisedLocation);
                }
                try {
                    this.start(installedArtifact, deploymentOptions.getSynchronous());
                }
                catch (DeploymentException de) {
                    Object object2 = this.monitor;
                    synchronized (object2) {
                        this.stopArtifact(installedArtifact);
                        this.uninstallArtifact(installedArtifact);
                    }
                    throw de;
                }
                this.deploymentListener.deployed(normalisedLocation, deploymentOptions);
                DeploymentIdentity deploymentIdentity2 = deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_10);
                return deploymentIdentity2;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_10);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private DeploymentIdentity refreshArtifact(URI location, InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_11);
                StandardDeploymentIdentity deploymentIdentity = null;
                if (installArtifact.refresh()) {
                    this.deploymentListener.refreshed(location);
                    deploymentIdentity = new StandardDeploymentIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion().toString());
                }
                StandardDeploymentIdentity standardDeploymentIdentity = deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_11);
                return standardDeploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_11);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeploymentIdentity deploy(String type, String name, Version version) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_12);
                throw new UnsupportedOperationException("PipelinedApplicationDeployer ApplicationDeployer does not support deployment by type, name, and version");
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_12);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeploymentIdentity deploy(String type, String name, Version version, DeploymentOptions options) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_13);
                throw new UnsupportedOperationException("PipelinedApplicationDeployer ApplicationDeployer does not support deployment by type, name, and version");
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_13);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private DeploymentIdentity addGraphToModel(URI location, GraphNode<InstallArtifact> installGraph) throws DuplicateFileNameException, DuplicateLocationException, DuplicateDeploymentIdentityException, DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_14);
                InstallArtifact installArtifact = (InstallArtifact)installGraph.getValue();
                ((AbstractInstallArtifact)installArtifact).setTopLevelDeployed();
                DeploymentIdentity deploymentIdentity = this.ram.add(location, installArtifact);
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_14);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_14);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void recoverDeployment(URI uri, DeploymentOptions options) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_15);
                GraphNode<InstallArtifact> installNode = null;
                boolean shared = false;
                File artifact = new File(uri);
                if (options.getRecoverable() && (!options.getDeployerOwned() || artifact.exists())) {
                    ArtifactIdentity artifactIdentity = this.determineIdentity(artifact, null);
                    installNode = this.findSharedNode(artifactIdentity);
                    if (installNode == null) {
                        installNode = this.installArtifactGraphInclosure.recoverInstallGraph(artifactIdentity, artifact);
                    } else {
                        shared = true;
                    }
                }
                if (installNode == null) {
                    this.deploymentListener.undeployed(uri);
                } else {
                    if (!shared) {
                        this.driveInstallPipeline(uri, installNode);
                        this.start((InstallArtifact)installNode.getValue(), options.getSynchronous());
                    }
                    try {
                        this.addGraphToModel(uri, installNode);
                    }
                    catch (KernelException e) {
                        throw new DeploymentException(e.getMessage(), (Throwable)e);
                    }
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_15);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_15);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ArtifactIdentity determineIdentity(File file, String scopeName) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_16);
                ArtifactIdentity artifactIdentity = this.artifactIdentityDeterminer.determineIdentity(file, scopeName);
                if (artifactIdentity == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.INDETERMINATE_ARTIFACT_TYPE, new Object[]{file});
                    throw new DeploymentException("Cannot determine the artifact identity of the file '" + file + "'");
                }
                ArtifactIdentity artifactIdentity2 = artifactIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_16);
                return artifactIdentity2;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_16);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void driveInstallPipeline(URI uri, GraphNode<InstallArtifact> installGraph) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_17);
                this.refreshWatchedRepositories();
                InstallEnvironment installEnvironment = this.installEnvironmentFactory.createInstallEnvironment((InstallArtifact)installGraph.getValue());
                try {
                    try {
                        this.pipeline.process(installGraph, installEnvironment);
                    }
                    catch (UnableToSatisfyBundleDependenciesException utsbde) {
                        this.logDependencySatisfactionException(uri, (UnableToSatisfyDependenciesException)((Object)utsbde));
                        throw new DeploymentException("Dependency satisfaction failed", (Throwable)utsbde);
                    }
                }
                finally {
                    installEnvironment.destroy();
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_17);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_17);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void logDependencySatisfactionException(URI uri, UnableToSatisfyDependenciesException ex) {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_18);
                this.eventLogger.log((LogEvent)DeployerLogEvents.UNABLE_TO_SATISFY_CONSTRAINTS, (Throwable)ex, new Object[]{uri, ex.getSymbolicName(), ex.getVersion(), ex.getFailureDescription()});
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_18);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_18);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void start(InstallArtifact installArtifact, boolean synchronous) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_19);
                BlockingAbortableSignal blockingSignal = new BlockingAbortableSignal(synchronous);
                installArtifact.start(blockingSignal);
                if (synchronous && this.deployerConfiguredTimeoutInSeconds > 0) {
                    boolean complete = blockingSignal.awaitCompletion(this.deployerConfiguredTimeoutInSeconds);
                    if (blockingSignal.isAborted()) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.START_ABORTED, new Object[]{installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), this.deployerConfiguredTimeoutInSeconds});
                    } else if (!complete) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.START_TIMED_OUT, new Object[]{installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), this.deployerConfiguredTimeoutInSeconds});
                    }
                } else {
                    blockingSignal.checkComplete();
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_19);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_19);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIdentity[] getDeploymentIdentities() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return this.ram.getDeploymentIdentities();
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIdentity getDeploymentIdentity(URI location) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                InstallArtifact installArtifact = this.ram.get(location);
                if (installArtifact != null) {
                    return this.getDeploymentIdentity(installArtifact);
                }
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private DeploymentIdentity getDeploymentIdentity(InstallArtifact installArtifact) {
        try {
            return new StandardDeploymentIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion().toString());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDeployed(URI location) {
        try {
            try {
                boolean bl;
                block11: {
                    URI normalisedLocation;
                    PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_20);
                    try {
                        normalisedLocation = this.deployUriNormaliser.normalise(location);
                    }
                    catch (DeploymentException deploymentException) {
                        bl = false;
                        break block11;
                    }
                    if (normalisedLocation == null) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.UNSUPPORTED_URI_SCHEME, new Object[]{location.toString(), location.getScheme()});
                        bl = false;
                    } else {
                        boolean bl2;
                        Object object = this.monitor;
                        synchronized (object) {
                            bl2 = this.ram.get(normalisedLocation) != null;
                        }
                        bl = bl2;
                    }
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_20);
                return bl;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_20);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIdentity refresh(URI location, String symbolicName) throws DeploymentException {
        try {
            try {
                DeploymentIdentity deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_21);
                URI normalisedLocation = this.deployUriNormaliser.normalise(location);
                if (normalisedLocation == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.UNSUPPORTED_URI_SCHEME, new Object[]{location.toString(), location.getScheme()});
                    throw new DeploymentException("PipelinedApplicationDeployer.refresh does not support '" + location.getScheme() + "' scheme URIs");
                }
                Object object = this.monitor;
                synchronized (object) {
                    DeploymentIdentity originalDeploymentIdentity;
                    InstallArtifact installArtifact = this.ram.get(normalisedLocation);
                    if (installArtifact == null) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_URI_NOT_FOUND, new Object[]{location.toString()});
                        throw new DeploymentException("Refresh not possible as no application is deployed from URI " + location);
                    }
                    deploymentIdentity = originalDeploymentIdentity = this.getDeploymentIdentity(installArtifact);
                    try {
                        if (this.refreshInternal(symbolicName, installArtifact)) {
                            this.deploymentListener.refreshed(normalisedLocation);
                        } else {
                            DeploymentOptions deploymentOptions = this.deploymentOptionsMap.get(deploymentIdentity);
                            if (deploymentOptions == null) {
                                deploymentOptions = DeploymentOptions.DEFAULT_DEPLOYMENT_OPTIONS;
                            }
                            deploymentIdentity = this.redeploy(originalDeploymentIdentity, normalisedLocation, deploymentOptions);
                        }
                        this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_COMPLETED, new Object[]{symbolicName, originalDeploymentIdentity.getType(), originalDeploymentIdentity.getSymbolicName(), originalDeploymentIdentity.getVersion()});
                    }
                    catch (RuntimeException e) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_FAILED, (Throwable)e, new Object[]{symbolicName, originalDeploymentIdentity.getType(), originalDeploymentIdentity.getSymbolicName(), originalDeploymentIdentity.getVersion()});
                        throw e;
                    }
                    catch (Exception e) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_FAILED, (Throwable)e, new Object[]{symbolicName, originalDeploymentIdentity.getType(), originalDeploymentIdentity.getSymbolicName(), originalDeploymentIdentity.getVersion()});
                        throw new DeploymentException("refresh failed", (Throwable)e);
                    }
                }
                DeploymentIdentity deploymentIdentity2 = deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_21);
                return deploymentIdentity2;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_21);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean refreshInternal(String symbolicName, InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_22);
                boolean bl = installArtifact instanceof PlanInstallArtifact ? ((PlanInstallArtifact)installArtifact).refresh(symbolicName) : installArtifact.refresh();
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_22);
                return bl;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_22);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentIdentity redeploy(DeploymentIdentity toUndeploy, URI toDeploy, DeploymentOptions deploymentOptions) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_23);
                Object object = this.monitor;
                synchronized (object) {
                    this.undeployInternal(toUndeploy, true, false);
                }
                DeploymentIdentity deploymentIdentity = this.deploy(toDeploy, deploymentOptions);
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_23);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_23);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshBundle(String bundleSymbolicName, String bundleVersion) throws DeploymentException {
        try {
            try {
                InstallArtifact bundleInstallArtifact;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_24);
                StandardDeploymentIdentity deploymentIdentity = new StandardDeploymentIdentity(BUNDLE_TYPE, bundleSymbolicName, bundleVersion);
                Object object = this.monitor;
                synchronized (object) {
                    bundleInstallArtifact = this.ram.get(deploymentIdentity);
                }
                if (bundleInstallArtifact == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_ARTEFACT_NOT_FOUND, new Object[]{BUNDLE_TYPE, bundleSymbolicName, bundleVersion});
                    throw new DeploymentException("Refresh not possible as no bundle with name " + bundleSymbolicName + " and version " + bundleVersion + " is deployed");
                }
                bundleInstallArtifact.refresh();
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_24);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_24);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void undeploy(String symbolicName, String version) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_25);
                DeploymentException de = null;
                try {
                    this.undeploy(BUNDLE_TYPE, symbolicName, version);
                }
                catch (DeploymentException e) {
                    de = e;
                    try {
                        this.undeploy("par", symbolicName, version);
                    }
                    catch (DeploymentException e2) {
                        de = e2;
                        try {
                            this.undeploy("plan", symbolicName, version);
                        }
                        catch (DeploymentException e3) {
                            de = e3;
                            try {
                                this.undeploy("properties", symbolicName, version);
                            }
                            catch (DeploymentException e4) {
                                de = e4;
                                throw de;
                            }
                        }
                    }
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_25);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_25);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(String type, String symbolicName, String version) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_26);
                StandardDeploymentIdentity deploymentIdentity = new StandardDeploymentIdentity(type, symbolicName, version);
                Object object = this.monitor;
                synchronized (object) {
                    this.undeployInternal(deploymentIdentity, false, false);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_26);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_26);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_27);
                Object object = this.monitor;
                synchronized (object) {
                    this.undeployInternal(deploymentIdentity, false, false);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_27);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_27);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentIdentity deploymentIdentity, boolean deleted) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_28);
                Object object = this.monitor;
                synchronized (object) {
                    this.undeployInternal(deploymentIdentity, false, true);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_28);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_28);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void undeployInternal(DeploymentIdentity deploymentIdentity, boolean redeploying, boolean deleted) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_29);
                DeploymentOptions options = this.deploymentOptionsMap.remove(deploymentIdentity);
                URI location = this.doUndeploy(deploymentIdentity);
                if (location != null && !redeploying) {
                    this.deleteArtifactIfNecessary(location, options, deleted);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_29);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_29);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void deleteArtifactIfNecessary(URI location, DeploymentOptions options, boolean deleted) {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_30);
                if (options != null && options.getDeployerOwned() && !deleted) {
                    new PathReference(location).delete(true);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_30);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_30);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI doUndeploy(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        try {
            try {
                URI uRI;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_31);
                Object object = this.monitor;
                synchronized (object) {
                    InstallArtifact installArtifact = this.ram.get(deploymentIdentity);
                    if (installArtifact == null) {
                        String type = deploymentIdentity.getType();
                        String symbolicName = deploymentIdentity.getSymbolicName();
                        String version = deploymentIdentity.getVersion();
                        this.eventLogger.log((LogEvent)DeployerLogEvents.UNDEPLOY_ARTEFACT_NOT_FOUND, new Object[]{type, symbolicName, version});
                        throw new DeploymentException("Undeploy not possible as no " + type + " with name " + symbolicName + " and version " + version + " is deployed");
                    }
                    URI location = this.ram.getLocation(deploymentIdentity);
                    this.ram.delete(deploymentIdentity);
                    this.stopArtifact(installArtifact);
                    this.uninstallArtifact(installArtifact);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl19 : MonitorExitStatement: MONITOREXIT : var2_2
                    uRI = location;
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_31);
                return uRI;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_31);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void stopArtifact(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_32);
                installArtifact.stop();
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_32);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_32);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void uninstallArtifact(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_33);
                installArtifact.uninstall();
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_33);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_33);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void refreshWatchedRepositories() {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_34);
                try {
                    Collection references = this.bundleContext.getServiceReferences(WatchableRepository.class, null);
                    for (ServiceReference reference : references) {
                        WatchableRepository watchableRepository = (WatchableRepository)this.bundleContext.getService(reference);
                        try {
                            watchableRepository.forceCheck();
                        }
                        catch (Exception exception) {
                            String name = watchableRepository instanceof Repository ? ((Repository)watchableRepository).getName() : "unknown repository type";
                            this.eventLogger.log((LogEvent)DeployerLogEvents.WATCHED_REPOSITORY_REFRESH_FAILED, new Object[]{name});
                        }
                        this.bundleContext.ungetService(reference);
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.WATCHED_REPOSITORIES_REFRESH_FAILED, new Object[0]);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_34);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_34);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeploymentIdentity[] bulkDeploy(List<URI> arg0, DeploymentOptions arg1) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_35);
                throw new UnsupportedOperationException();
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_35);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("PipelinedApplicationDeployer.java", Class.forName("org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:", "location:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 117);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "normaliseDeploymentUri", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:", "uri:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "java.net.URI"), 123);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions:", "location:deploymentOptions:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 247);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "refreshArtifact", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "location:installArtifact:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 273);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:java.lang.String:org.osgi.framework.Version:", "type:name:version:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 287);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:java.lang.String:org.osgi.framework.Version:org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions:", "type:name:version:options:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 295);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addGraphToModel", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.util.common.GraphNode:", "location:installGraph:", "org.eclipse.virgo.kernel.deployer.model.DuplicateFileNameException:org.eclipse.virgo.kernel.deployer.model.DuplicateLocationException:org.eclipse.virgo.kernel.deployer.model.DuplicateDeploymentIdentityException:org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 301);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "recoverDeployment", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions:", "uri:options:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 311);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineIdentity", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.io.File:java.lang.String:", "file:scopeName:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity"), 343);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "driveInstallPipeline", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.util.common.GraphNode:", "uri:installGraph:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 355);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "logDependencySatisfactionException", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyDependenciesException:", "uri:ex:", "", "void"), 369);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "start", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:boolean:", "installArtifact:synchronous:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 374);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "install", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:", "location:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 134);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDeployed", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:", "location:", "", "boolean"), 423);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:java.lang.String:", "location:symbolicName:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 441);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "refreshInternal", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "symbolicName:installArtifact:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "boolean"), 485);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "redeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity:java.net.URI:org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions:", "toUndeploy:toDeploy:deploymentOptions:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 493);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshBundle", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:java.lang.String:", "bundleSymbolicName:bundleVersion:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 503);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "undeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:java.lang.String:", "symbolicName:version:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 522);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "undeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:java.lang.String:java.lang.String:", "type:symbolicName:version:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 559);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "undeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity:", "deploymentIdentity:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 569);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "undeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity:boolean:", "deploymentIdentity:deleted:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 578);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "undeployInternal", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity:boolean:boolean:", "deploymentIdentity:redeploying:deleted:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 599);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "install", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions:", "uri:deploymentOptions:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 138);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteArtifactIfNecessary", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions:boolean:", "location:options:deleted:", "", "void"), 607);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doUndeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity:", "deploymentIdentity:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "java.net.URI"), 613);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "stopArtifact", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 636);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "uninstallArtifact", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 641);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "refreshWatchedRepositories", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "", "", "", "void"), 646);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "bulkDeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.util.List:org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions:", "arg0:arg1:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "[Lorg.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity;"), 670);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doInstall", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions:", "normalisedUri:deploymentOptions:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 147);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineIdentity", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:", "artifactUri:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity"), 203);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findSharedNode", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:", "artifactIdentity:", "", "org.eclipse.virgo.util.common.GraphNode"), 215);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "destroyInstallGraph", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.util.common.GraphNode:", "installGraph:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 220);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeFromModel", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity:", "deploymentIdentity:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 224);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "refreshExistingArtifact", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "normalisedLocation:existingArtifact:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity"), 228);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer");
    }
}

