/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.ClientExceptionTranslator;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpAsyncConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpAsyncExchange;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingBase;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.HttpAsyncClient;

public class HttpAsyncProtocolBindingImpl
extends HttpProtocolBindingBase {
    private CloseableHttpAsyncClient _client;

    public HttpAsyncProtocolBindingImpl(URI serverUri, Executor executor, ServerEndpointProvider endpointProvider, HttpConfiguration config) {
        super(serverUri, executor, endpointProvider, config);
        if (config == null) {
            throw new IllegalArgumentException("Client HTTP configuration is required");
        }
        if (!(this.getConfiguration().getCompiledConfiguration() instanceof CompiledHttpAsyncConfigurationImpl)) {
            throw new IllegalArgumentException("Configuration used for sync clients can not be used for async clients");
        }
        CompiledHttpAsyncConfigurationImpl compiledConfig = (CompiledHttpAsyncConfigurationImpl)this.getConfiguration().getCompiledConfiguration();
        this._client = compiledConfig.getApacheClient();
        this.setCompressionSupport(this.resolveServerCompressionSupport());
    }

    @Override
    public void send(Request request, Response response, boolean sync) {
        HttpAsyncExchange exchange = new HttpAsyncExchange(request, response, this.getConfiguration().getCompiledConfiguration(), (HttpAsyncClient)this._client, this.getEndpointUri(), this.getServerCompressionSupport() == HttpConfiguration.CompressionSupport.ENABLE, this.getInvocationInterceptor(), this, sync);
        this.executeRunnable(exchange, sync);
    }

    @Override
    public Object getImpl() {
        return this._client;
    }

    @Override
    protected HttpResponse executeRequest(HttpUriRequest options) {
        try {
            return (HttpResponse)this._client.execute(options, null).get();
        }
        catch (InterruptedException e) {
            throw new InternalException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                throw ClientExceptionTranslator.translateAny((Exception)e.getCause());
            }
            throw (Error)e.getCause();
        }
    }
}

