/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerBase;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vim.vmomi.client.http.impl.VlsiSslSocketFactory;
import com.vmware.vise.aspect.vlsi.client.thread.HttpConfigurationCompilerBaseAspect;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.ConnPoolControl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class HttpConfigurationCompilerImpl
extends HttpConfigurationCompilerBase {
    private static final Log LOG = LogFactory.getLog(HttpConfigurationCompilerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompiledHttpConfiguration compile(HttpClientConfiguration clientConfig) {
        HttpConfigurationImpl config;
        HttpConfigurationImpl httpConfigurationImpl = config = (HttpConfigurationImpl)clientConfig.getHttpConfiguration();
        synchronized (httpConfigurationImpl) {
            if (config.getCompiledConfiguration() != null && config.getCompiledConfiguration().isActive()) {
                return config.getCompiledConfiguration();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Compiling HttpConfiguration:\n" + config));
            }
            PoolingHttpClientConnectionManager connManager = this.createClientConnectionManager(config);
            ConnectionMonitorThread connectionMonitor = new ConnectionMonitorThread(connManager, config.getKeepAlivePeriod());
            connectionMonitor.start();
            CompiledHttpConfigurationImpl result = new CompiledHttpConfigurationImpl((HttpClientConnectionManager)connManager, config.getCompressionSupport(), config.getKeepAlivePeriod(), connectionMonitor);
            config.resetCompiledConfiguration();
            config.setCompiledConfiguration(result);
            return result;
        }
    }

    protected PoolingHttpClientConnectionManager createClientConnectionManager(HttpConfiguration config) {
        Registry<ConnectionSocketFactory> registry = this.createConnectionSocketFactoryRegistry(config);
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
        connManager.setMaxTotal(config.getMaxConnections());
        connManager.setDefaultMaxPerRoute(config.getDefaultMaxConnectionsPerRoute());
        for (HttpConfiguration.RouteConfiguration route : config.getRouteConfigurations()) {
            HttpHost host = new HttpHost(route.getHostName(), route.getPort(), route.getScheme());
            connManager.setMaxPerRoute(new HttpRoute(host), route.getMaxConnections());
        }
        return connManager;
    }

    protected Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry(HttpConfiguration config) {
        ThumbprintTrustManager trustManager = this.createThumbprintTrustManager(config);
        SSLContext sslContext = this.createSSLContext(config, trustManager);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new VlsiSslSocketFactory(sslContext, config.getEnabledProtocols(), null, new ThumbprintTrustManager.HostnameVerifier(trustManager))).build();
        return socketFactoryRegistry;
    }

    private static final class ConnectionMonitorThread
    extends HttpConfigurationCompilerBase.ConnectionMonitorThreadBase {
        private final HttpClientConnectionManager connManager;
        private final long keepAlivePeriod;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public ConnectionMonitorThread(PoolingHttpClientConnectionManager connManager, long keepAlivePeriod) {
            super((ConnPoolControl<HttpRoute>)connManager);
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = connManager;
            long l = keepAlivePeriod;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)poolingHttpClientConnectionManager, (Object)Conversions.longObject((long)l));
            this.keepAlivePeriod = keepAlivePeriod;
            this.connManager = connManager;
            HttpConfigurationCompilerBaseAspect.aspectOf().logStackTrace(joinPoint);
        }

        @Override
        protected void closeConnections() {
            this.connManager.closeExpiredConnections();
            this.connManager.closeIdleConnections(this.keepAlivePeriod, TimeUnit.MILLISECONDS);
        }

        static {
            ConnectionMonitorThread.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("HttpConfigurationCompilerImpl.java", ConnectionMonitorThread.class);
            ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerImpl$ConnectionMonitorThread", "org.apache.http.impl.conn.PoolingHttpClientConnectionManager:long", "connManager:keepAlivePeriod", ""), 59);
        }
    }
}

