/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.security.impl;

import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.XmlParserFactory;
import com.vmware.vim.vmomi.client.security.MessageSigner;
import com.vmware.vim.vmomi.core.exception.MessageSignException;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.core.soap.impl.CalendarHelper;
import com.vmware.vim.vmomi.core.util.CharSequenceReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MessageSignerImpl
implements MessageSigner {
    private static final String SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private ThreadLocal<DocumentBuilder> _documentBuilder = new ThreadLocal();

    private void initDocumentBuilder() throws MessageSignException {
        if (this._documentBuilder.get() == null) {
            try {
                this._documentBuilder.set(XmlParserFactory.Factory.createSecureXmlParserFactory().newDocumentBuilder());
            }
            catch (ParserConfigurationException e) {
                throw new MessageSignException("Failed to create secure DocumentBuilder", (Throwable)e);
            }
        }
    }

    @Override
    public void signMessage(CharSequence message, SignInfo signInfo, OutputStream os) {
        this.initDocumentBuilder();
        try {
            this._documentBuilder.get().reset();
            Document doc = this._documentBuilder.get().parse(new InputSource((Reader)new CharSequenceReader(message)));
            boolean shouldSign = ConfirmationType.HOLDER_OF_KEY == signInfo.getSamlToken().getConfirmationType();
            Node security = this.addSecuritySkeleton(doc, shouldSign);
            this._documentBuilder.get().reset();
            Element samlToken = this._documentBuilder.get().parse(new InputSource(new StringReader(signInfo.getSamlToken().toXml()))).getDocumentElement();
            security.appendChild(doc.importNode(samlToken, true));
            if (shouldSign) {
                this.insertTimeStamp(doc, security, signInfo.getMessageValidity());
                XMLSignatureFactory sigFac = XMLSignatureFactory.getInstance("DOM");
                DigestMethod digestMethod = sigFac.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
                List<Transform> transformations = Arrays.asList(sigFac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null));
                List<Reference> refList = Arrays.asList(sigFac.newReference("#wssu-timestamp", digestMethod, transformations, null, null), sigFac.newReference("#body", digestMethod, transformations, null, null));
                CanonicalizationMethod cm = sigFac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
                SignatureMethod sm = sigFac.newSignatureMethod(SIGNATURE_METHOD, null);
                SignedInfo signedInfo = sigFac.newSignedInfo(cm, sm, refList);
                DOMSignContext dsc = new DOMSignContext(signInfo.getSignerPrivateKey(), security);
                KeyInfo keyInfo = this.createKeyInfo(doc, signInfo.getSamlToken().getId());
                sigFac.newXMLSignature(signedInfo, keyInfo).sign(dsc);
            }
            Transformer transformation = TransformerFactory.newInstance().newTransformer();
            transformation.transform(new DOMSource(doc), new StreamResult(os));
        }
        catch (SAXException e) {
            throw new MessageSignException("Unable to sign message", (Throwable)e);
        }
        catch (MarshalException e) {
            throw new MessageSignException("Unable to sign message", (Throwable)e);
        }
        catch (XMLSignatureException e) {
            throw new MessageSignException("Unable to sign message", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new MessageSignException("Unable to sign message", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new MessageSignException("Unable to sign message", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new MessageSignException("Unable to sign message", (Throwable)e);
        }
        catch (IOException e) {
            throw new MessageSignException("Unable to sign message", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MessageSignException("Unable to sign message", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MessageSignException("Unable to sign message", (Throwable)e);
        }
    }

    private Node addSecuritySkeleton(Document doc, boolean shouldSetIds) {
        Element header;
        Element body = MessageSignerImpl.findSingleElement(doc, Constants.BODY_QNAME);
        if (shouldSetIds) {
            if (body == null) {
                throw new MessageSignException("The document specified does not contain body element!");
            }
            this.setElementWSUId(body, "body");
        }
        if ((header = MessageSignerImpl.findSingleElement(doc, Constants.HEADER_QNAME)) == null) {
            header = MessageSignerImpl.createElementQName(doc, Constants.HEADER_QNAME);
            if (body.getPrefix() != null) {
                header.setPrefix(body.getPrefix());
            }
            doc.getDocumentElement().insertBefore(header, body);
        }
        Element security = MessageSignerImpl.createElementQName(doc, Constants.SECURITY_QNAME);
        security.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        return header.appendChild(security);
    }

    private void setElementWSUId(Element element, String id) {
        String existingId = element.getAttributeNS(Constants.WSU_ID_QNAME.getNamespaceURI(), Constants.WSU_ID_QNAME.getLocalPart());
        if (!"".equals(existingId) && !id.equals(existingId)) {
            throw new MessageSignException("Error setting id to element " + element.getLocalName() + " - id already set to " + existingId);
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        element.setAttributeNS(Constants.WSU_ID_QNAME.getNamespaceURI(), Constants.WSU_ID_QNAME.getPrefix() + ":" + Constants.WSU_ID_QNAME.getLocalPart(), id);
        element.setIdAttributeNS(Constants.WSU_ID_QNAME.getNamespaceURI(), Constants.WSU_ID_QNAME.getLocalPart(), true);
    }

    private KeyInfo createKeyInfo(Document ownerDocument, String samlTokenId) {
        KeyInfoFactory kiFactory = KeyInfoFactory.getInstance();
        Element securityTokenRefNode = MessageSignerImpl.createElementQName(ownerDocument, Constants.SECURITY_TOKEN_REFERENCE_QNAME);
        securityTokenRefNode.setAttributeNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:TokenType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        Element keyIdentifierNode = MessageSignerImpl.createElementQName(ownerDocument, Constants.KEY_IDENTIFIER_QNAME);
        keyIdentifierNode.setAttribute("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
        keyIdentifierNode.setTextContent(samlTokenId);
        securityTokenRefNode.appendChild(keyIdentifierNode);
        return kiFactory.newKeyInfo(Collections.singletonList(new DOMStructure(securityTokenRefNode)));
    }

    private void insertTimeStamp(Document doc, Node security, int messageValidity) {
        Element timestampNode = MessageSignerImpl.createElementQName(doc, Constants.TIMESTAMP_QNAME);
        security.appendChild(timestampNode);
        this.setElementWSUId(timestampNode, "wssu-timestamp");
        Element createdNode = MessageSignerImpl.createElementQName(doc, Constants.TIMESTAMP_CREATED_QNAME);
        timestampNode.appendChild(createdNode);
        Element expiresNode = MessageSignerImpl.createElementQName(doc, Constants.TIMESTAMP_EXPIRES_QNAME);
        timestampNode.appendChild(expiresNode);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.getDefault());
        createdNode.setTextContent(CalendarHelper.formatXsdDateTime((Calendar)calendar));
        calendar.add(13, messageValidity);
        expiresNode.setTextContent(CalendarHelper.formatXsdDateTime((Calendar)calendar));
    }

    private static Element createElementQName(Document doc, QName element) {
        String createNsUri = "".equals(element.getNamespaceURI()) ? null : element.getNamespaceURI();
        String createPrefixedName = element.getPrefix() == null ? element.getLocalPart() : element.getPrefix() + ":" + element.getLocalPart();
        return doc.createElementNS(createNsUri, createPrefixedName);
    }

    private static Element findSingleElement(Document doc, QName name) {
        NodeList nodeList = doc.getElementsByTagNameNS(name.getNamespaceURI(), name.getLocalPart());
        if (nodeList.getLength() > 1) {
            throw new MessageSignException("Multiple elements of type " + name.toString() + " in document (but only one expected)");
        }
        return nodeList.getLength() == 0 ? null : (Element)nodeList.item(0);
    }
}

